/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.common.internal.annotations.registry;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jem.util.RegistryReader;
import org.eclipse.jst.common.internal.annotations.registry.TagsetDescriptor;

public class AnnotationTagsetRegistry
extends RegistryReader {
    public static final AnnotationTagsetRegistry INSTANCE = new AnnotationTagsetRegistry();
    private Map index;
    private List descriptors;

    protected AnnotationTagsetRegistry() {
        super("org.eclipse.wst.common.internal.annotations.controller", "AnnotationTagSet");
        this.readRegistry();
    }

    public boolean readElement(IConfigurationElement element) {
        if ("AnnotationTagSet".equals(element.getName())) {
            this.getDescriptors().add(new TagsetDescriptor(element));
            return true;
        }
        return false;
    }

    public TagsetDescriptor getDescriptor(String name) {
        if (name != null && name.length() > 0) {
            TagsetDescriptor descriptor = (TagsetDescriptor)this.getIndex().get(name);
            if (descriptor != null) {
                return descriptor;
            }
            Iterator itr = INSTANCE.getDescriptors().iterator();
            while (itr.hasNext()) {
                descriptor = (TagsetDescriptor)itr.next();
                if (!name.equals(descriptor.getName())) continue;
                this.getIndex().put(descriptor.getName(), descriptor);
                return descriptor;
            }
        }
        return null;
    }

    protected List getDescriptors() {
        if (this.descriptors == null) {
            this.descriptors = new ArrayList();
        }
        return this.descriptors;
    }

    protected Map getIndex() {
        if (this.index == null) {
            this.index = new HashMap();
        }
        return this.index;
    }

    public void registerTagset(TagsetDescriptor descriptor) {
        if (descriptor != null && this.getDescriptor(descriptor.getName()) == null) {
            this.getDescriptors().add(descriptor);
        }
    }
}

