/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.ui.internal.java.search.ui;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.ui.search.ElementQuerySpecification;
import org.eclipse.jdt.ui.search.IMatchPresentation;
import org.eclipse.jdt.ui.search.IQueryParticipant;
import org.eclipse.jdt.ui.search.ISearchRequestor;
import org.eclipse.jdt.ui.search.PatternQuerySpecification;
import org.eclipse.jdt.ui.search.QuerySpecification;
import org.eclipse.jst.jsp.core.internal.java.search.JSPSearchScope;
import org.eclipse.jst.jsp.core.internal.java.search.JSPSearchSupport;
import org.eclipse.jst.jsp.ui.internal.java.search.JSPSearchRequestor;
import org.eclipse.jst.jsp.ui.internal.java.search.ui.JSPMatchPresentation;

public class JSPQueryParticipant
implements IQueryParticipant {
    private static final boolean DEBUG;

    static {
        String value = Platform.getDebugOption((String)"org.eclipse.jst.jsp.core/debug/jspsearch");
        DEBUG = value != null && value.equalsIgnoreCase("true");
    }

    public void search(ISearchRequestor requestor, QuerySpecification querySpecification, IProgressMonitor monitor) throws CoreException {
        if (querySpecification instanceof ElementQuerySpecification) {
            ElementQuerySpecification elementQuery = (ElementQuerySpecification)querySpecification;
            IJavaElement element = elementQuery.getElement();
            if (DEBUG) {
                System.out.println("JSP Query Participant searching on ELEMENT: " + element);
            }
            JSPSearchRequestor jspRequestor = new JSPSearchRequestor(requestor);
            JSPSearchSupport.getInstance().search(element, (IJavaSearchScope)new JSPSearchScope(), (SearchRequestor)jspRequestor);
        } else if (querySpecification instanceof PatternQuerySpecification) {
            PatternQuerySpecification patternQuery = (PatternQuerySpecification)querySpecification;
            String pattern = patternQuery.getPattern();
            if (DEBUG) {
                System.out.println("JSP Query Participant searching on PATTERN: " + pattern);
            }
            JSPSearchRequestor jspRequestor = new JSPSearchRequestor(requestor);
            JSPSearchSupport.getInstance().search(pattern, (IJavaSearchScope)new JSPSearchScope(), patternQuery.getSearchFor(), patternQuery.getLimitTo(), 2, false, (SearchRequestor)jspRequestor);
        }
    }

    public int estimateTicks(QuerySpecification data) {
        return 0;
    }

    public IMatchPresentation getUIParticipant() {
        return new JSPMatchPresentation();
    }
}

