/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.internal.project.facet;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.common.project.facet.core.ClasspathHelper;
import org.eclipse.jst.j2ee.classpathdep.ClasspathDependencyUtil;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.j2ee.webapplication.Servlet;
import org.eclipse.jst.javaee.web.WebApp;
import org.eclipse.jst.jsf.core.internal.JSFCorePlugin;
import org.eclipse.jst.jsf.core.internal.jsflibraryconfig.JSFLibraryInternalReference;
import org.eclipse.jst.jsf.core.internal.jsflibraryconfig.JSFLibraryRegistryUtil;
import org.eclipse.jst.jsf.core.internal.project.facet.IJSFFacetInstallDataModelProperties;
import org.eclipse.jst.jsf.core.internal.project.facet.JSFUtils11;
import org.eclipse.jst.jsf.core.internal.project.facet.JSFUtils12;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IDelegate;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public final class JSFFacetInstallDelegate
implements IDelegate {
    public void execute(IProject project, IProjectFacetVersion fv, Object cfg, IProgressMonitor monitor) throws CoreException {
        if (monitor != null) {
            monitor.beginTask("", 1);
        }
        try {
            IDataModel config = null;
            if (cfg == null) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.jst.jsf.core", "Internal Error creating JSF Facet.  Missing configuration."));
            }
            config = (IDataModel)cfg;
            this.createClasspathEntries(project, fv, config, monitor);
            this.createConfigFile(project, fv, config, monitor);
            this.createServletAndModifyWebXML(project, config, monitor);
            if (monitor != null) {
                monitor.worked(1);
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private void createClasspathEntries(IProject project, IProjectFacetVersion fv, IDataModel config, IProgressMonitor monitor) {
        IJavaProject javaProject = JavaCore.create((IProject)project);
        ArrayList<IClasspathEntry> cpEntries = new ArrayList<IClasspathEntry>();
        try {
            int i = 0;
            while (i < javaProject.getRawClasspath().length) {
                cpEntries.add(javaProject.getRawClasspath()[i]);
                ++i;
            }
        }
        catch (JavaModelException e) {
            JSFCorePlugin.log((Exception)((Object)e), "Unable to read classpath");
        }
        Path cp = null;
        IClasspathEntry entry = null;
        JSFLibraryInternalReference libref = null;
        if (config.getProperty("IJSFFacetInstallDataModelProperties.IMPLEMENTATION_TYPE_PROPERTY_NAME") == IJSFFacetInstallDataModelProperties.IMPLEMENTATION_TYPE.USER_SPECIFIED) {
            cp = new Path("org.eclipse.jst.jsf.core.internal.jsflibrarycontainer");
            libref = (JSFLibraryInternalReference)config.getProperty("IJSFFacetInstallDataModelProperties.IMPLEMENTATION");
            IPath path = cp.append((IPath)new Path(libref.getID()));
            entry = this.getNewCPEntry(path, libref);
            cpEntries.add(entry);
        }
        JSFLibraryInternalReference[] compLibs = (JSFLibraryInternalReference[])config.getProperty("IJSFFacetInstallDataModelProperties.COMPONENT_LIBRARIES");
        int i = 0;
        while (i < compLibs.length) {
            cp = new Path("org.eclipse.jst.jsf.core.internal.jsflibrarycontainer");
            libref = compLibs[i];
            IPath path = cp.append((IPath)new Path(libref.getID()));
            entry = this.getNewCPEntry(path, libref);
            if (entry != null) {
                cpEntries.add(entry);
            }
            ++i;
        }
        JSFLibraryRegistryUtil.setRawClasspath(javaProject, cpEntries, monitor);
        if (config.getProperty("IJSFFacetInstallDataModelProperties.IMPLEMENTATION_TYPE_PROPERTY_NAME") == IJSFFacetInstallDataModelProperties.IMPLEMENTATION_TYPE.SERVER_SUPPLIED) {
            try {
                ClasspathHelper.removeClasspathEntries((IProject)project, (IProjectFacetVersion)fv);
                ClasspathHelper.addClasspathEntries((IProject)project, (IProjectFacetVersion)fv);
            }
            catch (CoreException e) {
                JSFCorePlugin.log(4, "Unable to add server supplied implementation to the classpath.", e);
            }
        }
    }

    private IClasspathEntry getNewCPEntry(IPath path, JSFLibraryInternalReference lib) {
        IClasspathEntry entry = null;
        if (lib.isCheckedToBeDeployed()) {
            IClasspathAttribute depAttrib = JavaCore.newClasspathAttribute((String)"org.eclipse.jst.component.dependency", (String)ClasspathDependencyUtil.getDefaultRuntimePath((boolean)true).toString());
            entry = JavaCore.newContainerEntry((IPath)path, null, (IClasspathAttribute[])new IClasspathAttribute[]{depAttrib}, (boolean)true);
        } else {
            entry = JavaCore.newContainerEntry((IPath)path);
        }
        return entry;
    }

    private List getServletMappings(IDataModel config) {
        ArrayList<String> mappings = new ArrayList<String>();
        String[] patterns = (String[])config.getProperty("IJSFFacetInstallDataModelProperties.SERVLET_URL_PATTERNS");
        int i = 0;
        while (i < patterns.length) {
            String pattern = patterns[i];
            mappings.add(pattern);
            ++i;
        }
        return mappings;
    }

    private IPath resolveConfigPath(IProject project, String jsfConfigPath) {
        return ComponentCore.createComponent((IProject)project).getRootFolder().getUnderlyingFolder().getRawLocation().append((IPath)new Path(jsfConfigPath));
    }

    private void createConfigFile(final IProject project, final IProjectFacetVersion fv, IDataModel config, IProgressMonitor monitor) {
        final IPath configPath = this.resolveConfigPath(project, config.getStringProperty("IJSFFacetInstallDataModelProperties.CONFIG_PATH"));
        try {
            if (!configPath.toFile().exists()) {
                IWorkspaceRunnable op = new IWorkspaceRunnable(){

                    public void run(IProgressMonitor monitor_inner) throws CoreException {
                        if (this.shouldUseJ2EEConfig(fv)) {
                            JSFUtils11.createConfigFile(fv.getVersionString(), configPath);
                        } else {
                            JSFUtils12.createConfigFile(fv.getVersionString(), configPath);
                        }
                        project.refreshLocal(2, monitor_inner);
                    }

                    private boolean shouldUseJ2EEConfig(IProjectFacetVersion facetVersion) {
                        return "1.1".equals(facetVersion.getVersionString());
                    }
                };
                op.run(monitor);
            }
        }
        catch (CoreException e) {
            JSFCorePlugin.log((Exception)((Object)e), "Exception occured while creating faces-config.xml");
        }
    }

    private void createServletAndModifyWebXML(IProject project, IDataModel config, IProgressMonitor monitor) {
        IModelProvider provider = ModelProviderManager.getModelProvider((IProject)project);
        Object webAppObj = provider.getModelObject();
        if (webAppObj == null) {
            JSFCorePlugin.log(4, String.valueOf(project.getName()) + ": unable to configure web module for JavaServer Faces");
            return;
        }
        IPath webXMLPath = new Path("WEB-INF").append("web.xml");
        if (JSFUtils12.isWebApp25(webAppObj)) {
            WebApp webApp = (WebApp)webAppObj;
            provider.modify((Runnable)new UpdateWebXMLForJavaEE(webApp, config), webXMLPath);
        } else {
            org.eclipse.jst.j2ee.webapplication.WebApp webApp = (org.eclipse.jst.j2ee.webapplication.WebApp)webAppObj;
            provider.modify((Runnable)new UpdateWebXMLForJ2EE(webApp, config), webXMLPath);
        }
    }

    private class UpdateWebXMLForJ2EE
    implements Runnable {
        private org.eclipse.jst.j2ee.webapplication.WebApp webApp;
        private IDataModel config;

        UpdateWebXMLForJ2EE(org.eclipse.jst.j2ee.webapplication.WebApp webApp, IDataModel config) {
            this.webApp = webApp;
            this.config = config;
        }

        public void run() {
            Servlet servlet = JSFUtils11.findJSFServlet(this.webApp);
            servlet = JSFUtils11.createOrUpdateServletRef(this.webApp, this.config, servlet);
            List listOfMappings = JSFFacetInstallDelegate.this.getServletMappings(this.config);
            JSFUtils11.setUpURLMappings(this.webApp, listOfMappings, servlet);
            this.setupContextParams(this.webApp, this.config);
        }

        private void setupContextParams(org.eclipse.jst.j2ee.webapplication.WebApp webApp, IDataModel config) {
            if (webApp.getVersionID() == 23) {
                JSFUtils11.setupConfigFileContextParamForV2_3(webApp, config);
            } else {
                JSFUtils11.setupConfigFileContextParamForV2_4(webApp, config);
            }
        }
    }

    private class UpdateWebXMLForJavaEE
    implements Runnable {
        private WebApp webApp;
        private IDataModel config;

        UpdateWebXMLForJavaEE(WebApp webApp, IDataModel config) {
            this.webApp = webApp;
            this.config = config;
        }

        public void run() {
            org.eclipse.jst.javaee.web.Servlet servlet = JSFUtils12.findJSFServlet(this.webApp);
            servlet = JSFUtils12.createOrUpdateServletRef(this.webApp, this.config, servlet);
            List listOfMappings = JSFFacetInstallDelegate.this.getServletMappings(this.config);
            JSFUtils12.setUpURLMappings(this.webApp, listOfMappings, servlet);
            JSFUtils12.setupConfigFileContextParamForV2_5(this.webApp, this.config);
        }
    }
}

