/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.internal.project.facet;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.javaee.core.JavaeeFactory;
import org.eclipse.jst.javaee.core.ParamValue;
import org.eclipse.jst.javaee.core.UrlPatternType;
import org.eclipse.jst.javaee.web.Servlet;
import org.eclipse.jst.javaee.web.ServletMapping;
import org.eclipse.jst.javaee.web.WebApp;
import org.eclipse.jst.javaee.web.WebAppVersionType;
import org.eclipse.jst.javaee.web.WebFactory;
import org.eclipse.jst.jsf.core.internal.JSFCorePlugin;
import org.eclipse.jst.jsf.core.internal.Messages;
import org.eclipse.jst.jsf.core.internal.project.facet.JSFUtils;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class JSFUtils12
extends JSFUtils {
    public static Servlet findJSFServlet(WebApp webApp) {
        for (Servlet servlet : webApp.getServlets()) {
            if (servlet.getServletClass() == null || !servlet.getServletClass().equals("javax.faces.webapp.FacesServlet")) continue;
            return servlet;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void createConfigFile(String jsfVersion, IPath configPath) {
        FileOutputStream os = null;
        PrintWriter pw = null;
        String QUOTE = new String(new char[]{'\"'});
        try {
            try {
                IPath dirPath = configPath.removeLastSegments(1);
                dirPath.toFile().mkdirs();
                File file = configPath.toFile();
                file.createNewFile();
                os = new FileOutputStream(file);
                pw = new PrintWriter(os);
                pw.write("<?xml version=" + QUOTE + "1.0" + QUOTE + " encoding=" + QUOTE + "UTF-8" + QUOTE + "?>\n\n");
                if (jsfVersion.equals("1.2")) {
                    pw.write("<faces-config\n");
                    pw.write("    xmlns=" + QUOTE + "http://java.sun.com/xml/ns/javaee" + QUOTE + "\n");
                    pw.write("    xmlns:xsi=" + QUOTE + "http://www.w3.org/2001/XMLSchema-instance" + QUOTE + "\n");
                    pw.write("    xsi:schemaLocation=" + QUOTE + "http://java.sun.com/xml/ns/javaee http://java.sun.com/xml/ns/javaee/web-facesconfig_1_2.xsd" + QUOTE + "\n");
                    pw.write("    version=" + QUOTE + "1.2" + QUOTE + ">\n\n");
                    pw.write("</faces-config>\n");
                }
                pw.close();
                pw = null;
                return;
            }
            catch (FileNotFoundException e) {
                JSFCorePlugin.log(4, Messages.JSFUtils_ErrorCreatingConfigFile, e);
                if (pw != null) {
                    pw.close();
                }
                if (os == null) return;
                try {
                    os.close();
                    return;
                }
                catch (IOException e2) {
                    JSFCorePlugin.log(4, Messages.JSFUtils_ErrorClosingConfigFile, e2);
                }
                return;
            }
            catch (IOException e) {
                JSFCorePlugin.log(4, Messages.JSFUtils_ErrorCreatingConfigFile, e);
                if (pw != null) {
                    pw.close();
                }
                if (os == null) return;
                try {
                    os.close();
                    return;
                }
                catch (IOException e3) {
                    JSFCorePlugin.log(4, Messages.JSFUtils_ErrorClosingConfigFile, e3);
                }
                return;
            }
        }
        finally {
            if (pw != null) {
                pw.close();
            }
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e) {
                    JSFCorePlugin.log(4, Messages.JSFUtils_ErrorClosingConfigFile, e);
                }
            }
        }
    }

    public static Servlet createOrUpdateServletRef(WebApp webApp, IDataModel config, Servlet servlet) {
        String displayName = JSFUtils12.getDisplayName(config);
        String className = JSFUtils12.getServletClassname(config);
        if (servlet == null) {
            servlet = WebFactory.eINSTANCE.createServlet();
            servlet.setServletName(displayName);
            servlet.setServletClass(className);
            servlet.setLoadOnStartup((Object)1);
            webApp.getServlets().add(servlet);
        } else {
            servlet.setServletName(displayName);
            servlet.setLoadOnStartup((Object)1);
        }
        return servlet;
    }

    public static boolean isWebApp25(Object webAppObj) {
        return webAppObj instanceof WebApp && ((WebApp)webAppObj).getVersion() == WebAppVersionType._25_LITERAL;
    }

    public static void setUpURLMappings(WebApp webApp, List urlMappingList, Servlet servlet) {
        if (urlMappingList.size() > 0) {
            ServletMapping mapping = JSFUtils12.findServletMapping(webApp, servlet);
            if (mapping == null) {
                mapping = WebFactory.eINSTANCE.createServletMapping();
                mapping.setServletName(servlet.getServletName());
                webApp.getServletMappings().add(mapping);
            }
            for (String pattern : urlMappingList) {
                if (JSFUtils12.doesServletMappingPatternExist(webApp, mapping, pattern)) continue;
                UrlPatternType urlPattern = JavaeeFactory.eINSTANCE.createUrlPatternType();
                urlPattern.setValue(pattern);
                mapping.getUrlPatterns().add(urlPattern);
            }
        }
    }

    private static ServletMapping findServletMapping(WebApp webApp, Servlet servlet) {
        for (ServletMapping mapping : webApp.getServletMappings()) {
            if (!mapping.getServletName().equals(servlet.getServletName())) continue;
            return mapping;
        }
        return null;
    }

    private static boolean doesServletMappingPatternExist(WebApp webApp, ServletMapping mapping, String pattern) {
        Iterator it = mapping.getUrlPatterns().iterator();
        while (it.hasNext()) {
            if (!pattern.equals(((UrlPatternType)it.next()).getValue())) continue;
            return true;
        }
        return false;
    }

    public static void removeURLMappings(WebApp webApp, Servlet servlet) {
        List mappings = webApp.getServletMappings();
        String servletName = servlet.getServletName();
        if (servletName != null) {
            int i = mappings.size() - 1;
            while (i >= 0) {
                ServletMapping mapping = (ServletMapping)mappings.get(i);
                if (mapping != null && mapping.getServletName() != null && mapping.getServletName().equals(servletName)) {
                    mappings.remove(mapping);
                }
                --i;
            }
        }
    }

    public static void setupConfigFileContextParamForV2_5(WebApp webApp, IDataModel config) {
        ParamValue foundCP = null;
        ParamValue cp2 = null;
        boolean found = false;
        if (!config.getStringProperty("IJSFFacetInstallDataModelProperties.CONFIG_PATH").equals("/WEB-INF/faces-config.xml")) {
            for (ParamValue cp2 : webApp.getContextParams()) {
                if (cp2 == null || cp2.getParamName() == null || !cp2.getParamName().equals("javax.faces.CONFIG_FILES")) continue;
                foundCP = cp2;
                found = true;
            }
            if (!found) {
                ParamValue pv = JavaeeFactory.eINSTANCE.createParamValue();
                pv.setParamName("javax.faces.CONFIG_FILES");
                pv.setParamValue(config.getStringProperty("IJSFFacetInstallDataModelProperties.CONFIG_PATH"));
                webApp.getContextParams().add(pv);
            } else {
                cp2 = foundCP;
                if (cp2.getParamValue().indexOf(config.getStringProperty("IJSFFacetInstallDataModelProperties.CONFIG_PATH")) < 0) {
                    String curVal = cp2.getParamValue();
                    String val = config.getStringProperty("IJSFFacetInstallDataModelProperties.CONFIG_PATH");
                    if (curVal != null && !"".equals(curVal.trim())) {
                        val = String.valueOf(curVal) + ",\n" + val;
                    }
                    cp2.setParamValue(val);
                }
            }
        }
    }

    public static String getDefaultSuffix(WebApp webApp) {
        String defaultSuffix = "jsp";
        for (ParamValue cp : webApp.getContextParams()) {
            if (cp == null || cp.getParamName() == null || !cp.getParamName().equals("javax.faces.DEFAULT_SUFFIX")) continue;
            String defSuffix = cp.getParamValue();
            if (defSuffix.startsWith(".")) {
                defSuffix = defSuffix.substring(1);
            }
            return defSuffix;
        }
        return defaultSuffix;
    }

    public static String getPrefixMapping(ServletMapping map) {
        List urls = map.getUrlPatterns();
        Iterator it = urls.iterator();
        while (it.hasNext()) {
            String ext;
            Path extPath = new Path(((UrlPatternType)it.next()).getValue());
            if (extPath == null || (ext = extPath.getFileExtension()) != null) continue;
            String lastSeg = extPath.lastSegment();
            if (lastSeg.equals("*")) {
                return extPath.removeLastSegments(1).toString();
            }
            return extPath.toString();
        }
        return null;
    }

    public static String getFileExtensionFromMap(ServletMapping map) {
        List urls = map.getUrlPatterns();
        Iterator it = urls.iterator();
        while (it.hasNext()) {
            String ext;
            Path extPath = new Path(((UrlPatternType)it.next()).getValue());
            if (extPath == null || (ext = extPath.getFileExtension()) == null || ext.equals("")) continue;
            return ext;
        }
        return null;
    }
}

