/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.jsfappconfig;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.jst.jsf.core.internal.JSFCorePlugin;
import org.eclipse.jst.jsf.core.jsfappconfig.ContextParamSpecifiedJSFAppConfigLocater;
import org.eclipse.jst.jsf.core.jsfappconfig.DefaultJSFAppConfigLocater;
import org.eclipse.jst.jsf.core.jsfappconfig.IFacesConfigChangeListener;
import org.eclipse.jst.jsf.core.jsfappconfig.IJSFAppConfigLocater;
import org.eclipse.jst.jsf.core.jsfappconfig.IJSFAppConfigProvider;
import org.eclipse.jst.jsf.core.jsfappconfig.IJSFAppConfigProvidersChangeListener;
import org.eclipse.jst.jsf.core.jsfappconfig.ImplicitRuntimeJSFAppConfigLocater;
import org.eclipse.jst.jsf.core.jsfappconfig.JSFAppConfigProvidersChangeEvent;
import org.eclipse.jst.jsf.core.jsfappconfig.JSFAppConfigUtils;
import org.eclipse.jst.jsf.core.jsfappconfig.RuntimeClasspathJSFAppConfigLocater;
import org.eclipse.jst.jsf.facesconfig.emf.ApplicationType;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigType;
import org.eclipse.jst.jsf.facesconfig.emf.FromViewIdType;
import org.eclipse.jst.jsf.facesconfig.emf.NavigationRuleType;

public class JSFAppConfigManager
implements IResourceChangeListener {
    public static final QualifiedName KEY_SESSIONPROPERTY = new QualifiedName("org.eclipse.jst.jsf.core", "JSFAppConfigManager");
    protected IProject project = null;
    protected List configLocaters = null;
    protected List configProvidersChangeListeners = null;
    protected Map facesConfigChangeListeners = null;
    protected FacesConfigChangeAdapter facesConfigChangeAdapter = null;

    public static synchronized JSFAppConfigManager getInstance(IProject project) {
        JSFAppConfigManager manager = null;
        if (JSFAppConfigUtils.isValidJSFProject(project) && (manager = JSFAppConfigManager.getFromSessionProperty(project)) == null) {
            manager = new JSFAppConfigManager(project);
        }
        return manager;
    }

    protected static JSFAppConfigManager getFromSessionProperty(IProject project) {
        JSFAppConfigManager manager = null;
        try {
            Object obj = project.getSessionProperty(KEY_SESSIONPROPERTY);
            if (obj instanceof JSFAppConfigManager) {
                manager = (JSFAppConfigManager)obj;
            }
        }
        catch (CoreException ce) {
            JSFCorePlugin.log(4, ce.getLocalizedMessage(), ce);
        }
        return manager;
    }

    protected void setAsSessionProperty() {
        if (this.project != null && this.project.isAccessible()) {
            try {
                this.project.setSessionProperty(KEY_SESSIONPROPERTY, (Object)this);
            }
            catch (CoreException ce) {
                JSFCorePlugin.log(4, ce.getLocalizedMessage(), ce);
            }
        }
    }

    protected void unsetAsSessionProperty() {
        if (this.project != null && this.project.isAccessible()) {
            try {
                this.project.setSessionProperty(KEY_SESSIONPROPERTY, null);
            }
            catch (CoreException ce) {
                JSFCorePlugin.log(4, ce.getLocalizedMessage(), ce);
            }
        }
    }

    private JSFAppConfigManager(IProject project) {
        this.project = project;
        this.initialize();
    }

    public IProject getProject() {
        return this.project;
    }

    protected void initialize() {
        this.facesConfigChangeListeners = new HashMap();
        this.configProvidersChangeListeners = new ArrayList();
        this.configLocaters = new ArrayList();
        this.populateConfigLocaters();
        this.startConfigLocaters();
        this.setAsSessionProperty();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.addResourceChangeListener((IResourceChangeListener)this, 1);
    }

    protected void populateConfigLocaters() {
        ImplicitRuntimeJSFAppConfigLocater implicitRuntimeConfigLocater = new ImplicitRuntimeJSFAppConfigLocater();
        implicitRuntimeConfigLocater.setJSFAppConfigManager(this);
        this.configLocaters.add(implicitRuntimeConfigLocater);
        DefaultJSFAppConfigLocater defaultConfigLocater = new DefaultJSFAppConfigLocater();
        defaultConfigLocater.setJSFAppConfigManager(this);
        this.configLocaters.add(defaultConfigLocater);
        ContextParamSpecifiedJSFAppConfigLocater contextParamConfigLocater = new ContextParamSpecifiedJSFAppConfigLocater();
        contextParamConfigLocater.setJSFAppConfigManager(this);
        this.configLocaters.add(contextParamConfigLocater);
        RuntimeClasspathJSFAppConfigLocater classpathConfigLocater = new RuntimeClasspathJSFAppConfigLocater();
        classpathConfigLocater.setJSFAppConfigManager(this);
        this.configLocaters.add(classpathConfigLocater);
    }

    protected void startConfigLocaters() {
        for (IJSFAppConfigLocater configLocater : this.configLocaters) {
            configLocater.startLocating();
        }
    }

    protected void stopConfigLocaters() {
        for (IJSFAppConfigLocater configLocater : this.configLocaters) {
            configLocater.stopLocating();
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta addedDelta;
        IResource addedResource;
        IResourceDelta[] addedDeltas;
        IResourceDelta removedDelta;
        IResource removedResource;
        IResourceDelta[] removedDeltas;
        IResourceDelta delta = event.getDelta();
        if (delta.getKind() == 4 && (removedDeltas = delta.getAffectedChildren(2)).length == 1 && (removedResource = (removedDelta = removedDeltas[0]).getResource()) != null && removedResource == this.project && (addedDeltas = delta.getAffectedChildren(1)).length == 1 && (addedResource = (addedDelta = addedDeltas[0]).getResource()) instanceof IProject) {
            this.changeProject((IProject)addedResource);
        }
    }

    protected void changeProject(IProject newProject) {
        this.project = newProject;
        this.stopConfigLocaters();
        this.startConfigLocaters();
    }

    public boolean addJSFAppConfigProvidersChangeListener(IJSFAppConfigProvidersChangeListener listener) {
        return this.configProvidersChangeListeners.add(listener);
    }

    public boolean removeJSFAppConfigProvidersChangeListener(IJSFAppConfigProvidersChangeListener listener) {
        return this.configProvidersChangeListeners.remove(listener);
    }

    public void notifyJSFAppConfigProvidersChangeListeners(IJSFAppConfigProvider configProvider, int eventType) {
        JSFAppConfigProvidersChangeEvent event = new JSFAppConfigProvidersChangeEvent(configProvider, eventType);
        for (IJSFAppConfigProvidersChangeListener listener : this.configProvidersChangeListeners) {
            listener.changedJSFAppConfigProviders(event);
        }
    }

    public Object addFacesConfigChangeListener(Class emfClass, IFacesConfigChangeListener listener) {
        this.getFacesConfigModels();
        return this.facesConfigChangeListeners.put(emfClass, listener);
    }

    public Object removeFacesConfigChangeListener(Class emfClass) {
        return this.facesConfigChangeListeners.remove(emfClass);
    }

    public void notifyFacesConfigChangeListeners(Notification notification) {
        Class emfClass;
        IFacesConfigChangeListener listener;
        Object emfFeature = notification.getFeature();
        if (emfFeature instanceof EStructuralFeature && (listener = (IFacesConfigChangeListener)this.facesConfigChangeListeners.get(emfClass = ((EStructuralFeature)emfFeature).getEType().getInstanceClass())) != null) {
            listener.notifyChanged(notification);
        }
    }

    public Set getJSFAppConfigProviders() {
        LinkedHashSet allConfigProviders = new LinkedHashSet();
        for (IJSFAppConfigLocater configLocater : this.configLocaters) {
            allConfigProviders.addAll(configLocater.getJSFAppConfigProviders());
        }
        return allConfigProviders;
    }

    public List getFacesConfigModels() {
        ArrayList<FacesConfigType> facesConfigModels = new ArrayList<FacesConfigType>();
        for (IJSFAppConfigProvider configProvider : this.getJSFAppConfigProviders()) {
            FacesConfigType facesConfig = configProvider.getFacesConfigModel();
            if (facesConfig == null) continue;
            facesConfigModels.add(facesConfig);
        }
        return facesConfigModels;
    }

    protected void finalize() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.removeResourceChangeListener((IResourceChangeListener)this);
        this.unsetAsSessionProperty();
        this.stopConfigLocaters();
        this.configLocaters.clear();
        this.configProvidersChangeListeners.clear();
        this.facesConfigChangeListeners.clear();
    }

    public List getManagedBeans() {
        ArrayList allManagedBeans = new ArrayList();
        List facesConfigs = this.getFacesConfigModels();
        for (FacesConfigType facesConfig : facesConfigs) {
            EList managedBeans = facesConfig.getManagedBean();
            allManagedBeans.addAll(managedBeans);
        }
        return allManagedBeans;
    }

    public List getValidators() {
        ArrayList allValidators = new ArrayList();
        List facesConfigs = this.getFacesConfigModels();
        for (FacesConfigType facesConfig : facesConfigs) {
            EList validators = facesConfig.getValidator();
            allValidators.addAll(validators);
        }
        return allValidators;
    }

    public List getConverters() {
        ArrayList allConverters = new ArrayList();
        List facesConfigs = this.getFacesConfigModels();
        for (FacesConfigType facesConfig : facesConfigs) {
            EList converters = facesConfig.getConverter();
            allConverters.addAll(converters);
        }
        return allConverters;
    }

    public List getNavigationRules() {
        ArrayList allNavigationRules = new ArrayList();
        List facesConfigs = this.getFacesConfigModels();
        for (FacesConfigType facesConfig : facesConfigs) {
            EList navigationRules = facesConfig.getNavigationRule();
            allNavigationRules.addAll(navigationRules);
        }
        return allNavigationRules;
    }

    public List getNavigationRulesForPage(IFile pageFile) {
        ArrayList<NavigationRuleType> navigationRulesForPage = new ArrayList<NavigationRuleType>();
        IPath pageFilePath = JSFAppConfigUtils.getWebContentFolderRelativePath(pageFile);
        if (pageFilePath != null) {
            String pageFileString = pageFilePath.toString();
            if (!pageFileString.startsWith("/")) {
                pageFileString = "/" + pageFileString;
            }
            List navigationRules = this.getNavigationRules();
            for (NavigationRuleType navigationRule : navigationRules) {
                FromViewIdType fromViewIdType = navigationRule.getFromViewId();
                if (fromViewIdType != null) {
                    String fromViewId = fromViewIdType.getTextContent();
                    if (fromViewId == null || fromViewId.length() <= 0) continue;
                    if (!fromViewId.equals("*")) {
                        String prefixFromViewId;
                        if (fromViewId.equals(pageFileString)) {
                            navigationRulesForPage.add(navigationRule);
                            continue;
                        }
                        if (!fromViewId.endsWith("*") || !pageFileString.startsWith(prefixFromViewId = fromViewId.substring(0, fromViewId.length() - 1))) continue;
                        navigationRulesForPage.add(navigationRule);
                        continue;
                    }
                    navigationRulesForPage.add(navigationRule);
                    continue;
                }
                navigationRulesForPage.add(navigationRule);
            }
        }
        return navigationRulesForPage;
    }

    public List getApplications() {
        ArrayList allApplications = new ArrayList();
        List facesConfigs = this.getFacesConfigModels();
        for (FacesConfigType facesConfig : facesConfigs) {
            EList applications = facesConfig.getApplication();
            allApplications.addAll(applications);
        }
        return allApplications;
    }

    public List getFactories() {
        ArrayList allFactories = new ArrayList();
        List facesConfigs = this.getFacesConfigModels();
        for (FacesConfigType facesConfig : facesConfigs) {
            EList factories = facesConfig.getFactory();
            allFactories.addAll(factories);
        }
        return allFactories;
    }

    public List getComponents() {
        ArrayList allComponents = new ArrayList();
        List facesConfigs = this.getFacesConfigModels();
        for (FacesConfigType facesConfig : facesConfigs) {
            EList components = facesConfig.getComponent();
            allComponents.addAll(components);
        }
        return allComponents;
    }

    public List getReferencedBeans() {
        ArrayList allReferencedBeans = new ArrayList();
        List facesConfigs = this.getFacesConfigModels();
        for (FacesConfigType facesConfig : facesConfigs) {
            EList referencedBeans = facesConfig.getReferencedBean();
            allReferencedBeans.addAll(referencedBeans);
        }
        return allReferencedBeans;
    }

    public List getRenderKits() {
        ArrayList allRenderKits = new ArrayList();
        List facesConfigs = this.getFacesConfigModels();
        for (FacesConfigType facesConfig : facesConfigs) {
            EList renderKits = facesConfig.getRenderKit();
            allRenderKits.addAll(renderKits);
        }
        return allRenderKits;
    }

    public List getLifecycles() {
        ArrayList allLifecycles = new ArrayList();
        List facesConfigs = this.getFacesConfigModels();
        for (FacesConfigType facesConfig : facesConfigs) {
            EList lifecycles = facesConfig.getLifecycle();
            allLifecycles.addAll(lifecycles);
        }
        return allLifecycles;
    }

    public List getResourceBundles() {
        ArrayList allResourceBundles = new ArrayList();
        List facesConfigs = this.getFacesConfigModels();
        for (FacesConfigType facesConfig : facesConfigs) {
            for (ApplicationType appType : facesConfig.getApplication()) {
                allResourceBundles.addAll(appType.getResourceBundle());
            }
        }
        return allResourceBundles;
    }

    public void addFacesConfigChangeAdapter(FacesConfigType facesConfig) {
        if (facesConfig != null) {
            if (this.facesConfigChangeAdapter == null) {
                this.facesConfigChangeAdapter = new FacesConfigChangeAdapter();
            }
            facesConfig.eAdapters().add((Object)this.facesConfigChangeAdapter);
        }
    }

    public void removeFacesConfigChangeAdapter(FacesConfigType facesConfig) {
        if (facesConfig != null && this.facesConfigChangeAdapter != null) {
            facesConfig.eAdapters().remove((Object)this.facesConfigChangeAdapter);
        }
    }

    class FacesConfigChangeAdapter
    extends EContentAdapter {
        FacesConfigChangeAdapter() {
        }

        public void notifyChanged(Notification notification) {
            super.notifyChanged(notification);
            JSFAppConfigManager.this.notifyFacesConfigChangeListeners(notification);
        }
    }
}

