/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.taglibprocessing.attributevalues;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IStructuredDocumentContextResolverFactory;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IWorkspaceContextResolver;
import org.eclipse.jst.jsf.core.jsfappconfig.JSFAppConfigManager;
import org.eclipse.jst.jsf.facesconfig.FacesConfigPlugin;
import org.eclipse.jst.jsf.facesconfig.emf.DisplayNameType;
import org.eclipse.jst.jsf.facesconfig.emf.NavigationCaseType;
import org.eclipse.jst.jsf.facesconfig.emf.NavigationRuleType;
import org.eclipse.jst.jsf.metadataprocessors.features.IPossibleValues;
import org.eclipse.jst.jsf.metadataprocessors.features.PossibleValue;
import org.eclipse.jst.jsf.metadataprocessors.features.ValidationMessage;
import org.eclipse.jst.jsf.taglibprocessing.attributevalues.Messages;
import org.eclipse.jst.jsf.taglibprocessing.attributevalues.MethodBindingType;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;

public class ActionType
extends MethodBindingType
implements IPossibleValues {
    protected static final ImageDescriptor MISSING_IMAGE = ImageDescriptor.getMissingImageDescriptor();
    private static final String IMAGE_NAME = "/icons/full/obj16/NavigationCaseType.gif";
    private ImageDescriptor imageDescriptor;

    public boolean isValidValue(String value) {
        if (value == null || value != null && value.length() == 0) {
            ValidationMessage msg = new ValidationMessage(Messages.ActionType_invalid_empty_value);
            this.getValidationMessages().add(msg);
            return false;
        }
        IWorkspaceContextResolver wr = IStructuredDocumentContextResolverFactory.INSTANCE.getWorkspaceContextResolver(this.getStructuredDocumentContext());
        if (wr == null) {
            return true;
        }
        if (JSFAppConfigManager.getInstance(wr.getProject()) == null) {
            return true;
        }
        IFile jsp = (IFile)wr.getResource();
        List rules = JSFAppConfigManager.getInstance(wr.getProject()).getNavigationRulesForPage(jsp);
        for (NavigationRuleType rule : rules) {
            for (NavigationCaseType navCase : rule.getNavigationCase()) {
                if (!value.equals(navCase.getFromOutcome().getTextContent().trim())) continue;
                return true;
            }
        }
        ValidationMessage msg = new ValidationMessage(Messages.ActionType_invalid_value);
        this.getValidationMessages().add(msg);
        return false;
    }

    public List getPossibleValues() {
        ArrayList ret = new ArrayList();
        if (this.getStructuredDocumentContext() == null) {
            return ret;
        }
        IWorkspaceContextResolver wr = IStructuredDocumentContextResolverFactory.INSTANCE.getWorkspaceContextResolver(this.getStructuredDocumentContext());
        if (wr != null && JSFAppConfigManager.getInstance(wr.getProject()) != null) {
            IFile jsp = (IFile)wr.getResource();
            List rules = JSFAppConfigManager.getInstance(wr.getProject()).getNavigationRulesForPage(jsp);
            for (NavigationRuleType rule : rules) {
                if (rule == null) continue;
                ret.addAll(this.createProposals(rule));
            }
        }
        return ret;
    }

    private List createProposals(NavigationRuleType rule) {
        ArrayList<PossibleValue> ret = new ArrayList<PossibleValue>();
        EList cases = rule.getNavigationCase();
        for (NavigationCaseType navCase : cases) {
            PossibleValue pv = this.createProposal(rule, navCase);
            if (pv == null) continue;
            ret.add(pv);
        }
        return ret;
    }

    private PossibleValue createProposal(NavigationRuleType rule, NavigationCaseType navCase) {
        PossibleValue pv = null;
        String value = null;
        String ruleDisp = null;
        String navDisplay = null;
        String navAction = null;
        String toViewId = null;
        if (navCase.getFromOutcome() != null) {
            value = navCase.getFromOutcome().getTextContent();
        }
        if (navCase.getToViewId() != null) {
            toViewId = navCase.getToViewId().getTextContent();
        }
        if (rule.getFromViewId() != null) {
            ruleDisp = rule.getFromViewId().getTextContent();
        }
        if (navCase.getDisplayName() != null && navCase.getDisplayName().size() > 0) {
            navDisplay = ((DisplayNameType)navCase.getDisplayName().get(0)).getTextContent();
        }
        if (navCase.getFromAction() != null) {
            navAction = navCase.getFromAction().getTextContent();
        }
        if (navDisplay == null || navDisplay.trim().equals("")) {
            navDisplay = NLS.bind((String)Messages.ActionType_navcase_display, (Object[])new String[]{value, toViewId});
        }
        if (value != null) {
            pv = new PossibleValue(value, navDisplay);
            pv.setIcon(this.getNavCaseImageDescriptor());
            pv.setAdditionalInformation("from-outcome: " + value + "<br>to-view-id: " + toViewId + "<br>from-view-id: " + ruleDisp + "<br>from-action: " + (navAction == null ? "null" : navAction));
        }
        return pv;
    }

    private ImageDescriptor getNavCaseImageDescriptor() {
        ImageDescriptor ret = super.getImage();
        if (ret != null && ret != MISSING_IMAGE) {
            return ret;
        }
        if (this.imageDescriptor == null) {
            this.imageDescriptor = this.getImageDesc(IMAGE_NAME);
        }
        return this.imageDescriptor;
    }

    private ImageDescriptor getImageDesc(String img) {
        Bundle bundle = FacesConfigPlugin.getPlugin().getBundle();
        URL url = FileLocator.find((Bundle)bundle, (IPath)new Path(img), null);
        ImageDescriptor desc = ImageDescriptor.createFromURL((URL)url);
        if (desc == MISSING_IMAGE) {
            return null;
        }
        return desc;
    }
}

