/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.web.core.internal.java;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.web.core.internal.java.JsTranslation;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;

public class JsTranslationAdapter
implements INodeAdapter,
IResourceChangeListener {
    private static final boolean DEBUG = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.wst.jsdt.web.core/debug/jsptranslation"));
    private IStructuredDocument fHtmlDocument = null;
    private JsTranslation fJSPTranslation = null;
    private NullProgressMonitor fTranslationMonitor = null;
    private String baseLocation;
    private boolean listenForChanges = false;
    static /* synthetic */ Class class$0;

    public JsTranslationAdapter(IDOMModel xmlModel) {
        this.fHtmlDocument = xmlModel.getStructuredDocument();
        this.baseLocation = xmlModel.getBaseLocation();
        this.initializeJavaPlugins();
    }

    public void shouldListenForChanges(boolean listenForProjectChanges) {
        if (listenForProjectChanges) {
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
        }
    }

    public IJavaProject getJavaProject() {
        IJavaProject javaProject = null;
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        Path filePath = new Path(this.baseLocation);
        IProject project = null;
        if (filePath.segmentCount() > 0) {
            project = root.getProject(filePath.segment(0));
        }
        if (project != null) {
            javaProject = JavaCore.create(project);
        }
        return javaProject;
    }

    public JsTranslation getJSPTranslation(boolean listenForChanges) {
        if (this.fJSPTranslation == null || !this.listenForChanges && listenForChanges) {
            if (this.fJSPTranslation != null) {
                this.fJSPTranslation.release();
            }
            this.fJSPTranslation = new JsTranslation(this.fHtmlDocument, this.getJavaProject(), listenForChanges);
            this.listenForChanges = listenForChanges;
        }
        this.shouldListenForChanges(listenForChanges);
        return this.fJSPTranslation;
    }

    private void initializeJavaPlugins() {
        JavaCore.getPlugin();
    }

    public boolean isAdapterForType(Object type) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.web.core.internal.java.IJsTranslation");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return type.equals(clazz);
    }

    public void notifyChanged(INodeNotifier notifier, int eventType, Object changedFeature, Object oldValue, Object newValue, int pos) {
    }

    public void release() {
        if (this.fTranslationMonitor != null) {
            this.fTranslationMonitor.setCanceled(true);
        }
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        if (this.fJSPTranslation != null) {
            if (DEBUG) {
                System.out.println("JSPTranslationAdapter releasing:" + this.fJSPTranslation);
            }
            this.fJSPTranslation.release();
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IProject changedProject;
        IProject iProject = changedProject = event == null || event.getResource() == null ? null : event.getResource().getProject();
        if (changedProject != null && this.getJavaProject().getProject().equals((Object)changedProject) && this.fJSPTranslation != null) {
            this.fJSPTranslation.classpathChange();
        }
    }
}

