/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.web.core.internal.java.search;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.runtime.IPath;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.search.IJavaSearchScope;

public class JsSearchScope
implements IJavaSearchScope {
    private boolean fEnclosesAll = false;
    private List fJavaElements = null;
    private List fResourcePaths = null;

    public JsSearchScope() {
        this.fEnclosesAll = true;
        this.init();
    }

    public JsSearchScope(IJavaElement[] javaElement) {
        this.init();
        this.fJavaElements.addAll(Arrays.asList(javaElement));
    }

    public JsSearchScope(String[] resourceStringPath) {
        this.init();
        this.fResourcePaths.addAll(Arrays.asList(resourceStringPath));
    }

    public void addElement(IJavaElement element) {
        this.fJavaElements.add(element);
    }

    public void addPath(String path) {
        this.fResourcePaths.add(path);
    }

    public boolean encloses(IJavaElement element) {
        if (this.fEnclosesAll) {
            return true;
        }
        return true;
    }

    public boolean encloses(IResourceProxy element) {
        if (this.fEnclosesAll) {
            return true;
        }
        if (this.enclosesPath(element.requestFullPath().toOSString())) {
            return true;
        }
        return true;
    }

    public boolean encloses(String resourcePathString) {
        if (this.fEnclosesAll) {
            return true;
        }
        return this.enclosesPath(resourcePathString);
    }

    private boolean enclosesPath(String possible) {
        String[] paths = this.fResourcePaths.toArray(new String[this.fResourcePaths.size()]);
        int i = 0;
        while (i < paths.length) {
            if (possible.equals(paths[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public IPath[] enclosingProjectsAndJars() {
        return null;
    }

    public String getDescription() {
        return "JSPSearchScope";
    }

    public boolean includesBinaries() {
        return false;
    }

    public boolean includesClasspaths() {
        return false;
    }

    private void init() {
        this.fResourcePaths = new ArrayList();
        this.fJavaElements = new ArrayList();
    }

    public void setIncludesBinaries(boolean includesBinaries) {
    }

    public void setIncludesClasspaths(boolean includesClasspaths) {
    }

    public boolean shouldExclude(String container, String resourceName) {
        System.out.println("Unimplemented method:JsSearchScope.shouldExclude");
        return false;
    }
}

