/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.web.core.internal.java.search;

import java.io.File;
import java.util.zip.CRC32;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.search.IJavaSearchConstants;
import org.eclipse.wst.jsdt.core.search.IJavaSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchDocument;
import org.eclipse.wst.jsdt.core.search.SearchRequestor;
import org.eclipse.wst.jsdt.internal.core.JavaModelManager;
import org.eclipse.wst.jsdt.web.core.internal.JsCoreMessages;
import org.eclipse.wst.jsdt.web.core.internal.java.JsNameManglerUtil;
import org.eclipse.wst.jsdt.web.core.internal.java.search.JSDTSearchDocumentDelegate;
import org.eclipse.wst.jsdt.web.core.internal.java.search.JsIndexManager;
import org.eclipse.wst.jsdt.web.core.internal.java.search.JsSearchDocument;
import org.eclipse.wst.jsdt.web.core.internal.java.search.JsSearchParticipant;
import org.eclipse.wst.jsdt.web.core.internal.validation.Util;

public class JsSearchSupport {
    static final boolean DEBUG;
    private static JsSearchSupport singleton;
    private final CRC32 fChecksumCalculator = new CRC32();
    private final IProgressMonitor fMonitor = new NullProgressMonitor();
    private JsSearchParticipant fParticipant = null;

    static {
        singleton = null;
        String value = Platform.getDebugOption((String)"org.eclipse.wst.jsdt.web.core/debug/jspsearch");
        DEBUG = value != null && value.equalsIgnoreCase("true");
    }

    public static synchronized JsSearchSupport getInstance() {
        if (singleton == null) {
            singleton = new JsSearchSupport();
        }
        return singleton;
    }

    public static boolean isJsp(IFile file) {
        if (file != null && file.exists()) {
            return Util.isJsType(file.getName());
        }
        return false;
    }

    private JsSearchSupport() {
    }

    public SearchDocument addJspFile(IFile file) {
        SearchDocument delegate;
        block6: {
            if (JsSearchSupport.getInstance().isCanceled() || !file.isAccessible()) {
                return null;
            }
            if (DEBUG) {
                System.out.println("adding JSP file:" + file.getFullPath());
            }
            if ((delegate = this.createSearchDocument(file)) != null) {
                try {
                    this.getSearchParticipant().scheduleDocumentIndexing(delegate, this.computeIndexLocation(file.getParent().getFullPath()));
                }
                catch (Exception e) {
                    if (!DEBUG) break block6;
                    e.printStackTrace();
                }
            }
        }
        if (DEBUG) {
            System.out.println("scheduled" + delegate + "for indexing");
        }
        return delegate;
    }

    public final IPath computeContainerLocation(IPath indexLocation) {
        return null;
    }

    public final IPath computeIndexLocation(IPath containerPath) {
        String indexLocation = null;
        String pathString = containerPath.toOSString();
        this.fChecksumCalculator.reset();
        this.fChecksumCalculator.update(pathString.getBytes());
        String fileName = String.valueOf(Long.toString(this.fChecksumCalculator.getValue())) + ".index";
        indexLocation = this.getModelJspPluginWorkingLocation(this.getProject(containerPath)).append(fileName).toOSString();
        JavaModelManager.getJavaModelManager().getIndexManager().indexLocations.put((Object)containerPath, (Object)new Path(indexLocation));
        return new Path(indexLocation);
    }

    private SearchDocument createSearchDocument(IFile jspFile) {
        JSDTSearchDocumentDelegate delegate = null;
        if (jspFile != null && jspFile.exists() && JsSearchSupport.isJsp(jspFile)) {
            delegate = new JSDTSearchDocumentDelegate(new JsSearchDocument(jspFile.getFullPath().toString(), this.getSearchParticipant()));
        }
        return delegate;
    }

    private IFile fileForCUPath(String searchDocPath) {
        Path path;
        String[] split = searchDocPath.split("/");
        String classname = split[split.length - 1];
        if (!searchDocPath.endsWith(".js")) {
            return null;
        }
        String filePath = JsNameManglerUtil.unmangle(classname);
        IFile f = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(filePath));
        if (f == null && (path = new Path(filePath)).segmentCount() >= 2) {
            f = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
        }
        return f;
    }

    public IPath getModelJspPluginWorkingLocation(IProject project) {
        IPath workingLocationFile;
        File folder;
        if (project == null) {
            System.out.println("Null project");
        }
        if (!(folder = new File((workingLocationFile = project.getWorkingLocation("org.eclipse.wst.jsdt.web.core").append("jspsearch")).toOSString())).isDirectory()) {
            try {
                folder.mkdir();
            }
            catch (SecurityException securityException) {}
        }
        return workingLocationFile;
    }

    public final IProgressMonitor getProgressMonitor() {
        return this.fMonitor;
    }

    private IProject getProject(IPath path) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IResource resource = workspace.getRoot().findMember(path.toString());
        if (resource == null) {
            return null;
        }
        IProject project = resource.getProject();
        return project;
    }

    public SearchDocument getSearchDocument(String searchDocPath) {
        SearchDocument delegate = null;
        IFile f = this.fileForCUPath(searchDocPath);
        if (f != null) {
            delegate = this.createSearchDocument(f);
        }
        return delegate;
    }

    JsSearchParticipant getSearchParticipant() {
        if (this.fParticipant == null) {
            this.fParticipant = new JsSearchParticipant();
        }
        return this.fParticipant;
    }

    public final synchronized boolean isCanceled() {
        return this.fMonitor.isCanceled();
    }

    public void search(IJavaElement element, IJavaSearchScope scope, SearchRequestor requestor) {
        JsIndexManager.getInstance().rebuildIndexIfNeeded();
        SearchJob job = new SearchJob(element, scope, requestor);
        this.setCanceled(false);
        job.setUser(true);
        job.schedule();
    }

    public void search(String searchText, IJavaSearchScope scope, int searchFor, int limitTo, int matchMode, boolean isCaseSensitive, SearchRequestor requestor) {
        JsIndexManager.getInstance().rebuildIndexIfNeeded();
        SearchJob job = new SearchJob(searchText, scope, searchFor, limitTo, matchMode, isCaseSensitive, requestor);
        this.setCanceled(false);
        job.setUser(true);
        job.schedule();
    }

    public void searchRunnable(IJavaElement element, IJavaSearchScope scope, SearchRequestor requestor) {
        JsIndexManager.getInstance().rebuildIndexIfNeeded();
        SearchRunnable searchRunnable = new SearchRunnable(element, scope, requestor);
        try {
            this.setCanceled(false);
            ResourcesPlugin.getWorkspace().run((IWorkspaceRunnable)searchRunnable, JsSearchSupport.getInstance().getProgressMonitor());
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public final synchronized void setCanceled(boolean cancel) {
        this.fMonitor.setCanceled(cancel);
    }

    private class SearchJob
    extends Job
    implements IJavaSearchConstants {
        IJavaElement fElement = null;
        boolean fIsCaseSensitive = false;
        int fLimitTo = 3;
        int fMatchMode = 2;
        SearchRequestor fRequestor = null;
        IJavaSearchScope fScope = null;
        int fSearchFor = 4;
        String fSearchText = "";

        public SearchJob(IJavaElement element, IJavaSearchScope scope, SearchRequestor requestor) {
            super(String.valueOf(JsCoreMessages.JSP_Search) + element.getElementName());
            this.fElement = element;
            this.fScope = scope;
            this.fRequestor = requestor;
        }

        public SearchJob(String searchText, IJavaSearchScope scope, int searchFor, int limitTo, int matchMode, boolean isCaseSensitive, SearchRequestor requestor) {
            super(String.valueOf(JsCoreMessages.JSP_Search) + searchText);
            this.fSearchText = searchText;
            this.fScope = scope;
            this.fSearchFor = searchFor;
            this.fLimitTo = limitTo;
            this.fMatchMode = matchMode;
            this.fIsCaseSensitive = isCaseSensitive;
            this.fRequestor = requestor;
        }

        /*
         * Exception decompiling
         */
        public IStatus run(IProgressMonitor jobMonitor) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [4 : 188->191)] java.lang.Throwable
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    private class SearchRunnable
    implements IWorkspaceRunnable,
    IJavaSearchConstants {
        IJavaElement fElement = null;
        boolean fIsCaseSensitive = false;
        int fLimitTo = 3;
        int fMatchMode = 2;
        SearchRequestor fRequestor = null;
        IJavaSearchScope fScope = null;
        int fSearchFor = 4;
        String fSearchText = "";

        public SearchRunnable(IJavaElement element, IJavaSearchScope scope, SearchRequestor requestor) {
            this.fElement = element;
            this.fScope = scope;
            this.fRequestor = requestor;
        }

        public SearchRunnable(String searchText, IJavaSearchScope scope, int searchFor, int limitTo, int matchMode, boolean isCaseSensitive, SearchRequestor requestor) {
            this.fSearchText = searchText;
            this.fScope = scope;
            this.fSearchFor = searchFor;
            this.fLimitTo = limitTo;
            this.fMatchMode = matchMode;
            this.fIsCaseSensitive = isCaseSensitive;
            this.fRequestor = requestor;
        }

        /*
         * Exception decompiling
         */
        public void run(IProgressMonitor monitor) throws CoreException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [4 : 170->174)] java.lang.Throwable
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }
}

