/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer;

import java.io.InputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.wst.ws.internal.explorer.JettyRunnable;
import org.eclipse.wst.ws.internal.explorer.LaunchOption;
import org.eclipse.wst.ws.internal.explorer.OpenBrowserRunnable;
import org.eclipse.wst.ws.internal.explorer.plugin.ExplorerPlugin;

public class WSExplorer {
    private static WSExplorer instance;
    private static int launchOptionsKey_;
    private IWebBrowser internalBrowser_ = null;

    static {
        launchOptionsKey_ = 0;
    }

    public static WSExplorer getInstance() {
        if (instance == null) {
            instance = new WSExplorer();
        }
        return instance;
    }

    public String getContextName() {
        return "wsexplorer";
    }

    public String getParentPluginID() {
        return "org.eclipse.wst.ws.explorer";
    }

    public String getWebAppLocation() {
        return "wsexplorer";
    }

    public String getWelcomeURL() {
        return "wsexplorer.jsp";
    }

    public String getLaunchOptionRegistryURL() {
        return "launch_options_registry.jsp";
    }

    public String getBaseURL() {
        StringBuffer sb = new StringBuffer();
        sb.append("http://");
        sb.append(JettyRunnable.getJettyRunnable().getJettyHost());
        sb.append(":");
        sb.append(JettyRunnable.getJettyRunnable().getJettyPort());
        sb.append("/");
        sb.append("wse");
        sb.append("/");
        sb.append(this.getContextName());
        sb.append("/");
        return sb.toString();
    }

    public String getMetadataDirectory() {
        return ExplorerPlugin.getInstance().getPluginStateLocation();
    }

    public IStatus launch(IWorkbench wb, IStructuredSelection sel, LaunchOption[] options, boolean forceLaunchOutsideIDE) {
        int launchOptionKey = WSExplorer.getLaunchOptionsKey();
        StringBuffer sb = new StringBuffer();
        sb.append(this.getBaseURL());
        sb.append(this.getWelcomeURL());
        sb.append("?");
        if (options != null && options.length > 0) {
            String encodedID = null;
            try {
                encodedID = URLEncoder.encode("org.eclipse.wst.ws.explorer", "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                return new Status(4, "org.eclipse.wst.ws.explorer", 0, ExplorerPlugin.getMessage("%MSG_BROKEN_VM_DOES_NOT_SUPPORT_UTF-8"), (Throwable)e);
            }
            sb.append(encodedID);
            sb.append("=");
            sb.append(launchOptionKey);
        }
        try {
            IWorkbenchBrowserSupport browserSupport = ExplorerPlugin.getInstance().getWorkbench().getBrowserSupport();
            IWebBrowser browser = null;
            if (forceLaunchOutsideIDE) {
                if (Display.getCurrent() == null) {
                    OpenBrowserRunnable runnable = new OpenBrowserRunnable(browserSupport, new URL(sb.toString()));
                    Display.getDefault().syncExec((Runnable)runnable);
                    if (runnable.getException() != null) {
                        throw runnable.getException();
                    }
                } else {
                    browser = browserSupport.getExternalBrowser();
                    browser.openURL(new URL(sb.toString()));
                }
            } else {
                StringBuffer browserId = new StringBuffer();
                browserId.append("org.eclipse.wst.ws.explorer");
                browserId.append(this.getContextName());
                if (this.internalBrowser_ == null) {
                    this.internalBrowser_ = browserSupport.createBrowser(browserId.toString());
                }
                browser = this.internalBrowser_;
                browser.openURL(new URL(sb.toString()));
            }
        }
        catch (Exception e) {
            return new Status(4, "org.eclipse.wst.ws.explorer", 0, ExplorerPlugin.getMessage("%MSG_ERROR_LAUNCH_WSEXPLORER"), (Throwable)e);
        }
        if (options != null && options.length > 0) {
            try {
                StringBuffer launchOptionsRegURL = new StringBuffer();
                launchOptionsRegURL.append(this.getBaseURL());
                launchOptionsRegURL.append(this.getLaunchOptionRegistryURL());
                URL url = new URL(launchOptionsRegURL.toString());
                URLConnection connection = url.openConnection();
                connection.setDoOutput(true);
                PrintWriter out = new PrintWriter(connection.getOutputStream());
                StringBuffer params = new StringBuffer();
                String encodedID = null;
                try {
                    encodedID = URLEncoder.encode("org.eclipse.wst.ws.explorer", "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    return new Status(4, "org.eclipse.wst.ws.explorer", 0, ExplorerPlugin.getMessage("%MSG_BROKEN_VM_DOES_NOT_SUPPORT_UTF-8"), (Throwable)e);
                }
                params.append(encodedID);
                params.append("=");
                params.append(launchOptionKey);
                params.append("&");
                int i = 0;
                while (i < options.length) {
                    if (options[i] != null) {
                        params.append(options[i].getKey());
                        params.append("=");
                        String option = null;
                        try {
                            option = URLEncoder.encode(options[i].getOption(), "UTF-8");
                        }
                        catch (UnsupportedEncodingException e) {
                            return new Status(4, "org.eclipse.wst.ws.explorer", 0, ExplorerPlugin.getMessage("%MSG_BROKEN_VM_DOES_NOT_SUPPORT_UTF-8"), (Throwable)e);
                        }
                        params.append(option);
                        params.append("&");
                    }
                    ++i;
                }
                out.print(params.toString());
                out.close();
                out = null;
                InputStream is = connection.getInputStream();
                is.close();
                is = null;
            }
            catch (Exception e) {
                return new Status(2, "org.eclipse.wst.ws.explorer", 0, ExplorerPlugin.getMessage("%MSG_ERROR_LOAD_LAUNCH_OPTIONS"), (Throwable)e);
            }
        }
        return new Status(0, "org.eclipse.wst.ws.explorer", 0, "", null);
    }

    private static int getLaunchOptionsKey() {
        return launchOptionsKey_++;
    }

    public IStatus launch(IWorkbench wb, IStructuredSelection sel, String[] inquiryURL, String[] publishURL, boolean forceLaunchOutsideIDE) {
        int i;
        int inquiryURLOptionLength = inquiryURL != null ? inquiryURL.length : 0;
        int publishURLOptionLength = publishURL != null ? publishURL.length : 0;
        LaunchOption[] options = new LaunchOption[inquiryURLOptionLength + publishURLOptionLength];
        int index = 0;
        if (inquiryURL != null) {
            i = 0;
            while (i < inquiryURL.length) {
                options[index] = new LaunchOption("inquiry", inquiryURL[i]);
                ++index;
                ++i;
            }
        }
        if (publishURL != null) {
            i = 0;
            while (i < publishURL.length) {
                options[index] = new LaunchOption("publish", publishURL[i]);
                ++index;
                ++i;
            }
        }
        return this.launch(wb, sel, options, forceLaunchOutsideIDE);
    }
}

