/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.favorites.datamodel;

import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.wsil.Service;
import org.eclipse.wst.ws.internal.datamodel.Element;
import org.eclipse.wst.ws.internal.datamodel.Model;
import org.eclipse.wst.ws.internal.explorer.platform.datamodel.TreeElement;
import org.eclipse.wst.ws.internal.explorer.platform.favorites.datamodel.FavoritesFolderElement;
import org.eclipse.wst.ws.internal.explorer.platform.favorites.datamodel.FavoritesMainElement;
import org.eclipse.wst.ws.internal.explorer.platform.favorites.datamodel.FavoritesUDDIServiceElement;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Node;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.NodeManager;

public class FavoritesUDDIServiceFolderElement
extends FavoritesFolderElement {
    public FavoritesUDDIServiceFolderElement(String name, Model model, NodeManager nodeManager) {
        super(name, model, nodeManager);
    }

    public void init(FavoritesMainElement favMainElement) {
        Service[] services = favMainElement.loadUDDIServices();
        int i = 0;
        while (i < services.length) {
            Service service = services[i];
            FavoritesUDDIServiceElement favUDDIServiceElement = new FavoritesUDDIServiceElement(service.getServiceNames()[0].getText(), this.getModel(), service);
            this.connect((Element)favUDDIServiceElement, "relUDDIServiceNode", "owner");
            ++i;
        }
    }

    public boolean addFavorite(Hashtable table) {
        String serviceName = (String)table.get("UDDIServiceName");
        String inquiryAPI = (String)table.get("UDDIServiceInquiryAPI");
        String serviceKey = (String)table.get("UDDIServiceKey");
        if (serviceName == null || inquiryAPI == null || serviceKey == null) {
            return false;
        }
        FavoritesUDDIServiceElement e = this.getFavorite(inquiryAPI, serviceKey);
        if (e != null) {
            this.removeFavorite(e);
        }
        FavoritesMainElement favMainElement = this.getFavoritesMainElement();
        Service service = favMainElement.addUDDIService(serviceName, inquiryAPI, serviceKey);
        boolean saved = favMainElement.saveFavorites();
        if (saved) {
            FavoritesUDDIServiceElement favUDDIServiceElement = new FavoritesUDDIServiceElement(serviceName, this.getModel(), service);
            this.connect((Element)favUDDIServiceElement, "relUDDIServiceNode", "owner");
        }
        return saved;
    }

    public boolean favoriteExists(Hashtable table) {
        String inquiryAPI = (String)table.get("UDDIServiceInquiryAPI");
        String serviceKey = (String)table.get("UDDIServiceKey");
        if (inquiryAPI == null || serviceKey == null) {
            return false;
        }
        return this.getFavorite(inquiryAPI, serviceKey) != null;
    }

    public boolean removeFavoriteByNodeID(int nodeID, String pluginMetadataDirectory) {
        Node selectedNode = this.nodeManager_.getNode(nodeID);
        TreeElement selectedElement = selectedNode.getTreeElement();
        FavoritesMainElement favMainElement = this.getFavoritesMainElement();
        if (selectedElement instanceof FavoritesUDDIServiceElement) {
            return this.removeFavorite((FavoritesUDDIServiceElement)selectedElement) && favMainElement.saveFavorites();
        }
        return false;
    }

    private boolean removeFavorite(FavoritesUDDIServiceElement element) {
        Service service = element.getService();
        FavoritesMainElement favMainElement = this.getFavoritesMainElement();
        if (favMainElement.removeService(service)) {
            element.disconnectAll();
            return true;
        }
        return false;
    }

    public boolean removeAllFavorites(String pluginMetadataDirectory) {
        FavoritesMainElement favMainElement = this.getFavoritesMainElement();
        Enumeration e = this.getAllFavorites();
        while (e.hasMoreElements()) {
            FavoritesUDDIServiceElement favUDDIServiceElement = (FavoritesUDDIServiceElement)((Object)e.nextElement());
            Service service = favUDDIServiceElement.getService();
            favMainElement.removeService(service);
        }
        this.disconnectRel("relUDDIServiceNode");
        return favMainElement.saveFavorites();
    }

    public Enumeration getAllFavorites() {
        return this.getElements("relUDDIServiceNode");
    }

    private FavoritesUDDIServiceElement getFavorite(String inquiryAPI, String serviceKey) {
        Enumeration e = this.getAllFavorites();
        while (e.hasMoreElements()) {
            FavoritesUDDIServiceElement serElement = (FavoritesUDDIServiceElement)((Object)e.nextElement());
            if (!inquiryAPI.equals(serElement.getInquiryURL()) || !serviceKey.equals(serElement.getServiceKey())) continue;
            return serElement;
        }
        return null;
    }
}

