/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.uddi.actions;

import java.util.Vector;
import org.eclipse.wst.ws.internal.datamodel.Element;
import org.eclipse.wst.ws.internal.explorer.platform.datamodel.ListElement;
import org.eclipse.wst.ws.internal.explorer.platform.datamodel.TreeElement;
import org.eclipse.wst.ws.internal.explorer.platform.engine.transformer.ITransformer;
import org.eclipse.wst.ws.internal.explorer.platform.engine.transformer.MultipartFormDataParserTransformer;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Controller;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.FormTool;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.FormToolPropertiesInterface;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.MessageQueue;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Node;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.NodeManager;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Tool;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.ToolManager;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.actions.UDDIPropertiesFormAction;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.datamodel.BusinessElement;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.datamodel.RegistryElement;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.datamodel.ServiceElement;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.datamodel.ServiceInterfaceElement;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.perspective.PublishedItemsNode;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.perspective.RegistryNode;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.perspective.UDDIPerspective;
import org.eclipse.wst.ws.internal.explorer.platform.util.MultipartFormDataException;
import org.eclipse.wst.ws.internal.explorer.platform.util.MultipartFormDataParser;
import org.eclipse.wst.ws.internal.explorer.platform.util.Validator;
import org.uddi4j.datatype.business.BusinessEntity;
import org.uddi4j.datatype.service.BusinessService;
import org.uddi4j.datatype.tmodel.TModel;

public abstract class UpdateAction
extends UDDIPropertiesFormAction {
    protected RegistryNode regNode_ = this.getRegistryNode();
    private boolean requiresAuthentication_;

    public UpdateAction(Controller controller, boolean requiresAuthentication) {
        super(controller);
        this.requiresAuthentication_ = requiresAuthentication;
    }

    protected abstract boolean processOthers(MultipartFormDataParser var1, FormToolPropertiesInterface var2) throws MultipartFormDataException;

    protected final boolean processParsedResults(MultipartFormDataParser parser) throws MultipartFormDataException {
        FormTool formTool;
        this.propertyTable_.put("multipartFormDataParser", parser);
        UDDIPerspective uddiPerspective = this.controller_.getUDDIPerspective();
        MessageQueue messageQueue = uddiPerspective.getMessageQueue();
        FormTool formToolPI = formTool = this.getSelectedFormTool();
        formToolPI.clearErrors();
        boolean inputsValid = this.processOthers(parser, formToolPI);
        int i = 0;
        while (i < this.removedProperties_.size()) {
            formToolPI.removeProperty(this.removedProperties_.elementAt(i));
            ++i;
        }
        formToolPI.updatePropertyTable(this.propertyTable_);
        String publishURL = parser.getParameter("advancedPublishURL");
        String userId = parser.getParameter("advancedUserId");
        String password = parser.getParameter("advancedPassword");
        RegistryElement regElement = (RegistryElement)this.regNode_.getTreeElement();
        boolean validateAuthentication = !regElement.isLoggedIn() & this.requiresAuthentication_;
        if (publishURL != null) {
            this.propertyTable_.put("advancedPublishURL", publishURL);
            formTool.setProperty("advancedPublishURL", publishURL);
        }
        if (validateAuthentication && !Validator.validateString(publishURL)) {
            inputsValid = false;
            formTool.flagError("advancedPublishURL");
            messageQueue.addMessage(uddiPerspective.getMessage("MSG_ERROR_INVALID_PUBLISH_URL"));
        }
        if (userId != null) {
            this.propertyTable_.put("advancedUserId", userId);
            formTool.setProperty("advancedUserId", userId);
        }
        if (validateAuthentication && !Validator.validateString(userId)) {
            inputsValid = false;
            formTool.flagError("advancedUserId");
            messageQueue.addMessage(uddiPerspective.getMessage("MSG_ERROR_INVALID_USERID"));
        }
        if (password != null) {
            this.propertyTable_.put("advancedPassword", password);
            formTool.setProperty("advancedPassword", password);
        }
        return inputsValid;
    }

    public abstract boolean refreshFromRegistry();

    protected final void refreshNode(BusinessEntity be) {
        Node node = this.getSelectedNavigatorNode();
        Node parentNode = node.getParent();
        TreeElement element = node.getTreeElement();
        element.disconnectAll();
        BusinessElement newBusinessElement = new BusinessElement(be, this.regNode_.getTreeElement().getModel());
        this.connectElements(parentNode, newBusinessElement);
    }

    protected final void refreshNode(BusinessService bs) {
        Node node = this.getSelectedNavigatorNode();
        Node parentNode = node.getParent();
        TreeElement element = node.getTreeElement();
        element.disconnectAll();
        ServiceElement newServiceElement = new ServiceElement(bs, this.regNode_.getTreeElement().getModel());
        this.connectElements(parentNode, newServiceElement);
    }

    protected final void refreshNode(TModel tModel) {
        Node node = this.getSelectedNavigatorNode();
        Node parentNode = node.getParent();
        TreeElement element = node.getTreeElement();
        element.disconnectAll();
        ServiceInterfaceElement newServiceInterfaceElement = new ServiceInterfaceElement(tModel, this.regNode_.getTreeElement().getModel());
        this.connectElements(parentNode, newServiceInterfaceElement);
    }

    private final void connectElements(Node parentNode, TreeElement newElement) {
        TreeElement parentElement = parentNode.getTreeElement();
        String rel = null;
        rel = parentNode instanceof PublishedItemsNode ? "publishedItems" : "queryResults";
        parentElement.connect((Element)newElement, rel, "owner");
        Node newNode = parentNode.getChildNode(newElement);
        int newNodeId = newNode.getNodeId();
        NodeManager nodeManager = parentNode.getNodeManager();
        nodeManager.setSelectedNodeId(newNodeId);
        ToolManager toolManager = newNode.getToolManager();
        Tool selectedTool = toolManager.getSelectedTool();
        this.addToHistory(0, selectedTool.getSelectToolActionHref(true));
    }

    protected final void reindexListElementVector(Vector v) {
        int i = 0;
        while (i < v.size()) {
            ListElement listElement = (ListElement)v.elementAt(i);
            listElement.setViewId(i);
            ++i;
        }
    }

    public ITransformer[] getTransformers() {
        ITransformer[] parentTransformers = super.getTransformers();
        ITransformer[] transformers = new ITransformer[parentTransformers.length + 1];
        System.arraycopy(parentTransformers, 0, transformers, 0, parentTransformers.length);
        transformers[transformers.length - 1] = new MultipartFormDataParserTransformer(this.controller_);
        return transformers;
    }
}

