/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment.impl;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import org.eclipse.wst.ws.internal.explorer.platform.util.MultipartFormDataException;
import org.eclipse.wst.ws.internal.explorer.platform.util.MultipartFormDataParser;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment.IXSDFragment;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment.impl.XSDDelegationFragment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SOAPHeaderWrapperFragment
extends XSDDelegationFragment {
    private static final String MUST_UNDERSTAND = "mustUnderstand";
    private static final String ACTOR = "actor";
    private boolean mustUnderstand = false;
    private String actor = "";
    private boolean validActor = true;

    public SOAPHeaderWrapperFragment(IXSDFragment fragment) {
        super(fragment.genID(), fragment.getName(), null);
        this.setXSDDelegationFragment(fragment);
    }

    private String getFirstElement(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        return stringArray[0];
    }

    private String getFirstElement(Vector vector) {
        if (vector == null || vector.isEmpty()) {
            return null;
        }
        Object obj = vector.firstElement();
        if (!(obj instanceof String)) {
            return null;
        }
        return (String)obj;
    }

    private void setMustUnderstand(String param) {
        this.mustUnderstand = param != null && !param.equals("0");
    }

    private void setActor(String param) {
        if (param == null || param.length() == 0) {
            this.actor = "";
        } else {
            this.actor = param;
            try {
                new URI(this.actor);
            }
            catch (URISyntaxException uRISyntaxException) {
                this.validActor = false;
                return;
            }
        }
        this.validActor = true;
    }

    public boolean processParameterValues(MultipartFormDataParser parser) throws MultipartFormDataException {
        this.setMustUnderstand(parser.getParameter(this.getMustUnderstandID()));
        this.setActor(parser.getParameter(this.getActorID()));
        return super.processParameterValues(parser) && this.validateActor();
    }

    public void setParameterValues(String paramKey, String[] params) {
        if (this.getMustUnderstandID().equals(paramKey)) {
            this.setMustUnderstand(this.getFirstElement(params));
        } else if (this.getActorID().equals(paramKey)) {
            this.setActor(this.getFirstElement(params));
        } else {
            super.setParameterValues(paramKey, params);
        }
    }

    public void setParameterValues(String paramKey, Vector params) {
        if (this.getMustUnderstandID().equals(paramKey)) {
            this.setMustUnderstand(this.getFirstElement(params));
        } else if (this.getActorID().equals(paramKey)) {
            this.setActor(this.getFirstElement(params));
        } else {
            super.setParameterValues(paramKey, params);
        }
    }

    public String[] getParameterValues(String paramKey) {
        if (this.getMustUnderstandID().equals(paramKey)) {
            return new String[]{this.mustUnderstand ? "1" : "0"};
        }
        if (this.getActorID().equals(paramKey)) {
            return new String[]{this.actor};
        }
        return super.getParameterValues(paramKey);
    }

    public String getParameterValue(String paramKey, int paramIndex) {
        return this.getParameterValues(paramKey)[paramIndex];
    }

    public boolean validateAllParameterValues() {
        return super.validateAllParameterValues() && this.validateActor();
    }

    public boolean validateParameterValues(String paramKey) {
        if (this.getMustUnderstandID().equals(paramKey)) {
            return true;
        }
        if (this.getActorID().equals(paramKey)) {
            return this.validateActor();
        }
        return super.validateParameterValues(paramKey);
    }

    public boolean validateParameterValue(String paramKey, int paramIndex) {
        if (this.getMustUnderstandID().equals(paramKey)) {
            return true;
        }
        if (this.getActorID().equals(paramKey)) {
            return this.validateActor();
        }
        return super.validateParameterValue(paramKey, paramIndex);
    }

    public boolean setParameterValuesFromInstanceDocument(Element instanceDocument, Map namespaceTable) {
        boolean valid = this.setParameterValuesFromInstanceDocuments(new Element[]{instanceDocument});
        String prefix = namespaceTable.get("http://schemas.xmlsoap.org/soap/envelope/") + ":";
        String mustUnderstandValue = instanceDocument.getAttribute(String.valueOf(prefix) + MUST_UNDERSTAND);
        if ("".equals(mustUnderstandValue)) {
            this.mustUnderstand = false;
        } else if ("0".equals(mustUnderstandValue) || "1".equals(mustUnderstandValue)) {
            this.setMustUnderstand(mustUnderstandValue);
        } else {
            valid = false;
        }
        this.setActor(instanceDocument.getAttribute(String.valueOf(prefix) + ACTOR));
        return valid && this.validateActor();
    }

    public Element[] genInstanceDocumentsFromParameterValues(boolean genXSIType, Hashtable namespaceTable, Document doc) {
        Element[] elements = super.genInstanceDocumentsFromParameterValues(genXSIType, namespaceTable, doc);
        if (elements.length == 0) {
            return elements;
        }
        String prefix = String.valueOf(this.getPrefixFromNamespaceURI("http://schemas.xmlsoap.org/soap/envelope/", namespaceTable)) + ":";
        int i = 0;
        while (i < elements.length) {
            if (this.mustUnderstand) {
                elements[i].setAttribute(String.valueOf(prefix) + MUST_UNDERSTAND, "1");
            }
            if (this.actor.length() > 0) {
                elements[i].setAttribute(String.valueOf(prefix) + ACTOR, this.actor);
            }
            ++i;
        }
        return elements;
    }

    public boolean isMustUnderstand() {
        return this.mustUnderstand;
    }

    public String getActor() {
        return this.actor;
    }

    public boolean validateActor() {
        return this.validActor;
    }

    public String getMustUnderstandID() {
        return String.valueOf(this.getID()) + "::" + MUST_UNDERSTAND;
    }

    public String getActorID() {
        return String.valueOf(this.getID()) + "::" + ACTOR;
    }

    public String getWriteFragment() {
        return "/wsdl/fragment/SOAPHeaderWrapperWFragmentJSP.jsp";
    }
}

