/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cheatsheets.actions;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.cheatsheets.CheatSheetsPlugin;
import org.eclipse.emf.cheatsheets.actions.NewJavaProjectAction;
import org.eclipse.emf.cheatsheets.actions.NewProjectAction;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.cheatsheets.ICheatSheetAction;
import org.eclipse.ui.cheatsheets.ICheatSheetManager;
import org.osgi.framework.Bundle;

public class CopyFileFromPluginAction
extends Action
implements ICheatSheetAction {
    protected String projectName;
    protected String javaPackageName;
    protected String sourceFile;
    protected IWorkspaceRoot root;

    public void run(String[] params, ICheatSheetManager manager) {
        this.projectName = params[0];
        this.javaPackageName = params[1];
        this.sourceFile = params[2];
        this.root = ResourcesPlugin.getWorkspace().getRoot();
        this.run();
    }

    public void run() {
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                if (!CopyFileFromPluginAction.this.isNullString(CopyFileFromPluginAction.this.projectName)) {
                    IProject project = CopyFileFromPluginAction.this.getProject(CopyFileFromPluginAction.this.projectName, !CopyFileFromPluginAction.this.isNullString(CopyFileFromPluginAction.this.javaPackageName), monitor);
                    CopyFileFromPluginAction.this.copyFileToProject(project, CopyFileFromPluginAction.this.javaPackageName, CopyFileFromPluginAction.this.sourceFile, monitor);
                } else {
                    CopyFileFromPluginAction.this.copyFileToWorkspaceFolder(CopyFileFromPluginAction.this.sourceFile);
                }
            }
        };
        try {
            this.runWithProgress((IRunnableWithProgress)operation);
            return;
        }
        catch (Exception e) {
            CheatSheetsPlugin.INSTANCE.log(e);
            this.notifyResult(false);
            return;
        }
    }

    protected void runWithProgress(IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
        new ProgressMonitorDialog(Display.getCurrent().getActiveShell()).run(false, false, runnable);
    }

    protected IProject getProject(String projectName, boolean isJavaProject, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(CheatSheetsPlugin.INSTANCE.getString("_UI_FindProject_message", new String[]{projectName}), 2);
        IProject project = null;
        if (isJavaProject) {
            NewJavaProjectAction newJavaProjectAction = new NewJavaProjectAction();
            project = newJavaProjectAction.createProject(projectName, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        } else {
            NewProjectAction newProjectAction = new NewProjectAction();
            project = newProjectAction.createProject(projectName, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        monitor.done();
        return project;
    }

    protected IFile copyFileToProject(IProject project, String javaPackageName, String sourceFile, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(CheatSheetsPlugin.INSTANCE.getString("_UI_CopyFileToProject_message", new String[]{this.projectName}), 2);
        String targetFileName = sourceFile.substring(sourceFile.lastIndexOf(47) + 1);
        IPath targetFolderPath = this.getFolderPath(project, javaPackageName, monitor);
        IFile targetFile = project.getFile(targetFolderPath.append(targetFileName));
        if (!targetFile.exists()) {
            String sourcePluginId = sourceFile.substring(0, sourceFile.indexOf(47));
            String sourceFilePath = sourceFile.substring(sourceFile.indexOf(47));
            Bundle bundle = Platform.getBundle((String)sourcePluginId);
            try {
                InputStream in = FileLocator.openStream((Bundle)bundle, (IPath)new Path(sourceFilePath), (boolean)false);
                targetFile.create(in, true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                in.close();
            }
            catch (IOException e) {
                CheatSheetsPlugin.INSTANCE.log(e);
            }
        }
        monitor.done();
        this.notifyResult(targetFile.exists());
        return targetFile;
    }

    protected void copyFileToWorkspaceFolder(String sourceFile) throws CoreException {
        String targetFileName = sourceFile.substring(sourceFile.lastIndexOf(47) + 1);
        String sourcePluginId = sourceFile.substring(0, sourceFile.indexOf(47));
        String sourceFilePath = sourceFile.substring(sourceFile.indexOf(47));
        Bundle bundle = Platform.getBundle((String)sourcePluginId);
        File file = new File(String.valueOf(this.root.getLocation().toPortableString()) + "/" + targetFileName);
        if (!file.exists()) {
            try {
                InputStream in = FileLocator.openStream((Bundle)bundle, (IPath)new Path(sourceFilePath), (boolean)false);
                FileOutputStream out = new FileOutputStream(file);
                int aChar = 0;
                while ((aChar = in.read()) != -1) {
                    out.write(aChar);
                }
                in.close();
                out.close();
            }
            catch (IOException e) {
                CheatSheetsPlugin.INSTANCE.log(e);
            }
        }
        this.notifyResult(file.exists());
    }

    protected IPath getFolderPath(IProject project, String javaPackageName, IProgressMonitor monitor) throws CoreException {
        IPath folderPath = project.getProjectRelativePath();
        if (!this.isNullString(javaPackageName)) {
            folderPath = folderPath.append("src");
            StringTokenizer javaPackageToken = new StringTokenizer(javaPackageName, ".");
            IFolder folder = null;
            while (javaPackageToken.hasMoreElements()) {
                folder = project.getFolder(folderPath = folderPath.append(javaPackageToken.nextToken()));
                if (folder.exists()) continue;
                folder.create(true, true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
        }
        return folderPath;
    }

    protected boolean isNullString(String value) {
        return value == null || value.length() == 0;
    }
}

