/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.core.internal.validate;

import java.util.Iterator;
import org.eclipse.wst.html.core.internal.modelquery.HMQUtil;
import org.eclipse.wst.xml.core.internal.contentmodel.CMAttributeDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMContent;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDataType;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMGroup;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNodeList;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.ModelQuery;
import org.eclipse.wst.xml.core.internal.modelquery.ModelQueryUtil;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

final class CMUtil {
    private CMUtil() {
    }

    public static CMElementDeclaration getDeclaration(Element target) {
        Document doc = target.getOwnerDocument();
        ModelQuery query = ModelQueryUtil.getModelQuery((Document)doc);
        return query.getCMElementDeclaration(target);
    }

    public static boolean isCaseSensitive(CMElementDeclaration decl) {
        if (decl == null || !decl.supports("shouldIgnoreCase")) {
            return false;
        }
        return (Boolean)decl.getProperty("shouldIgnoreCase") == false;
    }

    private static boolean isChild(CMContent content, CMElementDeclaration target) {
        switch (content.getNodeType()) {
            case 5: {
                if (CMUtil.isWholeTagOmissible((CMElementDeclaration)content) && CMUtil.isChild(((CMElementDeclaration)content).getContent(), target)) {
                    return true;
                }
                return CMUtil.isSameDeclaration((CMElementDeclaration)content, target);
            }
            case 7: {
                CMNodeList children = ((CMGroup)content).getChildNodes();
                int i = 0;
                while (i < children.getLength()) {
                    CMNode child = children.item(i);
                    switch (child.getNodeType()) {
                        case 5: {
                            if (CMUtil.isWholeTagOmissible((CMElementDeclaration)child) && CMUtil.isChild(((CMElementDeclaration)child).getContent(), target)) {
                                return true;
                            }
                            if (!CMUtil.isSameDeclaration((CMElementDeclaration)child, target)) break;
                            return true;
                        }
                        case 7: {
                            if (!CMUtil.isChild((CMContent)child, target)) break;
                            return true;
                        }
                    }
                    ++i;
                }
                break;
            }
        }
        return false;
    }

    public static boolean isEndTagOmissible(CMElementDeclaration decl) {
        if (!decl.supports("omitType")) {
            return false;
        }
        String omitType = (String)decl.getProperty("omitType");
        return !omitType.equals("omitNone");
    }

    public static boolean isWholeTagOmissible(CMElementDeclaration decl) {
        if (!decl.supports("omitType")) {
            return false;
        }
        String omitType = (String)decl.getProperty("omitType");
        return omitType.equals("omitBoth");
    }

    public static boolean isJSP(CMElementDeclaration decl) {
        if (!decl.supports("isJSP")) {
            return false;
        }
        return (Boolean)decl.getProperty("isJSP");
    }

    public static boolean isXHTML(CMElementDeclaration decl) {
        if (!decl.supports("isXHTML")) {
            return false;
        }
        return (Boolean)decl.getProperty("isXHTML");
    }

    public static boolean isHTML(CMElementDeclaration decl) {
        return !CMUtil.isJSP(decl) && !CMUtil.isSSI(decl);
    }

    private static boolean isSameDeclaration(CMElementDeclaration aDec, CMElementDeclaration otherDec) {
        return aDec.getElementName() == otherDec.getElementName();
    }

    public static boolean isSSI(CMElementDeclaration edec) {
        if (edec == null) {
            return false;
        }
        if (!edec.supports("isSSI")) {
            return false;
        }
        return (Boolean)edec.getProperty("isSSI");
    }

    public static boolean isValidChild(CMElementDeclaration parent, CMElementDeclaration child) {
        if (parent == null || child == null) {
            return false;
        }
        if (CMUtil.isHTML(parent) && !CMUtil.isHTML(child)) {
            return true;
        }
        CMContent content = parent.getContent();
        if (content == null) {
            return false;
        }
        return CMUtil.isChild(content, child);
    }

    public static boolean isForeign(Element target) {
        if (!(target instanceof IDOMElement)) {
            return true;
        }
        IDOMElement element = (IDOMElement)target;
        return !element.isGlobalTag();
    }

    public static boolean isBooleanAttr(CMAttributeDeclaration adec) {
        CMDataType attrtype = adec.getAttrType();
        if (attrtype == null) {
            return false;
        }
        if (attrtype.getDataTypeName() != "ENUM") {
            return false;
        }
        String[] values = attrtype.getEnumeratedValues();
        if (values.length != 1) {
            return false;
        }
        return values[0].equals(adec.getAttrName());
    }

    public static boolean isValidInclusion(CMElementDeclaration decl, Element parent) {
        Iterator iter = HMQUtil.getInclusions(parent).iterator();
        while (iter.hasNext()) {
            CMElementDeclaration inclusion = (CMElementDeclaration)iter.next();
            if (!CMUtil.isSameDeclaration(decl, inclusion)) continue;
            return true;
        }
        return false;
    }
}

