/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.web.ui;

import java.net.URI;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.wst.jsdt.core.ClasspathContainerInitializer;
import org.eclipse.wst.jsdt.core.IClasspathContainer;
import org.eclipse.wst.jsdt.core.IClasspathEntry;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.compiler.libraries.LibraryLocation;
import org.eclipse.wst.jsdt.internal.ui.IClasspathContainerInitialzerExtension;
import org.eclipse.wst.jsdt.web.core.internal.java.JsNameManglerUtil;
import org.eclipse.wst.jsdt.web.core.internal.java.WebRootFinder;
import org.eclipse.wst.jsdt.web.ui.Messages;

public class WebProjectClassPathContainerInitializer
extends ClasspathContainerInitializer
implements IClasspathContainerInitialzerExtension {
    private static final String CONTAINER_DESCRIPTION = Messages.getString("WebProjectClassPathContainerInitializer.0");
    public static final char[] LIB_NAME = new char[]{'b', 'r', 'o', 'w', 's', 'e', 'r', 'W', 'i', 'n', 'd', 'o', 'w', '.', 'j', 's'};
    private static final String MANGLED_BUTT1 = "htm";
    private static final String MANGLED_BUTT2 = ".js";

    private static String getUnmangedHtmlPath(String containerPathString) {
        if (containerPathString == null) {
            return null;
        }
        if (containerPathString.toLowerCase().indexOf(MANGLED_BUTT1) != -1 && containerPathString.toLowerCase().indexOf(MANGLED_BUTT2) != -1) {
            return JsNameManglerUtil.unmangle((String)containerPathString);
        }
        return null;
    }

    public LibraryLocation getLibraryLocation() {
        return null;
    }

    public boolean canUpdateClasspathContainer(IPath containerPath, IJavaProject project) {
        return false;
    }

    protected IClasspathContainer getContainer(IPath containerPath, IJavaProject project) {
        return this;
    }

    public String getDescription() {
        return CONTAINER_DESCRIPTION;
    }

    public String getDescription(IPath containerPath, IJavaProject javaProject) {
        if (containerPath.equals((Object)new Path("org.eclipse.wst.jsdt.launching.WebProject"))) {
            return CONTAINER_DESCRIPTION;
        }
        String containerPathString = containerPath.toString();
        IPath webContext = WebProjectClassPathContainerInitializer.getWebContextRoot(javaProject);
        String fileExtension = containerPath.getFileExtension();
        if (containerPath.equals((Object)WebProjectClassPathContainerInitializer.getWebContextRoot(javaProject)) || fileExtension != null && fileExtension.equals("js")) {
            return webContext.toString();
        }
        String unmangled = WebProjectClassPathContainerInitializer.getUnmangedHtmlPath(containerPathString);
        if (unmangled != null) {
            IPath projectPath = javaProject.getPath();
            if (unmangled.indexOf(projectPath.toString()) >= 0) {
                unmangled = String.valueOf(javaProject.getDisplayName()) + ":" + unmangled.substring(projectPath.toString().length());
            }
            return unmangled;
        }
        return containerPathString;
    }

    public URI getHostPath(IPath path, IJavaProject project) {
        String htmlPath = WebProjectClassPathContainerInitializer.getUnmangedHtmlPath(path.toString());
        if (htmlPath != null) {
            URI fileUri = new Path(htmlPath).toFile().toURI();
            return fileUri;
        }
        return null;
    }

    public int getKind() {
        return 2;
    }

    public IPath getPath() {
        return new Path("org.eclipse.wst.jsdt.launching.WebProject");
    }

    public ImageDescriptor getImage(IPath containerPath, String element, IJavaProject project) {
        return ImageDescriptor.createFromFile(((Object)((Object)this)).getClass(), (String)"web1.JPG");
    }

    public IClasspathEntry[] getClasspathEntries() {
        return new IClasspathEntry[0];
    }

    public void initialize(IPath containerPath, IJavaProject project) throws CoreException {
        super.initialize(containerPath, project);
    }

    public static IPath getWebContextRoot(IJavaProject javaProject) {
        String webRoot = WebRootFinder.getWebContentFolder((IProject)javaProject.getProject()).toString();
        IPath webRootPath = javaProject.getPath().append(webRoot);
        return webRootPath;
    }
}

