/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.web.ui.internal.java.search;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.wst.jsdt.core.search.SearchDocument;
import org.eclipse.wst.jsdt.core.search.SearchMatch;
import org.eclipse.wst.jsdt.core.search.SearchParticipant;
import org.eclipse.wst.jsdt.core.search.SearchRequestor;
import org.eclipse.wst.jsdt.web.core.internal.java.JsTranslation;
import org.eclipse.wst.jsdt.web.core.internal.java.search.JSDTSearchDocumentDelegate;
import org.eclipse.wst.jsdt.web.core.internal.java.search.JsSearchSupport;

public class BasicJsSearchRequestor
extends SearchRequestor {
    private static final boolean DEBUG;

    static {
        String value = Platform.getDebugOption((String)"org.eclipse.wst.jsdt.web.core/debug/jspsearch");
        DEBUG = value != null && value.equalsIgnoreCase("true");
    }

    public void acceptSearchMatch(SearchMatch match) throws CoreException {
        if (JsSearchSupport.getInstance().isCanceled()) {
            return;
        }
        String matchDocumentPath = match.getResource().getFullPath().toString();
        SearchDocument searchDoc = JsSearchSupport.getInstance().getSearchDocument(matchDocumentPath);
        if (searchDoc != null && searchDoc instanceof JSDTSearchDocumentDelegate) {
            JSDTSearchDocumentDelegate javaSearchDoc = (JSDTSearchDocumentDelegate)searchDoc;
            int jspStart = match.getOffset();
            int jspEnd = match.getOffset() + match.getLength();
            JsTranslation trans = javaSearchDoc.getJspTranslation();
            String jspText = trans.getHtmlText();
            String javaText = javaSearchDoc.getJavaText();
            if (DEBUG) {
                this.displayDebugInfo(match, jspStart, jspEnd, jspText, javaText);
            }
            if (jspStart > -1 && jspEnd > -1) {
                this.addSearchMatch((IDocument)new Document(trans.getHtmlText()), javaSearchDoc.getFile(), jspStart, jspEnd, jspText);
            }
        }
    }

    protected void addSearchMatch(IDocument jspDocument, IFile jspFile, int jspStart, int jspEnd, String jspText) {
    }

    public void beginReporting() {
        if (DEBUG) {
            System.out.println("JSP Search requestor: beginReporting()");
        }
    }

    private void displayDebugInfo(SearchMatch origMatch, int jspStart, int jspEnd, String jspText, String javaText) {
        if (origMatch == null || jspStart == -1 || jspEnd == -1 || jspEnd < jspStart || jspText == null || javaText == null) {
            return;
        }
        System.out.println("+-----------------------------------------+");
        System.out.println("accept possible match [jspDoc: " + origMatch.getResource().getFullPath().toOSString() + " " + origMatch.getOffset() + ":" + origMatch.getOffset() + origMatch.getLength() + "]?");
        System.out.println("match info:");
        System.out.println("the java text is:" + javaText.substring(origMatch.getOffset(), origMatch.getOffset() + origMatch.getLength()));
        System.out.println("java search match translates to jsp coords [start: " + jspStart + " end:" + jspEnd + "]");
        System.out.println(" the jsp text is:" + jspText.substring(jspStart, jspEnd));
    }

    public void endReporting() {
        if (DEBUG) {
            System.out.println("JSP Search requestor: endReporting()");
        }
    }

    public void enterParticipant(SearchParticipant participant) {
        if (DEBUG) {
            System.out.println("JSP Search requestor: enterParticipant()");
        }
    }

    public void exitParticipant(SearchParticipant participant) {
        if (DEBUG) {
            System.out.println("JSP Search requestor: exitParticipant()");
        }
    }
}

