/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.web.ui.internal.java.search.ui;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.search.IJavaSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchRequestor;
import org.eclipse.wst.jsdt.ui.search.ElementQuerySpecification;
import org.eclipse.wst.jsdt.ui.search.IMatchPresentation;
import org.eclipse.wst.jsdt.ui.search.IQueryParticipant;
import org.eclipse.wst.jsdt.ui.search.ISearchRequestor;
import org.eclipse.wst.jsdt.ui.search.PatternQuerySpecification;
import org.eclipse.wst.jsdt.ui.search.QuerySpecification;
import org.eclipse.wst.jsdt.web.core.internal.java.search.JsSearchScope;
import org.eclipse.wst.jsdt.web.core.internal.java.search.JsSearchSupport;
import org.eclipse.wst.jsdt.web.ui.internal.java.search.JsSearchRequestor;
import org.eclipse.wst.jsdt.web.ui.internal.java.search.ui.JsMatchPresentation;

public class JsQueryParticipant
implements IQueryParticipant {
    private static final boolean DEBUG;

    static {
        String value = Platform.getDebugOption((String)"org.eclipse.wst.jsdt.web.core/debug/jspsearch");
        DEBUG = value != null && value.equalsIgnoreCase("true");
    }

    public int estimateTicks(QuerySpecification data) {
        return 0;
    }

    public IMatchPresentation getUIParticipant() {
        return new JsMatchPresentation();
    }

    public void search(ISearchRequestor requestor, QuerySpecification querySpecification, IProgressMonitor monitor) throws CoreException {
        if (querySpecification instanceof ElementQuerySpecification) {
            ElementQuerySpecification elementQuery = (ElementQuerySpecification)querySpecification;
            IJavaElement element = elementQuery.getElement();
            if (DEBUG) {
                System.out.println("JSP Query Participant searching on ELEMENT: " + element);
            }
            JsSearchRequestor jspRequestor = new JsSearchRequestor(requestor);
            JsSearchSupport.getInstance().search(element, (IJavaSearchScope)new JsSearchScope(), (SearchRequestor)jspRequestor);
        } else if (querySpecification instanceof PatternQuerySpecification) {
            PatternQuerySpecification patternQuery = (PatternQuerySpecification)querySpecification;
            String pattern = patternQuery.getPattern();
            if (DEBUG) {
                System.out.println("JSP Query Participant searching on PATTERN: " + pattern);
            }
            JsSearchRequestor jspRequestor = new JsSearchRequestor(requestor);
            JsSearchSupport.getInstance().search(pattern, (IJavaSearchScope)new JsSearchScope(), patternQuery.getSearchFor(), patternQuery.getLimitTo(), 2, false, (SearchRequestor)jspRequestor);
        }
    }
}

