/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.query.ocl.conditions;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.query.conditions.eobjects.EObjectCondition;
import org.eclipse.emf.query.conditions.eobjects.structuralfeatures.IEStructuralFeatureValueGetter;
import org.eclipse.emf.query.handlers.PruneHandler;
import org.eclipse.emf.query.ocl.internal.OCLPlugin;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.EvaluationEnvironment;
import org.eclipse.ocl.OCL;
import org.eclipse.ocl.ParserException;
import org.eclipse.ocl.Query;
import org.eclipse.ocl.helper.OCLHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOCLCondition<C, CLS, E>
extends EObjectCondition {
    private final C contextClassifier;
    private String oclExpressionString;
    private Query<C, CLS, E> oclQuery;
    private IEStructuralFeatureValueGetter eStructuralFeatureValueGetter;
    private Map<C, OCLQueryCacheEntry<C, CLS, E>> contextFreeOCLQueriesMap;
    private final OCL<?, C, ?, ?, ?, ?, ?, ?, ?, ?, CLS, E> ocl;
    private final EvaluationEnvironment<C, ?, ?, CLS, E> evalEnv;

    protected AbstractOCLCondition(Environment<?, C, ?, ?, ?, ?, ?, ?, ?, ?, CLS, E> env, String oclExpressionString, C contextClassifier, IEStructuralFeatureValueGetter eStructuralFeatureValueGetter) throws ParserException {
        this(env, oclExpressionString, contextClassifier, eStructuralFeatureValueGetter, PruneHandler.NEVER);
    }

    protected AbstractOCLCondition(Environment<?, C, ?, ?, ?, ?, ?, ?, ?, ?, CLS, E> env, String oclExpressionString, C contextClassifier, IEStructuralFeatureValueGetter eStructuralFeatureValueGetter, PruneHandler pruneHandler) throws ParserException {
        super(pruneHandler);
        this.ocl = OCL.newInstance(env);
        this.evalEnv = env.getFactory().createEvaluationEnvironment();
        this.oclExpressionString = oclExpressionString;
        this.contextClassifier = contextClassifier;
        this.eStructuralFeatureValueGetter = eStructuralFeatureValueGetter;
        if (contextClassifier != null) {
            OCLHelper helper = this.ocl.createOCLHelper();
            helper.setContext(contextClassifier);
            this.oclQuery = this.ocl.createQuery(helper.createQuery(oclExpressionString));
        }
    }

    protected AbstractOCLCondition(Environment<?, C, ?, ?, ?, ?, ?, ?, ?, ?, CLS, E> env, Query<C, CLS, E> oclQuery, C contextClassifier, IEStructuralFeatureValueGetter eStructuralFeatureValueGetter, PruneHandler pruneHandler) {
        super(pruneHandler);
        this.ocl = OCL.newInstance(env);
        this.evalEnv = env.getFactory().createEvaluationEnvironment();
        this.oclQuery = oclQuery;
        this.oclExpressionString = oclQuery.queryText();
        if (contextClassifier == null) {
            throw new NullPointerException("null contextEObjectType");
        }
        this.contextClassifier = contextClassifier;
        this.eStructuralFeatureValueGetter = eStructuralFeatureValueGetter;
    }

    protected final Query<C, CLS, E> getOCLQuery() {
        return this.oclQuery;
    }

    public boolean isSatisfied(EObject eObject) {
        if (!this.isContextFree()) {
            return this.evalEnv.isKindOf((Object)eObject, this.getContextClassifier());
        }
        return this.getOCLQueryRecord(this.evalEnv.getType((Object)eObject)).hasOCLQuery();
    }

    public C getResultType(EObject eObject) {
        if (!this.isContextFree()) {
            return (C)this.getOCLQuery().resultType();
        }
        if (eObject != null) {
            Query<Object, CLS, E> query = this.getOCLQueryRecord(this.evalEnv.getType((Object)eObject)).getCachedOCLQuery();
            if (query != null) {
                return (C)query.resultType();
            }
        } else if (!this.getOCLQueryRecordMap().isEmpty()) {
            for (OCLQueryCacheEntry<C, CLS, E> entry : this.getOCLQueryRecordMap().values()) {
                Query<C, CLS, E> query = entry.getCachedOCLQuery();
                if (query == null) continue;
                return (C)query.resultType();
            }
        }
        return null;
    }

    private Map<C, OCLQueryCacheEntry<C, CLS, E>> getOCLQueryRecordMap() {
        if (this.contextFreeOCLQueriesMap == null) {
            this.contextFreeOCLQueriesMap = new HashMap<C, OCLQueryCacheEntry<C, CLS, E>>();
        }
        return this.contextFreeOCLQueriesMap;
    }

    private OCLQueryCacheEntry<C, CLS, E> getOCLQueryRecord(C context) {
        OCLQueryCacheEntry<C, CLS, E> oclQueryRecord = this.getOCLQueryRecordMap().get(context);
        if (oclQueryRecord == null) {
            Query query = null;
            try {
                OCLHelper helper = this.ocl.createOCLHelper();
                helper.setContext(context);
                query = this.ocl.createQuery(helper.createQuery(this.oclExpressionString));
            }
            catch (Exception ex) {
                OCLPlugin.catching(((Object)((Object)this)).getClass(), "getOCLQueryRecord", ex);
                query = null;
            }
            oclQueryRecord = new OCLQueryCacheEntry(context, query);
            this.getOCLQueryRecordMap().put(oclQueryRecord.getContextClassifier(), oclQueryRecord);
        }
        this.oclQuery = oclQueryRecord.getCachedOCLQuery();
        return oclQueryRecord;
    }

    protected final boolean isContextFree() {
        return this.getContextClassifier() == null;
    }

    public final IEStructuralFeatureValueGetter getEStructuralFeatureValueGetter() {
        return this.eStructuralFeatureValueGetter;
    }

    public final void setEStructuralFeatureValueGetter(IEStructuralFeatureValueGetter eStructuralFeatureValueGetter) {
        this.eStructuralFeatureValueGetter = eStructuralFeatureValueGetter;
    }

    public Object evaluate(EObject eObject) {
        if (!this.isContextFree() || eObject != null && this.getOCLQueryRecord(this.evalEnv.getType((Object)eObject)).hasOCLQuery()) {
            if (eObject == null) {
                return this.getOCLQuery().evaluate();
            }
            return this.getOCLQuery().evaluate((Object)this.getEStructuralFeatureValueGetter().resolve(eObject));
        }
        return null;
    }

    protected final C getContextClassifier() {
        return this.contextClassifier;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class OCLQueryCacheEntry<C, CLS, E> {
        private C contextClassifier;
        private Query<C, CLS, E> cachedOCLQuery;

        OCLQueryCacheEntry(C contextClassifier, Query<C, CLS, E> oclQuery) {
            this.contextClassifier = contextClassifier;
            this.cachedOCLQuery = oclQuery;
        }

        Query<C, CLS, E> getCachedOCLQuery() {
            return this.cachedOCLQuery;
        }

        C getContextClassifier() {
            return this.contextClassifier;
        }

        boolean hasOCLQuery() {
            return this.getCachedOCLQuery() != null;
        }
    }
}

