/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.core.internal;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.project.facet.core.IPresetFactory;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.PresetDefinition;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MinimalConfigurationPresetFactory
implements IPresetFactory {
    @Override
    public PresetDefinition createPreset(String presetId, Map<String, Object> context) throws CoreException {
        Set fixed = (Set)context.get("CONTEXT_KEY_FIXED_FACETS");
        if (fixed == null) {
            return null;
        }
        IRuntime runtime = (IRuntime)context.get("CONTEXT_KEY_PRIMARY_RUNTIME");
        HashSet<IProjectFacetVersion> facets = new HashSet<IProjectFacetVersion>();
        if (runtime != null) {
            Set<IProjectFacetVersion> defaultFacets = runtime.getDefaultFacets(fixed);
            for (IProjectFacet f : fixed) {
                facets.add(MinimalConfigurationPresetFactory.findProjectFacetVersion(defaultFacets, f));
            }
        } else {
            for (IProjectFacet f : fixed) {
                facets.add(f.getDefaultVersion());
            }
        }
        return new PresetDefinition(Resources.presetLabel, Resources.presetDescription, facets);
    }

    private static IProjectFacetVersion findProjectFacetVersion(Set<IProjectFacetVersion> facets, IProjectFacet facet) {
        for (IProjectFacetVersion fv : facets) {
            if (fv.getProjectFacet() != facet) continue;
            return fv;
        }
        throw new IllegalStateException();
    }

    private static final class Resources
    extends NLS {
        public static String presetLabel;
        public static String presetDescription;

        static {
            Resources.initializeMessages((String)MinimalConfigurationPresetFactory.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

