/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.core.internal.util;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

public final class ProgressMonitorUtil {
    private ProgressMonitorUtil() {
    }

    public static void beginTask(IProgressMonitor monitor, String taskName, int totalWork) {
        if (monitor != null) {
            monitor.beginTask(taskName, totalWork);
        }
    }

    public static void worked(IProgressMonitor monitor, int work) {
        if (monitor != null) {
            monitor.worked(work);
        }
    }

    public static void done(IProgressMonitor monitor) {
        if (monitor != null) {
            monitor.done();
        }
    }

    public static IProgressMonitor submon(IProgressMonitor parent, int ticks) {
        return ProgressMonitorUtil.submon(parent, ticks, 2);
    }

    public static IProgressMonitor submon(IProgressMonitor parent, int ticks, int style) {
        return parent == null ? null : new SubProgressMonitor(parent, ticks, style);
    }

    public static void subTask(IProgressMonitor monitor, String taskName) {
        if (monitor != null) {
            monitor.subTask(taskName);
        }
    }

    public static void checkIfCanceled(IProgressMonitor monitor) throws InterruptedException {
        if (monitor != null && monitor.isCanceled()) {
            throw new InterruptedException();
        }
    }
}

