/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.db.internal;

import java.text.Collator;
import java.util.NoSuchElementException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.jpt.db.internal.Catalog;
import org.eclipse.jpt.db.internal.ConnectionListener;
import org.eclipse.jpt.db.internal.ConnectionProfileRepository;
import org.eclipse.jpt.db.internal.DTPConnectionProfileWrapper;
import org.eclipse.jpt.db.internal.DTPWrapper;
import org.eclipse.jpt.db.internal.Database;
import org.eclipse.jpt.db.internal.NullConnectionProfile;
import org.eclipse.jpt.db.internal.ProfileListener;
import org.eclipse.jpt.db.internal.Schema;
import org.eclipse.jpt.db.internal.Table;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ConnectionProfile
extends DTPWrapper
implements Comparable<ConnectionProfile> {
    private Database database;
    private String catalogName;
    private ConnectionListener connectionListener;
    private ConnectionProfileRepository profileRepository;

    static ConnectionProfile createProfile(ConnectionProfileRepository profileRepository, IConnectionProfile dtpProfile) {
        return dtpProfile == null ? NullConnectionProfile.instance() : new DTPConnectionProfileWrapper(profileRepository, dtpProfile);
    }

    ConnectionProfile(ConnectionProfileRepository profileRepository) {
        this.profileRepository = profileRepository;
        this.connectionListener = this.buildConnectionListener();
        this.catalogName = "";
    }

    public abstract void connect();

    public abstract void disconnect();

    protected abstract Database buildDatabase();

    abstract void databaseChanged(Database var1, int var2);

    abstract void catalogChanged(Catalog var1, Database var2, int var3);

    abstract void schemaChanged(Schema var1, Database var2, int var3);

    abstract void tableChanged(Table var1, Schema var2, Database var3, int var4);

    protected void refreshDatabase() {
        this.disposeDatabase();
    }

    @Override
    protected void dispose() {
        this.disengageConnectionListener();
        this.disposeDatabase();
    }

    private void disposeDatabase() {
        if (this.database != null) {
            this.getDatabase().dispose();
            this.database = null;
        }
    }

    public abstract IStatus saveWorkOfflineData();

    public abstract IStatus workOffline();

    abstract boolean wraps(IConnectionProfile var1);

    public Database getDatabase() {
        if (this.database == null) {
            this.database = this.buildDatabase();
            this.setDefaultCatalogName();
        }
        return this.database;
    }

    public abstract String getDatabaseName();

    public abstract String getDatabaseProduct();

    public abstract String getDatabaseVendor();

    public abstract String getDatabaseVersion();

    public abstract String getDriverClass();

    public abstract String getUrl();

    public abstract String getUserName();

    public abstract String getUserPassword();

    public abstract String getDefaultSchema();

    public abstract String getInstanceId();

    public abstract String getProviderId();

    public abstract String getDriverDefinitionId();

    public abstract String getDriverJarList();

    public abstract boolean isConnected();

    public abstract boolean isWorkingOffline();

    public abstract boolean supportsWorkOfflineMode();

    public abstract boolean canWorkOffline();

    @Override
    protected boolean connectionIsOnline() {
        return this.isConnected() && !this.isWorkingOffline();
    }

    public boolean isNull() {
        return true;
    }

    ConnectionProfileRepository getProfileRepository() {
        return this.profileRepository;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public void setDefaultCatalogName() {
        this.setCatalogName(this.database.getDefaultCatalogName());
    }

    public void setCatalogName(String catalogName) {
        if (this.catalogName == catalogName) {
            return;
        }
        if (this.database.supportsCatalogs()) {
            String name = catalogName != null ? catalogName : this.database.getDefaultCatalogName();
            Catalog catalog = this.database.catalogNamed(name);
            if (catalog == null) {
                throw new NoSuchElementException();
            }
            this.catalogName = name;
            this.database.refresh();
            this.catalogChanged(catalog, this.database, 0);
        } else {
            this.catalogName = "";
            this.database.refresh();
        }
    }

    public abstract void addProfileListener(ProfileListener var1);

    public abstract void removeProfileListener(ProfileListener var1);

    public abstract void addConnectionListener(ConnectionListener var1);

    public abstract void removeConnectionListener(ConnectionListener var1);

    private ConnectionListener buildConnectionListener() {
        return new ConnectionListener(){

            public void aboutToClose(ConnectionProfile profile) {
            }

            public void closed(ConnectionProfile profile) {
                ConnectionProfile.this.refreshDatabase();
            }

            public void modified(ConnectionProfile profile) {
            }

            public boolean okToClose(ConnectionProfile profile) {
                return true;
            }

            public void opened(ConnectionProfile profile) {
                ConnectionProfile.this.refreshDatabase();
            }

            public void databaseChanged(ConnectionProfile profile, Database db) {
            }

            public void schemaChanged(ConnectionProfile profile, Schema schema) {
            }

            public void tableChanged(ConnectionProfile profile, Table table) {
            }
        };
    }

    protected void disengageConnectionListener() {
        this.removeConnectionListener();
    }

    protected void engageConnectionListener() {
        this.addConnectionListener();
    }

    private void addConnectionListener() {
        this.addConnectionListener(this.connectionListener);
    }

    private void removeConnectionListener() {
        this.removeConnectionListener(this.connectionListener);
    }

    @Override
    public int compareTo(ConnectionProfile connectionProfile) {
        return Collator.getInstance().compare(this.getName(), connectionProfile.getName());
    }
}

