/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.db.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.IProfileListener;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.jpt.db.internal.ConnectionProfile;
import org.eclipse.jpt.db.internal.NullConnectionProfile;
import org.eclipse.jpt.db.internal.ProfileListener;
import org.eclipse.jpt.utility.internal.iterators.CloneIterator;
import org.eclipse.jpt.utility.internal.iterators.TransformationIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionProfileRepository {
    private final ProfileManager dtpProfileManager = ProfileManager.getInstance();
    private LocalProfileListener profileListener;
    private Set<ConnectionProfile> profiles;
    public static final String DATABASE_CATEGORY_ID = "org.eclipse.datatools.connectivity.db.category";
    private static final ConnectionProfileRepository INSTANCE = new ConnectionProfileRepository();

    public static ConnectionProfileRepository instance() {
        return INSTANCE;
    }

    private ConnectionProfileRepository() {
    }

    public void start() {
        if (this.profileListener == null) {
            this.profileListener = new LocalProfileListener();
            this.dtpProfileManager.addProfileListener((IProfileListener)this.profileListener);
        }
    }

    public void stop() {
        Iterator<ConnectionProfile> stream = this.profiles();
        while (stream.hasNext()) {
            stream.next().dispose();
        }
        if (this.profileListener != null) {
            this.dtpProfileManager.removeProfileListener((IProfileListener)this.profileListener);
            this.profileListener = null;
        }
    }

    public String toString() {
        return this.profiles.toString();
    }

    public Iterator<ConnectionProfile> profiles() {
        return new CloneIterator(this.getProfiles());
    }

    public Iterator<String> profileNames() {
        return new TransformationIterator<ConnectionProfile, String>(this.profiles()){

            protected String transform(ConnectionProfile profile) {
                return profile.getName();
            }
        };
    }

    public ConnectionProfile profileNamed(String name) {
        Iterator<ConnectionProfile> stream = this.profiles();
        while (stream.hasNext()) {
            ConnectionProfile profile = stream.next();
            if (!profile.getName().equals(name)) continue;
            return profile;
        }
        return NullConnectionProfile.instance();
    }

    private Set<ConnectionProfile> getProfiles() {
        if (this.profiles == null) {
            this.profiles = this.buildProfiles();
        }
        return this.profiles;
    }

    private Set<ConnectionProfile> buildProfiles() {
        IConnectionProfile[] dtpProfiles = this.dtpProfileManager.getProfiles();
        Set<ConnectionProfile> result = Collections.synchronizedSet(new HashSet(dtpProfiles.length));
        IConnectionProfile[] iConnectionProfileArray = dtpProfiles;
        int n = dtpProfiles.length;
        int n2 = 0;
        while (n2 < n) {
            IConnectionProfile dtpProfile = iConnectionProfileArray[n2];
            result.add(ConnectionProfile.createProfile(this, dtpProfile));
            ++n2;
        }
        return result;
    }

    ConnectionProfile addProfile(IConnectionProfile dtpProfile) {
        ConnectionProfile cp = this.profile(dtpProfile);
        if (cp.isNull()) {
            cp = ConnectionProfile.createProfile(this, dtpProfile);
            this.profiles.add(cp);
        }
        return cp;
    }

    ConnectionProfile removeProfile(IConnectionProfile dtpProfile) {
        ConnectionProfile cp = this.profile(dtpProfile);
        this.profiles.remove(cp);
        return cp;
    }

    ConnectionProfile profile(IConnectionProfile dtpProfile) {
        Iterator<ConnectionProfile> stream = this.profiles();
        while (stream.hasNext()) {
            ConnectionProfile profile = stream.next();
            if (!profile.wraps(dtpProfile)) continue;
            return profile;
        }
        return NullConnectionProfile.instance();
    }

    public void addProfileListener(ProfileListener listener) {
        this.profileListener.addProfileListener(listener);
    }

    public void removeProfileListener(ProfileListener listener) {
        this.profileListener.removeProfileListener(listener);
    }

    private void addInternalProfileListener(IProfileListener listener) {
        this.dtpProfileManager.addProfileListener(listener);
    }

    private void removeInternalProfileListener(IProfileListener listener) {
        this.dtpProfileManager.removeProfileListener(listener);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LocalProfileListener
    implements IProfileListener {
        private Collection<ProfileListener> listeners = new Vector<ProfileListener>();

        LocalProfileListener() {
        }

        void addProfileListener(ProfileListener listener) {
            this.listeners.add(listener);
        }

        void removeProfileListener(ProfileListener listener) {
            this.listeners.remove(listener);
        }

        private Iterator<ProfileListener> listeners() {
            return new CloneIterator(this.listeners);
        }

        public void profileAdded(IConnectionProfile dtpProfile) {
            ConnectionProfile profile = ConnectionProfileRepository.this.addProfile(dtpProfile);
            Iterator<ProfileListener> stream = this.listeners();
            while (stream.hasNext()) {
                stream.next().profileReplaced(NullConnectionProfile.instance(), profile);
            }
        }

        public void profileChanged(IConnectionProfile dtpProfile) {
            ConnectionProfile profile = ConnectionProfileRepository.this.profile(dtpProfile);
            Iterator<ProfileListener> stream = this.listeners();
            while (stream.hasNext()) {
                stream.next().profileChanged(profile);
            }
        }

        public void profileDeleted(IConnectionProfile dtpProfile) {
            ConnectionProfile profile = ConnectionProfileRepository.this.removeProfile(dtpProfile);
            Iterator<ProfileListener> stream = this.listeners();
            while (stream.hasNext()) {
                stream.next().profileReplaced(profile, NullConnectionProfile.instance());
            }
        }
    }
}

