/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.db.internal;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.datatools.connectivity.ConnectEvent;
import org.eclipse.datatools.connectivity.IManagedConnection;
import org.eclipse.datatools.connectivity.IManagedConnectionListener;
import org.eclipse.datatools.connectivity.IManagedConnectionOfflineListener;
import org.eclipse.jpt.db.internal.Connection;
import org.eclipse.jpt.db.internal.ConnectionListener;
import org.eclipse.jpt.db.internal.DTPConnectionProfileWrapper;
import org.eclipse.jpt.db.internal.Database;
import org.eclipse.jpt.db.internal.Schema;
import org.eclipse.jpt.db.internal.Table;

final class DTPConnectionWrapper
extends Connection {
    private final DTPConnectionProfileWrapper profile;
    private LocalConnectionListener connectionListener;

    DTPConnectionWrapper(DTPConnectionProfileWrapper profile) {
        this.profile = profile;
        this.initialize();
    }

    protected void initialize() {
        this.connectionListener = new LocalConnectionListener();
        this.getDTPConnection().addConnectionListener((IManagedConnectionListener)this.connectionListener);
        this.getDTPOfflineConnection().addConnectionListener((IManagedConnectionListener)this.connectionListener);
    }

    protected void dispose() {
        this.getDTPConnection().removeConnectionListener((IManagedConnectionListener)this.connectionListener);
        this.getDTPOfflineConnection().removeConnectionListener((IManagedConnectionListener)this.connectionListener);
    }

    void databaseChanged(Database database, int eventType) {
        this.connectionListener.databaseChanged(database, eventType);
    }

    void schemaChanged(Schema schema, Database database, int eventType) {
        this.connectionListener.schemaChanged(schema, database, eventType);
    }

    void tableChanged(Table table, Schema schema, Database database, int eventType) {
        this.connectionListener.tableChanged(table, schema, database, eventType);
    }

    private IManagedConnection getDTPConnection() {
        return this.profile.getDTPConnection();
    }

    private IManagedConnection getDTPOfflineConnection() {
        return this.profile.getDTPOfflineConnection();
    }

    public String getName() {
        return this.getDTPConnection().getConnection().getConnectionProfile().getName();
    }

    String getFactoryId() {
        return this.getDTPConnection().getFactoryID();
    }

    protected boolean connectionIsOnline() {
        return this.profile.connectionIsOnline();
    }

    void addConnectionListener(ConnectionListener listener) {
        this.connectionListener.addConnectionListener(listener);
    }

    void removeConnectionListener(ConnectionListener listener) {
        this.connectionListener.removeConnectionListener(listener);
    }

    private class LocalConnectionListener
    implements IManagedConnectionOfflineListener {
        private Collection<ConnectionListener> listeners = new ArrayList<ConnectionListener>();

        LocalConnectionListener() {
        }

        void addConnectionListener(ConnectionListener listener) {
            this.listeners.add(listener);
        }

        void removeConnectionListener(ConnectionListener listener) {
            this.listeners.remove(listener);
        }

        public void aboutToClose(ConnectEvent event) {
            if (event.getConnection() == DTPConnectionWrapper.this.getDTPConnection()) {
                for (ConnectionListener listener : this.listeners) {
                    listener.aboutToClose(DTPConnectionWrapper.this.profile);
                }
            }
        }

        public void aboutToDetach(ConnectEvent event) {
            if (event.getConnection() == DTPConnectionWrapper.this.getDTPOfflineConnection()) {
                for (ConnectionListener listener : this.listeners) {
                    listener.aboutToClose(DTPConnectionWrapper.this.profile);
                }
            }
        }

        public void closed(ConnectEvent event) {
            for (ConnectionListener listener : this.listeners) {
                listener.closed(DTPConnectionWrapper.this.profile);
            }
        }

        public boolean okToClose(ConnectEvent event) {
            if (event.getConnection() == DTPConnectionWrapper.this.getDTPConnection()) {
                for (ConnectionListener listener : this.listeners) {
                    if (listener.okToClose(DTPConnectionWrapper.this.profile)) continue;
                    return false;
                }
            }
            return true;
        }

        public boolean okToDetach(ConnectEvent event) {
            if (event.getConnection() == DTPConnectionWrapper.this.getDTPOfflineConnection()) {
                for (ConnectionListener listener : this.listeners) {
                    if (listener.okToClose(DTPConnectionWrapper.this.profile)) continue;
                    return false;
                }
            }
            return true;
        }

        public void opened(ConnectEvent event) {
            if (event.getConnection() == DTPConnectionWrapper.this.getDTPConnection()) {
                for (ConnectionListener listener : this.listeners) {
                    listener.opened(DTPConnectionWrapper.this.profile);
                }
            }
        }

        public void workingOffline(ConnectEvent event) {
            for (ConnectionListener listener : this.listeners) {
                listener.opened(DTPConnectionWrapper.this.profile);
            }
        }

        public void aboutToAttach(ConnectEvent event) {
        }

        public void modified(ConnectEvent event) {
            for (ConnectionListener listener : this.listeners) {
                listener.modified(DTPConnectionWrapper.this.profile);
            }
        }

        void databaseChanged(Database database, int eventType) {
            for (ConnectionListener listener : this.listeners) {
                listener.databaseChanged(DTPConnectionWrapper.this.profile, database);
            }
        }

        void schemaChanged(Schema schema, Database database, int eventType) {
            for (ConnectionListener listener : this.listeners) {
                listener.schemaChanged(DTPConnectionWrapper.this.profile, schema);
            }
        }

        void tableChanged(Table table, Schema schema, Database database, int eventType) {
            for (ConnectionListener listener : this.listeners) {
                listener.tableChanged(DTPConnectionWrapper.this.profile, table);
            }
        }
    }
}

