/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.db.internal;

import java.util.HashMap;
import org.eclipse.datatools.modelbase.sql.datatypes.PrimitiveType;
import org.eclipse.jpt.utility.internal.JDBCTools;
import org.eclipse.jpt.utility.internal.JDBCType;
import org.eclipse.jpt.utility.internal.JavaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DTPTools {
    private static HashMap<String, PrimitiveToJDBCTypeMapping> PRIMITIVE_TO_JDBC_TYPE_MAPPINGS;
    private static final JDBCType DEFAULT_JDBC_TYPE;

    static {
        DEFAULT_JDBC_TYPE = JDBCType.type((int)12);
    }

    public static JDBCType jdbcTypeForPrimitiveTypeNamed(String primitiveTypeName) {
        PrimitiveToJDBCTypeMapping mapping = DTPTools.primitiveToJDBCTypeMapping(primitiveTypeName);
        return mapping == null ? DEFAULT_JDBC_TYPE : mapping.getJDBCType();
    }

    public static JDBCType jdbcTypeFor(PrimitiveType primitiveType) {
        return DTPTools.jdbcTypeForPrimitiveTypeNamed(primitiveType.getName());
    }

    public static JDBCType jdbcTypeForPrimitiveTypeCode(int primitiveTypeCode) {
        return DTPTools.jdbcTypeFor(PrimitiveType.get((int)primitiveTypeCode));
    }

    public static JavaType javaTypeForPrimitiveTypeNamed(String primitiveTypeName) {
        return JDBCTools.javaTypeFor((JDBCType)DTPTools.jdbcTypeForPrimitiveTypeNamed(primitiveTypeName));
    }

    public static JavaType javaTypeFor(PrimitiveType primitiveType) {
        return JDBCTools.javaTypeFor((JDBCType)DTPTools.jdbcTypeFor(primitiveType));
    }

    public static JavaType javaTypeForPrimitiveTypeCode(int primitiveTypeCode) {
        return JDBCTools.javaTypeFor((JDBCType)DTPTools.jdbcTypeForPrimitiveTypeCode(primitiveTypeCode));
    }

    public static boolean dataTypeIsLob(PrimitiveType primitiveType) {
        return primitiveType == PrimitiveType.BINARY_LARGE_OBJECT_LITERAL || primitiveType == PrimitiveType.CHARACTER_LARGE_OBJECT_LITERAL || primitiveType == PrimitiveType.NATIONAL_CHARACTER_LARGE_OBJECT_LITERAL;
    }

    private static PrimitiveToJDBCTypeMapping primitiveToJDBCTypeMapping(String primitiveTypeName) {
        return DTPTools.primitiveToJDBCTypeMappings().get(primitiveTypeName);
    }

    private static synchronized HashMap<String, PrimitiveToJDBCTypeMapping> primitiveToJDBCTypeMappings() {
        if (PRIMITIVE_TO_JDBC_TYPE_MAPPINGS == null) {
            PRIMITIVE_TO_JDBC_TYPE_MAPPINGS = DTPTools.buildPrimitiveToJDBCTypeMappings();
        }
        return PRIMITIVE_TO_JDBC_TYPE_MAPPINGS;
    }

    private static HashMap<String, PrimitiveToJDBCTypeMapping> buildPrimitiveToJDBCTypeMappings() {
        HashMap<String, PrimitiveToJDBCTypeMapping> mappings = new HashMap<String, PrimitiveToJDBCTypeMapping>();
        DTPTools.addPrimitiveToJDBCTypeMappingsTo(mappings);
        return mappings;
    }

    private static void addPrimitiveToJDBCTypeMappingsTo(HashMap<String, PrimitiveToJDBCTypeMapping> mappings) {
        DTPTools.addPrimitiveToJDBCTypeMappingTo(PrimitiveType.BIGINT_LITERAL, -5, mappings);
        DTPTools.addPrimitiveToJDBCTypeMappingTo(PrimitiveType.BINARY_LARGE_OBJECT_LITERAL, 2004, mappings);
        DTPTools.addPrimitiveToJDBCTypeMappingTo(PrimitiveType.BINARY_LITERAL, -2, mappings);
        DTPTools.addPrimitiveToJDBCTypeMappingTo(PrimitiveType.BINARY_VARYING_LITERAL, -3, mappings);
        DTPTools.addPrimitiveToJDBCTypeMappingTo(PrimitiveType.BOOLEAN_LITERAL, 16, mappings);
        DTPTools.addPrimitiveToJDBCTypeMappingTo(PrimitiveType.CHARACTER_LARGE_OBJECT_LITERAL, 2005, mappings);
        DTPTools.addPrimitiveToJDBCTypeMappingTo(PrimitiveType.CHARACTER_LITERAL, 1, mappings);
        DTPTools.addPrimitiveToJDBCTypeMappingTo(PrimitiveType.CHARACTER_VARYING_LITERAL, 12, mappings);
        DTPTools.addPrimitiveToJDBCTypeMappingTo(PrimitiveType.DATALINK_LITERAL, 70, mappings);
        DTPTools.addPrimitiveToJDBCTypeMappingTo(PrimitiveType.DATE_LITERAL, 91, mappings);
        DTPTools.addPrimitiveToJDBCTypeMappingTo(PrimitiveType.DECIMAL_LITERAL, 3, mappings);
        DTPTools.addPrimitiveToJDBCTypeMappingTo(PrimitiveType.DOUBLE_PRECISION_LITERAL, 8, mappings);
        DTPTools.addPrimitiveToJDBCTypeMappingTo(PrimitiveType.FLOAT_LITERAL, 6, mappings);
        DTPTools.addPrimitiveToJDBCTypeMappingTo(PrimitiveType.INTEGER_LITERAL, 4, mappings);
        DTPTools.addPrimitiveToJDBCTypeMappingTo(PrimitiveType.INTERVAL_LITERAL, 1111, mappings);
        DTPTools.addPrimitiveToJDBCTypeMappingTo(PrimitiveType.NATIONAL_CHARACTER_LARGE_OBJECT_LITERAL, 2005, mappings);
        DTPTools.addPrimitiveToJDBCTypeMappingTo(PrimitiveType.NATIONAL_CHARACTER_LITERAL, 1, mappings);
        DTPTools.addPrimitiveToJDBCTypeMappingTo(PrimitiveType.NATIONAL_CHARACTER_VARYING_LITERAL, 12, mappings);
        DTPTools.addPrimitiveToJDBCTypeMappingTo(PrimitiveType.NUMERIC_LITERAL, 2, mappings);
        DTPTools.addPrimitiveToJDBCTypeMappingTo(PrimitiveType.REAL_LITERAL, 7, mappings);
        DTPTools.addPrimitiveToJDBCTypeMappingTo(PrimitiveType.SMALLINT_LITERAL, 5, mappings);
        DTPTools.addPrimitiveToJDBCTypeMappingTo(PrimitiveType.TIME_LITERAL, 92, mappings);
        DTPTools.addPrimitiveToJDBCTypeMappingTo(PrimitiveType.TIMESTAMP_LITERAL, 93, mappings);
        DTPTools.addPrimitiveToJDBCTypeMappingTo(PrimitiveType.XML_TYPE_LITERAL, 1111, mappings);
    }

    private static void addPrimitiveToJDBCTypeMappingTo(PrimitiveType primitiveType, int jdbcTypeCode, HashMap<String, PrimitiveToJDBCTypeMapping> mappings) {
        PrimitiveToJDBCTypeMapping prev = mappings.put(primitiveType.getName(), DTPTools.buildPrimitiveToJDBCTypeMapping(primitiveType, jdbcTypeCode));
        if (prev != null) {
            throw new IllegalArgumentException("duplicate Java class: " + prev.getPrimitiveType().getName());
        }
    }

    private static PrimitiveToJDBCTypeMapping buildPrimitiveToJDBCTypeMapping(PrimitiveType primitiveType, int jdbcTypeCode) {
        return new PrimitiveToJDBCTypeMapping(primitiveType, JDBCType.type((int)jdbcTypeCode));
    }

    private DTPTools() {
        throw new UnsupportedOperationException();
    }

    private static class PrimitiveToJDBCTypeMapping {
        private final PrimitiveType primitiveType;
        private final JDBCType jdbcType;

        PrimitiveToJDBCTypeMapping(PrimitiveType primitiveType, JDBCType jdbcType) {
            this.primitiveType = primitiveType;
            this.jdbcType = jdbcType;
        }

        public PrimitiveType getPrimitiveType() {
            return this.primitiveType;
        }

        public JDBCType getJDBCType() {
            return this.jdbcType;
        }

        public boolean maps(PrimitiveType pt) {
            return this.primitiveType.equals(pt);
        }

        public boolean maps(String primitiveTypeName) {
            return this.primitiveType.getName().equals(primitiveTypeName);
        }

        public boolean maps(int primitiveTypeCode) {
            return this.primitiveType.getValue() == primitiveTypeCode;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            this.appendTo(sb);
            return sb.toString();
        }

        public void appendTo(StringBuilder sb) {
            sb.append(this.primitiveType.getName());
            sb.append(" => ");
            this.jdbcType.appendTo(sb);
        }
    }
}

