/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.web.archive.operations;

import java.io.File;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.j2ee.classpathdep.IClasspathDependencyConstants;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.OpenFailureException;
import org.eclipse.jst.j2ee.componentcore.J2EEModuleVirtualComponent;
import org.eclipse.jst.j2ee.internal.archive.operations.ComponentLoadStrategyImpl;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.j2ee.internal.project.ProjectSupportResourceHandler;
import org.eclipse.jst.j2ee.web.componentcore.util.WebArtifactEdit;
import org.eclipse.wst.common.componentcore.ArtifactEdit;
import org.eclipse.wst.common.componentcore.internal.resources.VirtualArchiveComponent;
import org.eclipse.wst.common.componentcore.internal.util.ComponentUtilities;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;

public class WebComponentLoadStrategyImpl
extends ComponentLoadStrategyImpl {
    public WebComponentLoadStrategyImpl(IVirtualComponent vComponent) {
        super(vComponent);
    }

    public WebComponentLoadStrategyImpl(IVirtualComponent vComponent, boolean includeClasspathComponents) {
        super(vComponent, includeClasspathComponents);
    }

    public List getFiles() {
        super.getFiles();
        this.addLooseLibJARsToFiles();
        if (this.includeClasspathComponents) {
            this.addMappedClassFolders(IClasspathDependencyConstants.WEB_INF_CLASSES_PATH);
        }
        return this.filesHolder.getFiles();
    }

    public IVirtualReference[] getLibModules() {
        WebArtifactEdit webArtifactEdit = null;
        try {
            webArtifactEdit = (WebArtifactEdit)ComponentUtilities.getArtifactEditForRead((IVirtualComponent)this.getComponent());
            if (webArtifactEdit != null) {
                IVirtualReference[] iVirtualReferenceArray = webArtifactEdit.getLibModules();
                return iVirtualReferenceArray;
            }
        }
        finally {
            if (webArtifactEdit != null) {
                webArtifactEdit.dispose();
            }
        }
        return null;
    }

    public void addLooseLibJARsToFiles() {
        IVirtualReference[] libModules = this.getLibModules();
        int i = 0;
        while (i < libModules.length) {
            IVirtualReference iLibModule = libModules[i];
            IVirtualComponent looseComponent = iLibModule.getReferencedComponent();
            if (looseComponent.isBinary()) {
                VirtualArchiveComponent archiveComp = (VirtualArchiveComponent)looseComponent;
                File diskFile = archiveComp.getUnderlyingDiskFile();
                if (!diskFile.exists()) {
                    IFile wbFile = archiveComp.getUnderlyingWorkbenchFile();
                    diskFile = new File(wbFile.getLocation().toOSString());
                }
                String uri = String.valueOf(iLibModule.getRuntimePath().makeRelative().toString()) + "/" + diskFile.getName();
                this.addExternalFile(uri, diskFile);
            } else {
                String name = null;
                String archiveName = iLibModule.getArchiveName();
                name = archiveName != null && archiveName.length() > 0 ? archiveName : String.valueOf(looseComponent.getName()) + ".jar";
                String prefix = iLibModule.getRuntimePath().makeRelative().toString();
                if (prefix.length() > 0 && prefix.charAt(prefix.length() - 1) != '/') {
                    prefix = String.valueOf(prefix) + "/";
                }
                this.addClasspathComponentDependencies(looseComponent);
                String uri = String.valueOf(prefix) + name;
                try {
                    Archive utilJAR = J2EEProjectUtilities.asArchive((String)uri, (IProject)looseComponent.getProject(), (boolean)this.isExportSource());
                    if (utilJAR != null) {
                        this.filesHolder.addFile((org.eclipse.jst.j2ee.commonarchivecore.internal.File)utilJAR);
                    }
                }
                catch (OpenFailureException oe) {
                    String message = ProjectSupportResourceHandler.getString((String)ProjectSupportResourceHandler.UNABLE_TO_LOAD_MODULE_ERROR_, (Object[])new Object[]{uri, this.getComponent().getProject().getName(), oe.getConcatenatedMessages()});
                    Logger.getLogger().logTrace(message);
                }
            }
            ++i;
        }
    }

    protected synchronized ArtifactEdit getArtifactEditForRead() {
        if (this.artifactEdit == null) {
            this.artifactEdit = WebArtifactEdit.getWebArtifactEditForRead(this.vComponent);
        }
        return this.artifactEdit;
    }

    private void addClasspathComponentDependencies(IVirtualComponent referencedComponent) {
        if (this.includeClasspathComponents && referencedComponent instanceof J2EEModuleVirtualComponent) {
            IVirtualReference[] cpRefs = ((J2EEModuleVirtualComponent)referencedComponent).getJavaClasspathReferences();
            int j = 0;
            while (j < cpRefs.length) {
                IVirtualReference ref = cpRefs[j];
                IPath runtimePath = ref.getRuntimePath();
                if (ref.getReferencedComponent() instanceof VirtualArchiveComponent && runtimePath.equals((Object)IClasspathDependencyConstants.RUNTIME_MAPPING_INTO_CONTAINER_PATH)) {
                    VirtualArchiveComponent comp = (VirtualArchiveComponent)ref.getReferencedComponent();
                    File cpEntryFile = comp.getUnderlyingDiskFile();
                    if (!cpEntryFile.exists()) {
                        IFile wbFile = comp.getUnderlyingWorkbenchFile();
                        cpEntryFile = new File(wbFile.getLocation().toOSString());
                    }
                    this.addExternalFile("WEB-INF/lib/" + ref.getArchiveName(), cpEntryFile);
                }
                ++j;
            }
        }
    }
}

