/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.web.operations;

import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class AbstractSupertypesValidator {
    private IDataModel dataModel;
    private String superclass;
    private List interfaces;
    private IJavaProject javaProject;

    public AbstractSupertypesValidator(IDataModel dataModel) {
        this.dataModel = dataModel;
    }

    protected String getSuperclass() {
        if (this.superclass == null) {
            this.superclass = this.dataModel.getStringProperty("NewJavaClassDataModel.SUPERCLASS");
        }
        return this.superclass;
    }

    protected List getInterfaces() {
        if (this.interfaces == null) {
            this.interfaces = (List)this.dataModel.getProperty("NewJavaClassDataModel.INTERFACES");
        }
        return this.interfaces;
    }

    protected IJavaProject getJavaProject() {
        if (this.javaProject == null) {
            this.javaProject = JavaCore.create((IProject)((IProject)this.dataModel.getProperty("NewJavaClassDataModel.PROJECT")));
        }
        return this.javaProject;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean hasSuperclass(String typeName, String superTypeName) {
        try {
            IType type = this.getJavaProject().findType(typeName);
            if (type == null) return false;
            ITypeHierarchy typeHierarchy = type.newTypeHierarchy((IProgressMonitor)new NullProgressMonitor());
            IType[] iTypeArray = typeHierarchy.getAllSuperclasses(type);
            int n = iTypeArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                IType superType = iTypeArray[n2];
                if (superTypeName.equals(superType.getFullyQualifiedName())) {
                    return true;
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            Logger.getLogger().log((Throwable)e);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean hasSuperInterface(String typeName, String superTypeName) {
        try {
            IType type = this.getJavaProject().findType(typeName);
            if (type == null) return false;
            ITypeHierarchy typeHierarchy = type.newTypeHierarchy((IProgressMonitor)new NullProgressMonitor());
            IType[] iTypeArray = typeHierarchy.getAllSuperInterfaces(type);
            int n = iTypeArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                IType superType = iTypeArray[n2];
                if (superTypeName.equals(superType.getFullyQualifiedName())) {
                    return true;
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            Logger.getLogger().log((Throwable)e);
        }
        return false;
    }
}

