/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.web.operations;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jem.util.UIContextDetermination;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.j2ee.common.CommonFactory;
import org.eclipse.jst.j2ee.common.Listener;
import org.eclipse.jst.j2ee.internal.web.operations.NewListenerClassOperation;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.javaee.core.JavaeeFactory;
import org.eclipse.jst.javaee.web.WebApp;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.common.componentcore.internal.operation.IArtifactEditOperationDataModelProperties;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class AddListenerOperation
extends AbstractDataModelOperation
implements IArtifactEditOperationDataModelProperties {
    private IModelProvider provider = ModelProviderManager.getModelProvider((IProject)this.getTargetProject());

    public AddListenerOperation(IDataModel dataModel) {
        super(dataModel);
    }

    public IStatus doExecute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        boolean useExisting = this.model.getBooleanProperty("NewListenerClassDataModel.USE_EXISTING_CLASS");
        String qualifiedClassName = this.model.getStringProperty("NewJavaClassDataModel.CLASS_NAME");
        if (!useExisting) {
            qualifiedClassName = this.createListenerClass();
        }
        if (!this.model.getBooleanProperty("IAnnotationsDataModel.useAnnotations")) {
            this.generateListenerMetaData(this.model, qualifiedClassName);
        }
        return OK_STATUS;
    }

    protected String createListenerClass() {
        NewListenerClassOperation op = new NewListenerClassOperation(this.model);
        try {
            op.execute((IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (Exception e) {
            Logger.getLogger().log((Throwable)e);
        }
        return this.getQualifiedClassName();
    }

    public final String getQualifiedClassName() {
        String packageName = this.model.getStringProperty("NewJavaClassDataModel.JAVA_PACKAGE");
        String className = this.model.getStringProperty("NewJavaClassDataModel.CLASS_NAME");
        if (packageName != null && packageName.trim().length() > 0) {
            return String.valueOf(packageName) + "." + className;
        }
        return className;
    }

    protected void generateListenerMetaData(IDataModel aModel, String qualifiedClassName) {
        this.createListener(qualifiedClassName);
    }

    private Object createListener(String qualifiedClassName) {
        Object modelObject = this.provider.getModelObject();
        if (modelObject instanceof org.eclipse.jst.j2ee.webapplication.WebApp) {
            Listener listener = CommonFactory.eINSTANCE.createListener();
            listener.setListenerClassName(qualifiedClassName);
            org.eclipse.jst.j2ee.webapplication.WebApp webApp = (org.eclipse.jst.j2ee.webapplication.WebApp)modelObject;
            webApp.getListeners().add((Object)listener);
            return listener;
        }
        if (modelObject instanceof WebApp) {
            org.eclipse.jst.javaee.core.Listener listener = JavaeeFactory.eINSTANCE.createListener();
            listener.setListenerClass(qualifiedClassName);
            WebApp webApp = (WebApp)modelObject;
            webApp.getListeners().add(listener);
            return listener;
        }
        return null;
    }

    public IProject getTargetProject() {
        String projectName = this.model.getStringProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME");
        return ProjectUtilities.getProject((String)projectName);
    }

    public IStatus execute(final IProgressMonitor monitor, final IAdaptable info) throws ExecutionException {
        Display display;
        Runnable runnable = null;
        Shell ctx = null;
        if (UIContextDetermination.getCurrentContext() == 101 && (display = Display.getCurrent()) != null) {
            ctx = display.getActiveShell();
        }
        if (this.provider.validateEdit(null, ctx).isOK()) {
            runnable = new Runnable(){

                public void run() {
                    try {
                        AddListenerOperation.this.doExecute(monitor, info);
                    }
                    catch (ExecutionException e) {
                        e.printStackTrace();
                    }
                }
            };
            this.provider.modify(runnable, IModelProvider.FORCESAVE);
        }
        return Status.CANCEL_STATUS;
    }
}

