/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.web.operations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jst.j2ee.internal.web.operations.CreateWebClassTemplateModel;
import org.eclipse.jst.j2ee.internal.web.operations.IFilterMappingItem;
import org.eclipse.jst.j2ee.webapplication.DispatcherType;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateFilterTemplateModel
extends CreateWebClassTemplateModel {
    public static final String QUALIFIED_IO_EXCEPTION = "java.io.IOException";
    public static final String QUALIFIED_SERVLET_EXCEPTION = "javax.servlet.ServletException";
    public static final String QUALIFIED_SERVLET_REQUEST = "javax.servlet.ServletRequest";
    public static final String QUALIFIED_SERVLET_RESPONSE = "javax.servlet.ServletResponse";
    public static final String QUALIFIED_FILTER_CONFIG = "javax.servlet.FilterConfig";
    public static final String QUALIFIED_FILTER_CHAIN = "javax.servlet.FilterChain";
    public static final String INIT = "init";
    public static final String TO_STRING = "toString";
    public static final String DO_FILTER = "doFilter";
    public static final String DESTROY = "destroy";
    public static final int NAME = 0;
    public static final int VALUE = 1;
    public static final int DESCRIPTION = 2;

    public CreateFilterTemplateModel(IDataModel dataModel) {
        super(dataModel);
    }

    @Override
    public Collection<String> getImports() {
        Collection<String> collection = super.getImports();
        if (this.shouldGenInit()) {
            collection.add(QUALIFIED_FILTER_CONFIG);
            collection.add(QUALIFIED_SERVLET_EXCEPTION);
        }
        if (this.shouldGenDoFilter()) {
            collection.add(QUALIFIED_SERVLET_REQUEST);
            collection.add(QUALIFIED_SERVLET_RESPONSE);
            collection.add(QUALIFIED_FILTER_CHAIN);
            collection.add(QUALIFIED_IO_EXCEPTION);
            collection.add(QUALIFIED_SERVLET_EXCEPTION);
        }
        return collection;
    }

    public String getFilterName() {
        return this.getProperty("NewJavaClassDataModel.CLASS_NAME").trim();
    }

    public boolean shouldGenInit() {
        return this.implementImplementedMethod(INIT);
    }

    public boolean shouldGenToString() {
        return this.implementImplementedMethod(TO_STRING);
    }

    public boolean shouldGenDoFilter() {
        return this.implementImplementedMethod(DO_FILTER);
    }

    public boolean shouldGenDestroy() {
        return this.implementImplementedMethod(DESTROY);
    }

    public List getInitParams() {
        return (List)this.dataModel.getProperty("NewFilterClassDataModel.INIT_PARAM");
    }

    public String getInitParam(int index, int type) {
        List params = this.getInitParams();
        if (index < params.size()) {
            String[] stringArray = (String[])params.get(index);
            return stringArray[type];
        }
        return null;
    }

    public List<IFilterMappingItem> getFilterMappings() {
        return (List)this.dataModel.getProperty("NewFilterClassDataModel.FILTER_MAPPINGS");
    }

    public IFilterMappingItem getFilterMapping(int index) {
        List<IFilterMappingItem> mappings = this.getFilterMappings();
        if (index < mappings.size()) {
            return mappings.get(index);
        }
        return null;
    }

    public String getDispatcherList(IFilterMappingItem mapping) {
        ArrayList<String> list = new ArrayList<String>();
        int dispatchers = mapping.getDispatchers();
        if ((dispatchers & 2) > 0) {
            list.add(DispatcherType.REQUEST_LITERAL.getLiteral());
        }
        if ((dispatchers & 4) > 0) {
            list.add(DispatcherType.FORWARD_LITERAL.getLiteral());
        }
        if ((dispatchers & 8) > 0) {
            list.add(DispatcherType.INCLUDE_LITERAL.getLiteral());
        }
        if ((dispatchers & 0x10) > 0) {
            list.add(DispatcherType.ERROR_LITERAL.getLiteral());
        }
        StringBuilder builder = new StringBuilder();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            builder.append((String)iterator.next());
            if (!iterator.hasNext()) continue;
            builder.append(",");
        }
        return builder.toString();
    }

    public String getFilterDescription() {
        return this.dataModel.getStringProperty("NewFilterClassDataModel.DESCRIPTION");
    }

    protected boolean implementImplementedMethod(String methodName) {
        if (this.dataModel.getBooleanProperty("NewJavaClassDataModel.ABSTRACT_METHODS")) {
            if (methodName.equals(INIT)) {
                return this.dataModel.getBooleanProperty("NewFilterClassDataModel.INIT");
            }
            if (methodName.equals(TO_STRING)) {
                return this.dataModel.getBooleanProperty("NewFilterClassDataModel.TO_STRING");
            }
            if (methodName.equals(DO_FILTER)) {
                return this.dataModel.getBooleanProperty("NewFilterClassDataModel.DO_FILTER");
            }
            if (methodName.equals(DESTROY)) {
                return this.dataModel.getBooleanProperty("NewFilterClassDataModel.DESTROY");
            }
        }
        return false;
    }
}

