/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.web.operations;

import java.util.Collection;
import java.util.List;
import org.eclipse.jst.j2ee.internal.web.operations.CreateWebClassTemplateModel;
import org.eclipse.jst.j2ee.internal.web.operations.ServletSupertypesValidator;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateServletTemplateModel
extends CreateWebClassTemplateModel {
    public static final String QUALIFIED_IO_EXCEPTION = "java.io.IOException";
    public static final String QUALIFIED_SERVLET_EXCEPTION = "javax.servlet.ServletException";
    public static final String QUALIFIED_SERVLET_CONFIG = "javax.servlet.ServletConfig";
    public static final String QUALIFIED_SERVLET_REQUEST = "javax.servlet.ServletRequest";
    public static final String QUALIFIED_SERVLET_RESPONSE = "javax.servlet.ServletResponse";
    public static final String QUALIFIED_HTTP_SERVLET_REQUEST = "javax.servlet.http.HttpServletRequest";
    public static final String QUALIFIED_HTTP_SERVLET_RESPONSE = "javax.servlet.http.HttpServletResponse";
    public static final String INIT = "init";
    public static final String DESTROY = "destroy";
    public static final String GET_SERVLET_CONFIG = "getServletConfig";
    public static final String GET_SERVLET_INFO = "getServletInfo";
    public static final String SERVICE = "service";
    public static final String DO_GET = "doGet";
    public static final String DO_POST = "doPost";
    public static final String DO_PUT = "doPut";
    public static final String DO_DELETE = "doDelete";
    public static final String DO_HEAD = "doHead";
    public static final String DO_OPTIONS = "doOptions";
    public static final String DO_TRACE = "doTrace";
    public static final String TO_STRING = "toString";
    public static final int NAME = 0;
    public static final int VALUE = 1;
    public static final int DESCRIPTION = 2;

    public CreateServletTemplateModel(IDataModel dataModel) {
        super(dataModel);
    }

    @Override
    public Collection<String> getImports() {
        Collection<String> collection = super.getImports();
        if (this.shouldGenInit()) {
            collection.add(QUALIFIED_SERVLET_CONFIG);
            collection.add(QUALIFIED_SERVLET_EXCEPTION);
        }
        if (this.shouldGenGetServletConfig()) {
            collection.add(QUALIFIED_SERVLET_CONFIG);
        }
        if (this.shouldGenService()) {
            if (this.isHttpServletSuperclass()) {
                collection.add(QUALIFIED_HTTP_SERVLET_REQUEST);
                collection.add(QUALIFIED_HTTP_SERVLET_RESPONSE);
            } else {
                collection.add(QUALIFIED_SERVLET_REQUEST);
                collection.add(QUALIFIED_SERVLET_RESPONSE);
            }
            collection.add(QUALIFIED_SERVLET_EXCEPTION);
            collection.add(QUALIFIED_IO_EXCEPTION);
        }
        if (this.shouldGenDoGet() || this.shouldGenDoPost() || this.shouldGenDoPut() || this.shouldGenDoDelete() || this.shouldGenDoHead() || this.shouldGenDoOptions() || this.shouldGenDoTrace()) {
            collection.add(QUALIFIED_HTTP_SERVLET_REQUEST);
            collection.add(QUALIFIED_HTTP_SERVLET_RESPONSE);
            collection.add(QUALIFIED_SERVLET_EXCEPTION);
            collection.add(QUALIFIED_IO_EXCEPTION);
        }
        return collection;
    }

    public String getServletName() {
        return this.getProperty("NewServletClassDataModel.DISPLAY_NAME").trim();
    }

    public String getServletClassName() {
        return super.getClassName();
    }

    public boolean shouldGenInit() {
        return this.implementImplementedMethod(INIT);
    }

    public boolean shouldGenDestroy() {
        return this.implementImplementedMethod(DESTROY);
    }

    public boolean shouldGenGetServletConfig() {
        return this.implementImplementedMethod(GET_SERVLET_CONFIG);
    }

    public boolean shouldGenGetServletInfo() {
        return this.implementImplementedMethod(GET_SERVLET_INFO);
    }

    public boolean shouldGenService() {
        return this.implementImplementedMethod(SERVICE);
    }

    public boolean shouldGenDoGet() {
        return this.implementImplementedMethod(DO_GET);
    }

    public boolean shouldGenDoPost() {
        return this.implementImplementedMethod(DO_POST);
    }

    public boolean shouldGenDoPut() {
        return this.implementImplementedMethod(DO_PUT);
    }

    public boolean shouldGenDoDelete() {
        return this.implementImplementedMethod(DO_DELETE);
    }

    public boolean shouldGenDoHead() {
        return this.implementImplementedMethod(DO_HEAD);
    }

    public boolean shouldGenDoOptions() {
        return this.implementImplementedMethod(DO_OPTIONS);
    }

    public boolean shouldGenDoTrace() {
        return this.implementImplementedMethod(DO_TRACE);
    }

    public boolean shouldGenToString() {
        return this.implementImplementedMethod(TO_STRING);
    }

    public boolean isGenericServletSuperclass() {
        ServletSupertypesValidator validator = new ServletSupertypesValidator(this.dataModel);
        return validator.isGenericServletSuperclass();
    }

    public boolean isHttpServletSuperclass() {
        ServletSupertypesValidator validator = new ServletSupertypesValidator(this.dataModel);
        return validator.isHttpServletSuperclass();
    }

    public List getInitParams() {
        return (List)this.dataModel.getProperty("NewServletClassDataModel.INIT_PARAM");
    }

    public String getInitParam(int index, int type) {
        List params = this.getInitParams();
        if (index < params.size()) {
            String[] stringArray = (String[])params.get(index);
            return stringArray[type];
        }
        return null;
    }

    public List getServletMappings() {
        return (List)this.dataModel.getProperty("NewServletClassDataModel.URL_MAPPINGS");
    }

    public String getServletMapping(int index) {
        List mappings = this.getServletMappings();
        if (index < mappings.size()) {
            String[] map = (String[])mappings.get(index);
            return map[0];
        }
        return null;
    }

    public String getServletDescription() {
        return this.dataModel.getStringProperty("NewServletClassDataModel.DESCRIPTION");
    }

    protected boolean implementImplementedMethod(String methodName) {
        if (this.dataModel.getBooleanProperty("NewJavaClassDataModel.ABSTRACT_METHODS")) {
            if (methodName.equals(INIT)) {
                return this.dataModel.getBooleanProperty("NewServletClassDataModel.INIT");
            }
            if (methodName.equals(DESTROY)) {
                return this.dataModel.getBooleanProperty("NewServletClassDataModel.DESTROY");
            }
            if (methodName.equals(GET_SERVLET_CONFIG)) {
                return this.dataModel.getBooleanProperty("NewServletClassDataModel.GET_SERVLET_CONFIG");
            }
            if (methodName.equals(GET_SERVLET_INFO)) {
                return this.dataModel.getBooleanProperty("NewServletClassDataModel.GET_SERVLET_INFO");
            }
            if (methodName.equals(SERVICE)) {
                return this.dataModel.getBooleanProperty("NewServletClassDataModel.SERVICE");
            }
            if (methodName.equals(DO_GET)) {
                return this.dataModel.getBooleanProperty("NewServletClassDataModel.DO_GET");
            }
            if (methodName.equals(DO_POST)) {
                return this.dataModel.getBooleanProperty("NewServletClassDataModel.DO_POST");
            }
            if (methodName.equals(DO_PUT)) {
                return this.dataModel.getBooleanProperty("NewServletClassDataModel.DO_PUT");
            }
            if (methodName.equals(DO_DELETE)) {
                return this.dataModel.getBooleanProperty("NewServletClassDataModel.DO_DELETE");
            }
            if (methodName.equals(DO_HEAD)) {
                return this.dataModel.getBooleanProperty("NewServletClassDataModel.DO_HEAD");
            }
            if (methodName.equals(DO_OPTIONS)) {
                return this.dataModel.getBooleanProperty("NewServletClassDataModel.DO_OPTIONS");
            }
            if (methodName.equals(DO_TRACE)) {
                return this.dataModel.getBooleanProperty("NewServletClassDataModel.DO_TRACE");
            }
        }
        return false;
    }
}

