/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.web.operations;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jst.j2ee.internal.common.J2EEVersionUtil;
import org.eclipse.jst.j2ee.internal.common.operations.NewJavaClassDataModelProvider;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.j2ee.internal.web.operations.AddFilterOperation;
import org.eclipse.jst.j2ee.internal.web.operations.FilterMappingItem;
import org.eclipse.jst.j2ee.internal.web.operations.IFilterMappingItem;
import org.eclipse.jst.j2ee.internal.web.operations.INewFilterClassDataModelProperties;
import org.eclipse.jst.j2ee.internal.web.operations.WebMessages;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.j2ee.web.validation.UrlPattern;
import org.eclipse.jst.javaee.web.Filter;
import org.eclipse.jst.javaee.web.WebApp;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;
import org.eclipse.wst.common.frameworks.internal.plugin.WTPCommonPlugin;

public class NewFilterClassDataModelProvider
extends NewJavaClassDataModelProvider
implements INewFilterClassDataModelProperties {
    private static final String[] FILTER_INTERFACES = new String[]{"javax.servlet.Filter"};
    private static final String NON_ANNOTATED_TEMPLATE_DEFAULT = "filterNonAnnotated.javajet";
    private List interfaceList;
    private String classNameCache;
    private String existingClassNameCache;
    private static boolean useAnnotations = false;

    public IDataModelOperation getDefaultOperation() {
        return new AddFilterOperation(this.getDataModel());
    }

    public boolean isPropertyEnabled(String propertyName) {
        if ("IAnnotationsDataModel.useAnnotations".equals(propertyName)) {
            return !this.getBooleanProperty("NewFilterClassDataModel.USE_EXISTING_CLASS") && this.isAnnotationsSupported();
        }
        return super.isPropertyEnabled(propertyName);
    }

    public Set getPropertyNames() {
        Set propertyNames = super.getPropertyNames();
        propertyNames.add("NewFilterClassDataModel.INIT");
        propertyNames.add("NewFilterClassDataModel.DESTROY");
        propertyNames.add("NewFilterClassDataModel.TO_STRING");
        propertyNames.add("NewFilterClassDataModel.DO_FILTER");
        propertyNames.add("NewFilterClassDataModel.INIT_PARAM");
        propertyNames.add("NewFilterClassDataModel.FILTER_MAPPINGS");
        propertyNames.add("IAnnotationsDataModel.useAnnotations");
        propertyNames.add("NewFilterClassDataModel.DISPLAY_NAME");
        propertyNames.add("NewFilterClassDataModel.DESCRIPTION");
        propertyNames.add("NewFilterClassDataModel.USE_EXISTING_CLASS");
        return propertyNames;
    }

    public Object getDefaultProperty(String propertyName) {
        if (propertyName.equals("NewFilterClassDataModel.DISPLAY_NAME")) {
            String className = this.getStringProperty("NewJavaClassDataModel.CLASS_NAME");
            int index = className.lastIndexOf(".");
            className = className.substring(index + 1);
            return className;
        }
        if (propertyName.equals("IAnnotationsDataModel.useAnnotations")) {
            return NewFilterClassDataModelProvider.shouldDefaultAnnotations();
        }
        if (propertyName.equals("NewFilterClassDataModel.DESTROY")) {
            return Boolean.TRUE;
        }
        if (propertyName.equals("NewFilterClassDataModel.DO_FILTER")) {
            return Boolean.TRUE;
        }
        if (propertyName.equals("NewFilterClassDataModel.INIT")) {
            return Boolean.TRUE;
        }
        if (propertyName.equals("NewFilterClassDataModel.FILTER_MAPPINGS")) {
            return this.getDefaultFilterMapping();
        }
        if (propertyName.equals("NewJavaClassDataModel.INTERFACES")) {
            return this.getFilterInterfaces();
        }
        if (propertyName.equals("NewJavaClassDataModel.SUPERCLASS")) {
            return "";
        }
        if (propertyName.equals("NewFilterClassDataModel.USE_EXISTING_CLASS")) {
            return Boolean.FALSE;
        }
        return super.getDefaultProperty(propertyName);
    }

    private Object getDefaultFilterMapping() {
        ArrayList<FilterMappingItem> filterMappings = null;
        String text = (String)this.getProperty("NewFilterClassDataModel.DISPLAY_NAME");
        if (text != null) {
            filterMappings = new ArrayList<FilterMappingItem>();
            filterMappings.add(new FilterMappingItem(0, "/" + text));
        }
        return filterMappings;
    }

    public boolean propertySet(String propertyName, Object propertyValue) {
        if (propertyName.equals("IAnnotationsDataModel.useAnnotations")) {
            useAnnotations = (Boolean)propertyValue;
            if (useAnnotations && !this.isAnnotationsSupported()) {
                return true;
            }
            this.getDataModel().notifyPropertyChange("IAnnotationsDataModel.useAnnotations", 3);
        }
        if (propertyName.equals("NewJavaClassDataModel.SOURCE_FOLDER")) {
            String sourceFolder = (String)propertyValue;
            int index = sourceFolder.indexOf(File.separator);
            String projectName = sourceFolder;
            if (index == 0) {
                projectName = sourceFolder.substring(1);
            }
            if ((index = projectName.indexOf(File.separator)) != -1) {
                projectName = projectName.substring(0, index);
                this.setProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME", projectName);
            }
        }
        boolean result = super.propertySet(propertyName, propertyValue);
        if (propertyName.equals("NewJavaClassDataModel.CLASS_NAME") && !this.getDataModel().isPropertySet("NewFilterClassDataModel.DISPLAY_NAME")) {
            this.getDataModel().notifyPropertyChange("NewFilterClassDataModel.DISPLAY_NAME", 2);
        }
        if (propertyName.equals("IArtifactEditOperationDataModelProperties.COMPONENT_NAME")) {
            this.getDataModel().notifyPropertyChange("IAnnotationsDataModel.useAnnotations", 3);
        }
        if (this.getBooleanProperty("IAnnotationsDataModel.useAnnotations") && !this.isAnnotationsSupported()) {
            this.setBooleanProperty("IAnnotationsDataModel.useAnnotations", false);
        }
        if (propertyName.equals("NewFilterClassDataModel.USE_EXISTING_CLASS")) {
            this.getDataModel().notifyPropertyChange("IAnnotationsDataModel.useAnnotations", 3);
            if (((Boolean)propertyValue).booleanValue()) {
                this.classNameCache = this.getStringProperty("NewJavaClassDataModel.CLASS_NAME");
                this.setProperty("NewJavaClassDataModel.CLASS_NAME", this.existingClassNameCache);
            } else {
                this.existingClassNameCache = this.getStringProperty("NewJavaClassDataModel.CLASS_NAME");
                this.setProperty("NewJavaClassDataModel.CLASS_NAME", this.classNameCache);
            }
        }
        return result;
    }

    protected boolean isAnnotationsSupported() {
        if (!this.getDataModel().isPropertySet("IArtifactEditOperationDataModelProperties.PROJECT_NAME")) {
            return true;
        }
        if (this.getStringProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME").equals("")) {
            return true;
        }
        IProject project = ProjectUtilities.getProject((String)this.getStringProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME"));
        String moduleName = this.getStringProperty("IArtifactEditOperationDataModelProperties.COMPONENT_NAME");
        if (project == null || moduleName == null || moduleName.equals("")) {
            return true;
        }
        int j2eeVersion = J2EEVersionUtil.convertVersionStringToInt((String)J2EEProjectUtilities.getJ2EEProjectVersion((IProject)project));
        return j2eeVersion > 12;
    }

    public IStatus validate(String propertyName) {
        IStatus result = Status.OK_STATUS;
        if (propertyName.equals("NewJavaClassDataModel.SUPERCLASS") && "".equals(this.getStringProperty(propertyName))) {
            return WTPCommonPlugin.OK_STATUS;
        }
        if (propertyName.equals("NewFilterClassDataModel.INIT_PARAM")) {
            return this.validateInitParamList((List)this.getProperty(propertyName));
        }
        if (propertyName.equals("NewFilterClassDataModel.FILTER_MAPPINGS")) {
            return this.validateFilterMappingList((List)this.getProperty("NewFilterClassDataModel.FILTER_MAPPINGS"));
        }
        if (propertyName.equals("NewFilterClassDataModel.DISPLAY_NAME")) {
            return this.validateDisplayName(this.getStringProperty(propertyName));
        }
        if (propertyName.equals("NewJavaClassDataModel.CLASS_NAME")) {
            if (this.getStringProperty(propertyName).length() != 0 && this.getBooleanProperty("NewFilterClassDataModel.USE_EXISTING_CLASS")) {
                return WTPCommonPlugin.OK_STATUS;
            }
            result = super.validateJavaClassName(this.getStringProperty(propertyName));
            if (result.isOK() && (result = this.validateJavaClassName(this.getStringProperty(propertyName))).isOK() && !this.getBooleanProperty("NewFilterClassDataModel.USE_EXISTING_CLASS")) {
                result = this.canCreateTypeInClasspath(this.getStringProperty("NewJavaClassDataModel.CLASS_NAME"));
            }
            return result;
        }
        return super.validate(propertyName);
    }

    private IStatus validateInitParamList(List prop) {
        boolean dup;
        if (prop != null && !prop.isEmpty() && (dup = this.hasDuplicatesInStringArrayList(prop))) {
            String msg = WebMessages.ERR_DUPLICATED_INIT_PARAMETER;
            return WTPCommonPlugin.createErrorStatus((String)msg);
        }
        return WTPCommonPlugin.OK_STATUS;
    }

    private IStatus validateFilterMappingList(List prop) {
        if (prop != null && !prop.isEmpty()) {
            boolean dup = this.hasDuplicatesInStringArrayList(prop);
            if (dup) {
                String msg = WebMessages.ERR_DUPLICATED_URL_MAPPING;
                return WTPCommonPlugin.createErrorStatus((String)msg);
            }
            String isValidValue = this.validateValue(prop);
            if (isValidValue != null && isValidValue.length() > 0) {
                NLS.bind((String)WebMessages.ERR_URL_PATTERN_INVALID, (Object)isValidValue);
                String resourceString = WebMessages.getResourceString(WebMessages.ERR_URL_PATTERN_INVALID, new String[]{isValidValue});
                return WTPCommonPlugin.createErrorStatus((String)resourceString);
            }
        } else {
            String msg = WebMessages.ERR_FILTER_MAPPING_EMPTY;
            return WTPCommonPlugin.createErrorStatus((String)msg);
        }
        return WTPCommonPlugin.OK_STATUS;
    }

    private String validateValue(List prop) {
        if (prop == null) {
            return "";
        }
        int size = prop.size();
        int i = 0;
        while (i < size) {
            IFilterMappingItem filterMappingValue = (IFilterMappingItem)prop.get(i);
            if (filterMappingValue.isUrlPatternType() && !UrlPattern.isValid(filterMappingValue.getName())) {
                return filterMappingValue.getName();
            }
            ++i;
        }
        return "";
    }

    private boolean hasDuplicatesInStringArrayList(List input) {
        if (input == null) {
            return false;
        }
        int n = input.size();
        boolean dup = false;
        int i = 0;
        while (i < n) {
            int j;
            Object object = input.get(i);
            if (object instanceof IFilterMappingItem) {
                IFilterMappingItem item = (IFilterMappingItem)object;
                j = i + 1;
                while (j < n) {
                    IFilterMappingItem item2 = (IFilterMappingItem)input.get(j);
                    if (item.getName().equals(item2.getName()) && item.getMappingType() == item2.getMappingType()) {
                        dup = true;
                        break;
                    }
                    ++j;
                }
                if (dup) {
                    break;
                }
            } else {
                String[] sArray1 = (String[])object;
                j = i + 1;
                while (j < n) {
                    String[] sArray2 = (String[])input.get(j);
                    if (this.isTwoStringArraysEqual(sArray1, sArray2)) {
                        dup = true;
                        break;
                    }
                    ++j;
                }
                if (dup) break;
            }
            ++i;
        }
        return dup;
    }

    private boolean isTwoStringArraysEqual(String[] sArray1, String[] sArray2) {
        if (sArray1 == null || sArray2 == null) {
            return false;
        }
        int n1 = sArray1.length;
        int n2 = sArray1.length;
        if (n1 == 0 || n2 == 0) {
            return false;
        }
        if (n1 != n2) {
            return false;
        }
        return sArray1[0].equals(sArray2[0]);
    }

    private List getFilterInterfaces() {
        if (this.interfaceList == null) {
            this.interfaceList = new ArrayList();
            int i = 0;
            while (i < FILTER_INTERFACES.length) {
                this.interfaceList.add(FILTER_INTERFACES[i]);
                ++i;
            }
        }
        return this.interfaceList;
    }

    private IStatus validateDisplayName(String prop) {
        if (prop == null || prop.trim().length() == 0) {
            String msg = WebMessages.ERR_DISPLAY_NAME_EMPTY;
            return WTPCommonPlugin.createErrorStatus((String)msg);
        }
        if (this.getTargetProject() == null || this.getTargetComponent() == null) {
            return WTPCommonPlugin.OK_STATUS;
        }
        IModelProvider provider = ModelProviderManager.getModelProvider((IProject)this.getTargetProject());
        Object mObj = provider.getModelObject();
        if (mObj instanceof org.eclipse.jst.j2ee.webapplication.WebApp) {
            org.eclipse.jst.j2ee.webapplication.WebApp webApp = (org.eclipse.jst.j2ee.webapplication.WebApp)mObj;
            EList filters = webApp.getFilters();
            boolean exists = false;
            if (filters != null && !filters.isEmpty()) {
                int i = 0;
                while (i < filters.size()) {
                    String name = ((org.eclipse.jst.j2ee.webapplication.Filter)filters.get(i)).getName();
                    if (prop.equals(name)) {
                        exists = true;
                    }
                    ++i;
                }
            }
            if (exists) {
                String msg = WebMessages.getResourceString(WebMessages.ERR_SERVLET_DISPLAY_NAME_EXIST, new String[]{prop});
                return WTPCommonPlugin.createErrorStatus((String)msg);
            }
        } else if (mObj instanceof WebApp) {
            WebApp webApp = (WebApp)mObj;
            List filters = webApp.getFilters();
            boolean exists = false;
            if (filters != null && !filters.isEmpty()) {
                int i = 0;
                while (i < filters.size()) {
                    String name = ((Filter)filters.get(i)).getFilterName();
                    if (prop.equals(name)) {
                        exists = true;
                    }
                    ++i;
                }
            }
            if (exists) {
                String msg = WebMessages.getResourceString(WebMessages.ERR_SERVLET_DISPLAY_NAME_EXIST, new String[]{prop});
                return WTPCommonPlugin.createErrorStatus((String)msg);
            }
        }
        return WTPCommonPlugin.OK_STATUS;
    }

    private static Boolean shouldDefaultAnnotations() {
        if (useAnnotations) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }
}

