/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.web.operations;

import java.io.File;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jst.j2ee.internal.common.J2EEVersionUtil;
import org.eclipse.jst.j2ee.internal.common.operations.NewJavaClassDataModelProvider;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.j2ee.internal.web.operations.AddListenerOperation;
import org.eclipse.jst.j2ee.internal.web.operations.INewListenerClassDataModelProperties;
import org.eclipse.jst.j2ee.internal.web.operations.WebMessages;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;
import org.eclipse.wst.common.frameworks.internal.plugin.WTPCommonPlugin;

public class NewListenerClassDataModelProvider
extends NewJavaClassDataModelProvider
implements INewListenerClassDataModelProperties {
    public static final String SERVLET_CONTEXT_LISTENER = "javax.servlet.ServletContextListener";
    public static final String SERVLET_CONTEXT_ATTRIBUTE_LISTENER = "javax.servlet.ServletContextAttributeListener";
    public static final String HTTP_SESSION_LISTENER = "javax.servlet.http.HttpSessionListener";
    public static final String HTTP_SESSION_ATTRIBUTE_LISTENER = "javax.servlet.http.HttpSessionAttributeListener";
    public static final String HTTP_SESSION_ACTIVATION_LISTENER = "javax.servlet.http.HttpSessionActivationListener";
    public static final String HTTP_SESSION_BINDING_LISTENER = "javax.servlet.http.HttpSessionBindingListener";
    public static final String SERVLET_REQUEST_LISTENER = "javax.servlet.ServletRequestListener";
    public static final String SERVLET_REQUEST_ATTRIBUTE_LISTENER = "javax.servlet.ServletRequestAttributeListener";
    public static final String[] LISTENER_INTERFACES = new String[]{"javax.servlet.ServletContextListener", "javax.servlet.ServletContextAttributeListener", "javax.servlet.http.HttpSessionListener", "javax.servlet.http.HttpSessionAttributeListener", "javax.servlet.http.HttpSessionActivationListener", "javax.servlet.http.HttpSessionBindingListener", "javax.servlet.ServletRequestListener", "javax.servlet.ServletRequestAttributeListener"};
    private static final String LISTENER_SUPERCLASS = "";
    private List interfaceList;
    private String classNameCache;
    private String existingClassNameCache;
    private static boolean useAnnotations = false;

    public IDataModelOperation getDefaultOperation() {
        return new AddListenerOperation(this.getDataModel());
    }

    public boolean isPropertyEnabled(String propertyName) {
        return super.isPropertyEnabled(propertyName);
    }

    public Set getPropertyNames() {
        Set propertyNames = super.getPropertyNames();
        propertyNames.add("IAnnotationsDataModel.useAnnotations");
        propertyNames.add("NewListenerClassDataModel.USE_EXISTING_CLASS");
        return propertyNames;
    }

    public Object getDefaultProperty(String propertyName) {
        if (propertyName.equals("IAnnotationsDataModel.useAnnotations")) {
            return NewListenerClassDataModelProvider.shouldDefaultAnnotations();
        }
        if (propertyName.equals("NewJavaClassDataModel.SUPERCLASS")) {
            return LISTENER_SUPERCLASS;
        }
        if (propertyName.equals("NewListenerClassDataModel.USE_EXISTING_CLASS")) {
            return Boolean.FALSE;
        }
        return super.getDefaultProperty(propertyName);
    }

    public boolean propertySet(String propertyName, Object propertyValue) {
        if (propertyName.equals("IAnnotationsDataModel.useAnnotations")) {
            useAnnotations = (Boolean)propertyValue;
            if (useAnnotations && !this.isAnnotationsSupported()) {
                return true;
            }
            this.getDataModel().notifyPropertyChange("IAnnotationsDataModel.useAnnotations", 3);
        }
        if (propertyName.equals("NewJavaClassDataModel.SOURCE_FOLDER")) {
            String sourceFolder = (String)propertyValue;
            int index = sourceFolder.indexOf(File.separator);
            String projectName = sourceFolder;
            if (index == 0) {
                projectName = sourceFolder.substring(1);
            }
            if ((index = projectName.indexOf(File.separator)) != -1) {
                projectName = projectName.substring(0, index);
                this.setProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME", projectName);
            }
        }
        boolean result = super.propertySet(propertyName, propertyValue);
        if (propertyName.equals("IArtifactEditOperationDataModelProperties.COMPONENT_NAME")) {
            this.getDataModel().notifyPropertyChange("IAnnotationsDataModel.useAnnotations", 3);
        }
        if (this.getBooleanProperty("IAnnotationsDataModel.useAnnotations") && !this.isAnnotationsSupported()) {
            this.setBooleanProperty("IAnnotationsDataModel.useAnnotations", false);
        }
        if (propertyName.equals("NewListenerClassDataModel.USE_EXISTING_CLASS")) {
            this.getDataModel().notifyPropertyChange("IAnnotationsDataModel.useAnnotations", 3);
            if (((Boolean)propertyValue).booleanValue()) {
                this.classNameCache = this.getStringProperty("NewJavaClassDataModel.CLASS_NAME");
                this.setProperty("NewJavaClassDataModel.CLASS_NAME", this.existingClassNameCache);
            } else {
                this.existingClassNameCache = this.getStringProperty("NewJavaClassDataModel.CLASS_NAME");
                this.setProperty("NewJavaClassDataModel.CLASS_NAME", this.classNameCache);
            }
        }
        return result;
    }

    protected boolean isAnnotationsSupported() {
        if (!this.getDataModel().isPropertySet("IArtifactEditOperationDataModelProperties.PROJECT_NAME")) {
            return true;
        }
        if (this.getStringProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME").equals(LISTENER_SUPERCLASS)) {
            return true;
        }
        IProject project = ProjectUtilities.getProject((String)this.getStringProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME"));
        String moduleName = this.getStringProperty("IArtifactEditOperationDataModelProperties.COMPONENT_NAME");
        if (project == null || moduleName == null || moduleName.equals(LISTENER_SUPERCLASS)) {
            return true;
        }
        int j2eeVersion = J2EEVersionUtil.convertVersionStringToInt((String)J2EEProjectUtilities.getJ2EEProjectVersion((IProject)project));
        return j2eeVersion > 12;
    }

    public IStatus validate(String propertyName) {
        IStatus result = Status.OK_STATUS;
        if (propertyName.equals("NewJavaClassDataModel.SUPERCLASS") && this.getStringProperty(propertyName).equals(LISTENER_SUPERCLASS)) {
            return WTPCommonPlugin.OK_STATUS;
        }
        if (propertyName.equals("NewJavaClassDataModel.CLASS_NAME")) {
            if (this.getStringProperty(propertyName).length() != 0 && this.getBooleanProperty("NewListenerClassDataModel.USE_EXISTING_CLASS")) {
                return WTPCommonPlugin.OK_STATUS;
            }
            result = super.validateJavaClassName(this.getStringProperty(propertyName));
            if (result.isOK() && (result = this.validateJavaClassName(this.getStringProperty(propertyName))).isOK() && !this.getBooleanProperty("NewListenerClassDataModel.USE_EXISTING_CLASS")) {
                result = this.canCreateTypeInClasspath(this.getStringProperty("NewJavaClassDataModel.CLASS_NAME"));
            }
            return result;
        }
        if (propertyName.equals("NewJavaClassDataModel.INTERFACES")) {
            return this.validateListeners();
        }
        return super.validate(propertyName);
    }

    private IStatus validateListeners() {
        boolean atLeastOneSelected = false;
        Object value = this.model.getProperty("NewJavaClassDataModel.INTERFACES");
        if (value != null && value instanceof List) {
            List interfaces = (List)value;
            String[] stringArray = LISTENER_INTERFACES;
            int n = LISTENER_INTERFACES.length;
            int n2 = 0;
            while (n2 < n) {
                String iface = stringArray[n2];
                if (interfaces.contains(iface)) {
                    atLeastOneSelected = true;
                    break;
                }
                ++n2;
            }
        }
        if (atLeastOneSelected) {
            return WTPCommonPlugin.OK_STATUS;
        }
        String msg = WebMessages.ERR_NO_LISTENER_SELECTED;
        return WTPCommonPlugin.createErrorStatus((String)msg);
    }

    private boolean hasDuplicatesInStringArrayList(List input) {
        if (input == null) {
            return false;
        }
        int n = input.size();
        boolean dup = false;
        int i = 0;
        while (i < n) {
            String[] sArray1 = (String[])input.get(i);
            int j = i + 1;
            while (j < n) {
                String[] sArray2 = (String[])input.get(j);
                if (this.isTwoStringArraysEqual(sArray1, sArray2)) {
                    dup = true;
                    break;
                }
                ++j;
            }
            if (dup) break;
            ++i;
        }
        return dup;
    }

    private boolean isTwoStringArraysEqual(String[] sArray1, String[] sArray2) {
        if (sArray1 == null || sArray2 == null) {
            return false;
        }
        int n1 = sArray1.length;
        int n2 = sArray1.length;
        if (n1 == 0 || n2 == 0) {
            return false;
        }
        if (n1 != n2) {
            return false;
        }
        return sArray1[0].equals(sArray2[0]);
    }

    private static Boolean shouldDefaultAnnotations() {
        if (useAnnotations) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }
}

