/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.web.operations;

import org.eclipse.jst.j2ee.internal.web.operations.AbstractSupertypesValidator;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class ServletSupertypesValidator
extends AbstractSupertypesValidator {
    public static final String HTTP_SERVLET_CLASS_NAME = "javax.servlet.http.HttpServlet";
    public static final String GENERIC_SERVLET_CLASS_NAME = "javax.servlet.GenericServlet";
    public static final String SERVLET_INTERFACE_NAME = "javax.servlet.Servlet";

    public ServletSupertypesValidator(IDataModel dataModel) {
        super(dataModel);
    }

    public boolean isHttpServletSuperclass() {
        if (HTTP_SERVLET_CLASS_NAME.equals(this.getSuperclass())) {
            return true;
        }
        return this.hasSuperclass(this.getSuperclass(), HTTP_SERVLET_CLASS_NAME);
    }

    public boolean isGenericServletSuperclass() {
        if (HTTP_SERVLET_CLASS_NAME.equals(this.getSuperclass())) {
            return true;
        }
        if (GENERIC_SERVLET_CLASS_NAME.equals(this.getSuperclass())) {
            return true;
        }
        return this.hasSuperclass(this.getSuperclass(), GENERIC_SERVLET_CLASS_NAME);
    }

    public boolean isServletSuperclass() {
        if (HTTP_SERVLET_CLASS_NAME.equals(this.getSuperclass())) {
            return true;
        }
        if (GENERIC_SERVLET_CLASS_NAME.equals(this.getSuperclass())) {
            return true;
        }
        if (this.getInterfaces().contains(SERVLET_INTERFACE_NAME)) {
            return true;
        }
        if (this.hasSuperInterface(this.getSuperclass(), SERVLET_INTERFACE_NAME)) {
            return true;
        }
        for (Object iface : this.getInterfaces()) {
            if (!this.hasSuperInterface((String)iface, SERVLET_INTERFACE_NAME)) continue;
            return true;
        }
        return false;
    }
}

