/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.web.operations;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jst.j2ee.internal.web.operations.Constructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceConstructor
implements Constructor {
    private MethodDeclaration method;

    public SourceConstructor(MethodDeclaration method) {
        this.method = method;
    }

    @Override
    public boolean isParameterless() {
        return this.method.parameters().size() == 0;
    }

    @Override
    public boolean isPublic() {
        int modifiers = this.method.getModifiers();
        return Modifier.isPublic((int)modifiers);
    }

    @Override
    public boolean isProtected() {
        int modifiers = this.method.getModifiers();
        return Modifier.isProtected((int)modifiers);
    }

    @Override
    public String getParamsForCall() {
        return this.getParams(false, true);
    }

    @Override
    public String getParamsForDeclaration() {
        return this.getParams(true, true);
    }

    @Override
    public String getParamsForJavadoc() {
        return this.getParams(true, false);
    }

    @Override
    public List<String> getNonPrimitveParameterTypes() {
        ArrayList<String> result = new ArrayList<String>();
        List parameters = this.method.parameters();
        for (SingleVariableDeclaration parameter : parameters) {
            ITypeBinding binding;
            Type type = parameter.getType();
            if (type.isPrimitiveType() || (binding = type.resolveBinding()) == null) continue;
            result.add(binding.getQualifiedName());
        }
        return result;
    }

    private String getParams(boolean types, boolean names) {
        StringBuilder result = new StringBuilder();
        Iterator iterator = this.method.parameters().iterator();
        while (iterator.hasNext()) {
            SingleVariableDeclaration parameter = (SingleVariableDeclaration)iterator.next();
            if (types) {
                result.append(parameter.getType());
            }
            if (types && names) {
                result.append(" ");
            }
            if (names) {
                result.append(parameter.getName());
            }
            if (!iterator.hasNext()) continue;
            result.append(", ");
        }
        return result.toString();
    }
}

