/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.web.project.facet;

import com.ibm.icu.util.StringTokenizer;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jst.common.frameworks.CommonFrameworksPlugin;
import org.eclipse.jst.common.project.facet.JavaFacetUtils;
import org.eclipse.jst.j2ee.internal.common.J2EEVersionUtil;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.jst.j2ee.internal.project.ProjectSupportResourceHandler;
import org.eclipse.jst.j2ee.project.facet.J2EEModuleFacetInstallDataModelProvider;
import org.eclipse.jst.j2ee.web.project.facet.IWebFacetInstallDataModelProperties;
import org.eclipse.jst.j2ee.web.project.facet.WebFacetUtils;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectWorkingCopy;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.project.facet.ProductManager;

public class WebFacetInstallDataModelProvider
extends J2EEModuleFacetInstallDataModelProvider
implements IWebFacetInstallDataModelProperties {
    public Set getPropertyNames() {
        Set names = super.getPropertyNames();
        names.add("IWebFacetInstallDataModelProperties.CONTEXT_ROOT");
        names.add("IWebFacetInstallDataModelProperties.SOURCE_FOLDER");
        return names;
    }

    public Object getDefaultProperty(String propertyName) {
        if (propertyName.equals("IJ2EEFacetInstallDataModelProperties.CONFIG_FOLDER")) {
            return J2EEPlugin.getDefault().getJ2EEPreferences().getString("webContent");
        }
        if (propertyName.equals("IWebFacetInstallDataModelProperties.SOURCE_FOLDER")) {
            return CommonFrameworksPlugin.getDefault().getPluginPreferences().getString("defaultSource");
        }
        if (propertyName.equals("IWebFacetInstallDataModelProperties.CONTEXT_ROOT")) {
            return this.getStringProperty("IFacetDataModelProperties.FACET_PROJECT_NAME").replace(' ', '_');
        }
        if (propertyName.equals("IFacetDataModelProperties.FACET_ID")) {
            return "jst.web";
        }
        if (propertyName.equals("IJ2EEModuleFacetInstallDataModelProperties.MODULE_URI")) {
            String projectName = this.model.getStringProperty("IFacetDataModelProperties.FACET_PROJECT_NAME").replace(' ', '_');
            return String.valueOf(projectName) + ".war";
        }
        if (propertyName.equals("IJ2EEFacetInstallDataModelProperties.GENERATE_DD")) {
            IProjectFacetVersion facetVersion = (IProjectFacetVersion)this.getProperty("IFacetDataModelPropeties.FACET_VERSION");
            if (facetVersion == WebFacetUtils.WEB_25) {
                return J2EEPlugin.getDefault().getJ2EEPreferences().getBoolean("dynamic_web_generate_dd");
            }
            return Boolean.TRUE;
        }
        return super.getDefaultProperty(propertyName);
    }

    public boolean propertySet(String propertyName, Object propertyValue) {
        if ("IJ2EEFacetInstallDataModelProperties.ADD_TO_EAR".equals(propertyName)) {
            this.model.notifyPropertyChange("IWebFacetInstallDataModelProperties.CONTEXT_ROOT", 3);
        } else if ("IFacetDataModelProperties.FACET_PROJECT_NAME".equals(propertyName)) {
            this.model.notifyPropertyChange("IWebFacetInstallDataModelProperties.CONTEXT_ROOT", 4);
        } else {
            if (propertyName.equals("IJ2EEFacetInstallDataModelProperties.CONFIG_FOLDER")) {
                IDataModel javaModel;
                if (ProductManager.shouldUseSingleRootStructure() && (javaModel = this.findJavaFacetInstallDataModel()) != null) {
                    javaModel.setProperty("IJavaFacetInstallDataModelProperties.DEFAULT_OUTPUT_FOLDER_NAME", (Object)(propertyValue + "/" + "WEB-INF/classes"));
                }
                return true;
            }
            if (propertyName.equals("IWebFacetInstallDataModelProperties.SOURCE_FOLDER")) {
                IDataModel javaModel = this.findJavaFacetInstallDataModel();
                if (javaModel != null) {
                    javaModel.setProperty("IJavaFacetInstallDataModelProperties.SOURCE_FOLDER_NAME", propertyValue);
                }
            } else if (propertyName.equals("IFacetDataModelPropeties.FACET_VERSION")) {
                if (propertyValue == WebFacetUtils.WEB_25) {
                    this.setProperty("IJ2EEFacetInstallDataModelProperties.GENERATE_DD", J2EEPlugin.getDefault().getJ2EEPreferences().getBoolean("dynamic_web_generate_dd"));
                } else {
                    this.setProperty("IJ2EEFacetInstallDataModelProperties.GENERATE_DD", Boolean.TRUE);
                }
            }
        }
        return super.propertySet(propertyName, propertyValue);
    }

    private IDataModel findJavaFacetInstallDataModel() {
        IFacetedProjectWorkingCopy fpjwc = (IFacetedProjectWorkingCopy)this.model.getProperty("IFacetDataModelProperties.FACETED_PROJECT_WORKING_COPY");
        IFacetedProject.Action javaInstallAction = fpjwc.getProjectFacetAction(JavaFacetUtils.JAVA_FACET);
        return (IDataModel)javaInstallAction.getConfig();
    }

    public boolean isPropertyEnabled(String propertyName) {
        return super.isPropertyEnabled(propertyName);
    }

    protected int convertFacetVersionToJ2EEVersion(IProjectFacetVersion version) {
        return J2EEVersionUtil.convertWebVersionStringToJ2EEVersionID((String)version.getVersionString());
    }

    public IStatus validate(String name) {
        if (name.equals("IWebFacetInstallDataModelProperties.CONTEXT_ROOT")) {
            return this.validateContextRoot(this.getStringProperty("IWebFacetInstallDataModelProperties.CONTEXT_ROOT"));
        }
        if (name.equals("IWebFacetInstallDataModelProperties.SOURCE_FOLDER")) {
            return this.validateFolderName(this.getStringProperty("IWebFacetInstallDataModelProperties.SOURCE_FOLDER"));
        }
        return super.validate(name);
    }

    protected IStatus validateContextRoot(String contextRoot) {
        if (contextRoot == null) {
            return J2EEPlugin.newErrorStatus((String)ProjectSupportResourceHandler.getString((String)ProjectSupportResourceHandler.Context_Root_cannot_be_empty_2, (Object[])new Object[]{contextRoot}), null);
        }
        if (contextRoot.trim().equals(contextRoot)) {
            StringTokenizer stok = new StringTokenizer(contextRoot, ".");
            while (stok.hasMoreTokens()) {
                String token = stok.nextToken();
                int i = 0;
                while (i < token.length()) {
                    if (token.charAt(i) != '_' && token.charAt(i) != '-' && token.charAt(i) != '/' && !Character.isLetterOrDigit(token.charAt(i))) {
                        Object[] invalidChar = new Object[]{new Character(token.charAt(i)).toString()};
                        String errorStatus = ProjectSupportResourceHandler.getString((String)ProjectSupportResourceHandler.The_character_is_invalid_in_a_context_root, (Object[])invalidChar);
                        return J2EEPlugin.newErrorStatus((String)errorStatus, null);
                    }
                    ++i;
                }
            }
        } else {
            return J2EEPlugin.newErrorStatus((String)ProjectSupportResourceHandler.getString((String)ProjectSupportResourceHandler.Names_cannot_begin_or_end_with_whitespace_5, (Object[])new Object[]{contextRoot}), null);
        }
        return OK_STATUS;
    }
}

