/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.validation.ValidationResult;
import org.eclipse.wst.validation.ValidatorMessage;
import org.eclipse.wst.validation.internal.plugin.ValidationPlugin;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReporterHelper
implements IReporter {
    private IProgressMonitor _monitor;
    private List<IMessage> _list = new LinkedList<IMessage>();

    public ReporterHelper(IProgressMonitor monitor) {
        this._monitor = monitor;
    }

    @Override
    public void addMessage(IValidator origin, IMessage message) {
        this._list.add(message);
    }

    @Override
    public void displaySubtask(IValidator validator, IMessage message) {
        this._monitor.subTask(message.getText(validator.getClass().getClassLoader()));
    }

    @Override
    public List<IMessage> getMessages() {
        return this._list;
    }

    @Override
    public boolean isCancelled() {
        return this._monitor.isCanceled();
    }

    @Override
    public void removeAllMessages(IValidator origin) {
        this._list.clear();
    }

    @Override
    public void removeAllMessages(IValidator origin, Object object) {
    }

    @Override
    public void removeMessageSubset(IValidator validator, Object obj, String groupName) {
    }

    public void makeMarkers() {
        for (IMessage message : this._list) {
            Object target = message.getTargetObject();
            if (target == null || !(target instanceof IResource)) continue;
            IResource res = (IResource)target;
            try {
                IMarker marker = res.createMarker("org.eclipse.wst.validation.problemmarker");
                marker.setAttribute("message", (Object)message.getText());
                int markerSeverity = 0;
                int sev = message.getSeverity();
                if ((sev & 1) != 0) {
                    markerSeverity = 2;
                } else if ((sev & 2) != 0) {
                    markerSeverity = 1;
                }
                marker.setAttribute("severity", markerSeverity);
                marker.setAttribute("lineNumber", message.getLineNumber());
            }
            catch (CoreException e) {
                ValidationPlugin.getPlugin().handleException((Exception)((Object)e));
            }
        }
    }

    public void updateResult(ValidationResult result) {
        for (IMessage message : this._list) {
            Object target = message.getTargetObject();
            if (target == null || !(target instanceof IResource)) continue;
            IResource res = (IResource)target;
            ValidatorMessage vm = ValidatorMessage.create(message.getText(), res);
            result.add(vm);
            int markerSeverity = 0;
            int sev = message.getSeverity();
            if ((sev & 1) != 0) {
                markerSeverity = 2;
            } else if ((sev & 2) != 0) {
                markerSeverity = 1;
            }
            vm.setAttribute("severity", markerSeverity);
            vm.setAttribute("lineNumber", message.getLineNumber());
            int offset = message.getOffset();
            if (offset == -1) continue;
            vm.setAttribute("charStart", offset);
            int len = message.getLength();
            if (len == -1) continue;
            vm.setAttribute("charStart", offset);
            vm.setAttribute("charEnd", offset + len);
        }
    }
}

