/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.wst.validation.IDependencyIndex;
import org.eclipse.wst.validation.ValidationResults;
import org.eclipse.wst.validation.Validator;
import org.eclipse.wst.validation.internal.DependencyIndex;
import org.eclipse.wst.validation.internal.ValManager;
import org.eclipse.wst.validation.internal.ValOperation;
import org.eclipse.wst.validation.internal.ValidationRunner;
import org.eclipse.wst.validation.internal.operations.WorkbenchReporter;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ValidationFramework {
    private IDependencyIndex _dependencyIndex;
    private static ValidationFramework _me;

    public static ValidationFramework getDefault() {
        if (_me == null) {
            _me = new ValidationFramework();
        }
        return _me;
    }

    private ValidationFramework() {
    }

    public IDependencyIndex getDependencyIndex() {
        if (this._dependencyIndex != null) {
            return this._dependencyIndex;
        }
        return this.getDependencyIndex2();
    }

    private synchronized IDependencyIndex getDependencyIndex2() {
        if (this._dependencyIndex == null) {
            this._dependencyIndex = new DependencyIndex();
        }
        return this._dependencyIndex;
    }

    public IEclipsePreferences getPreferenceStore() {
        return new InstanceScope().getNode("org.eclipse.wst.validation");
    }

    public IReporter getReporter(IProject project, IProgressMonitor monitor) {
        return new WorkbenchReporter(project, monitor);
    }

    public Validator[] getValidatorsFor(IResource resource, boolean isManual, boolean isBuild) {
        IProject project = resource.getProject();
        LinkedList<Validator> list = new LinkedList<Validator>();
        Validator[] validatorArray = ValManager.getDefault().getValidators(project);
        int n = validatorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Validator val = validatorArray[n2];
            if (val.shouldValidate(resource, isManual, isBuild)) {
                list.add(val);
            }
            ++n2;
        }
        Validator[] result = new Validator[list.size()];
        list.toArray(result);
        return result;
    }

    public boolean hasValidators(IResource resource, boolean isManual, boolean isBuild) {
        return ValManager.getDefault().hasValidators(resource, isManual, isBuild);
    }

    public ValidationResults validate(IProject[] projects, boolean isManual, boolean isBuild, IProgressMonitor monitor) throws CoreException {
        ValOperation vo = ValidationRunner.validate(this.createMap(projects), isManual, isBuild, monitor);
        return vo.getResults();
    }

    private Map<IProject, Set<IResource>> createMap(IProject[] projects) throws CoreException {
        HashMap<IProject, Set<IResource>> map = new HashMap<IProject, Set<IResource>>(1000);
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject p = iProjectArray[n2];
            HashSet<IResource> set = new HashSet<IResource>(1000);
            ResourceAdder ra = new ResourceAdder(set);
            p.accept((IResourceVisitor)ra);
            map.put(p, set);
            ++n2;
        }
        return map;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ResourceAdder
    implements IResourceVisitor {
        private Set<IResource> _set;

        public ResourceAdder(Set<IResource> set) {
            this._set = set;
        }

        public boolean visit(IResource resource) throws CoreException {
            this._set.add(resource);
            return true;
        }
    }
}

