/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.wst.validation.ValidatorMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidationResult {
    private List<ValidatorMessage> _messages;
    private static ValidatorMessage[] _noMessages = new ValidatorMessage[0];
    private boolean _canceled;
    private IResource[] _dependsOn;
    private IResource[] _validated;
    private int _severityError;
    private int _severityWarning;
    private int _severityInfo;

    public void add(ValidatorMessage message) {
        this.getMessageList().add(message);
    }

    public void mergeResults(ValidationResult result) {
        if (result == null) {
            return;
        }
        ValidatorMessage[] msgs = result.getMessages();
        int i = 0;
        while (i < msgs.length) {
            ValidatorMessage m = msgs[i];
            this.add(m);
            int severity = m.getAttribute("severity", 0);
            switch (severity) {
                case 2: {
                    this.incrementError(1);
                    break;
                }
                case 1: {
                    this.incrementWarning(1);
                    break;
                }
                case 0: {
                    this.incrementInfo(1);
                }
            }
            ++i;
        }
        this.incrementError(result.getSeverityError());
        this.incrementWarning(result.getSeverityWarning());
        this.incrementInfo(result.getSeverityInfo());
    }

    public IResource[] getDependsOn() {
        return this._dependsOn;
    }

    public ValidatorMessage[] getMessages() {
        if (this._messages == null) {
            return _noMessages;
        }
        ValidatorMessage[] msgs = new ValidatorMessage[this._messages.size()];
        this._messages.toArray(msgs);
        return msgs;
    }

    public void setDependsOn(IResource[] dependsOn) {
        this._dependsOn = dependsOn;
    }

    private List<ValidatorMessage> getMessageList() {
        if (this._messages == null) {
            this._messages = new LinkedList<ValidatorMessage>();
        }
        return this._messages;
    }

    public IResource[] getValidated() {
        return this._validated;
    }

    public void setValidated(IResource[] validated) {
        this._validated = validated;
    }

    public int getSeverityError() {
        return this._severityError;
    }

    public void setSeverityError(int severityError) {
        this._severityError = severityError;
    }

    public int incrementError(int errors) {
        this._severityError += errors;
        return this._severityError;
    }

    public int getSeverityWarning() {
        return this._severityWarning;
    }

    public void setSeverityWarning(int severityWarning) {
        this._severityWarning = severityWarning;
    }

    public int incrementWarning(int warnings) {
        this._severityWarning += warnings;
        return this._severityWarning;
    }

    public int getSeverityInfo() {
        return this._severityInfo;
    }

    public void setSeverityInfo(int severityInfo) {
        this._severityInfo = severityInfo;
    }

    public int incrementInfo(int info) {
        this._severityInfo += info;
        return this._severityInfo;
    }

    public boolean isCanceled() {
        return this._canceled;
    }

    public void setCanceled(boolean canceled) {
        this._canceled = canceled;
    }
}

