/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.validation.AbstractValidator;
import org.eclipse.wst.validation.ValidationFramework;
import org.eclipse.wst.validation.ValidationResult;
import org.eclipse.wst.validation.ValidationState;
import org.eclipse.wst.validation.ValidatorMessage;
import org.eclipse.wst.validation.internal.SummaryReporter;
import org.eclipse.wst.validation.internal.ValOperation;
import org.eclipse.wst.validation.internal.ValOperationManager;
import org.eclipse.wst.validation.internal.ValidationConfiguration;
import org.eclipse.wst.validation.internal.ValidatorMetaData;
import org.eclipse.wst.validation.internal.core.ValidatorLauncher;
import org.eclipse.wst.validation.internal.delegates.ValidatorDelegateDescriptor;
import org.eclipse.wst.validation.internal.delegates.ValidatorDelegatesRegistry;
import org.eclipse.wst.validation.internal.model.FilterGroup;
import org.eclipse.wst.validation.internal.operations.IWorkbenchContext;
import org.eclipse.wst.validation.internal.operations.WorkbenchContext;
import org.eclipse.wst.validation.internal.plugin.ValidationPlugin;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;

public abstract class Validator
implements Comparable {
    protected boolean _buildValidation = true;
    private String _delegatingId;
    protected boolean _manualValidation = true;
    private int _version = 1;

    public static Validator create(AbstractValidator validator) {
        return new V2(validator);
    }

    public static Validator create(ValidatorMetaData vmd, ValidationConfiguration config) {
        return new V1(vmd, config);
    }

    public V1 asV1Validator() {
        return null;
    }

    public V2 asV2Validator() {
        return null;
    }

    public void clean(IProject project, IProgressMonitor monitor) {
    }

    public int compareTo(Object validator) {
        if (validator instanceof Validator) {
            Validator other = (Validator)validator;
            return this.getName().compareTo(other.getName());
        }
        return -1;
    }

    public abstract Validator copy();

    protected void copyLocal(Validator v) {
        this._buildValidation = v._buildValidation;
        this._delegatingId = v._delegatingId;
        this._manualValidation = v._manualValidation;
        this._version = v._version;
    }

    public boolean shouldValidate(IResource resource, boolean isManual, boolean isBuild) {
        if (isManual && !this._manualValidation) {
            return false;
        }
        if (isBuild && !this._buildValidation) {
            return false;
        }
        return this.shouldValidate(resource);
    }

    public boolean shouldValidateProject(IProject project, boolean isManual, boolean isBuild) {
        if (isManual && !this._manualValidation) {
            return false;
        }
        if (isBuild && !this._buildValidation) {
            return false;
        }
        if (project == null || !project.isOpen()) {
            return false;
        }
        return this.shouldValidateProject(project);
    }

    public abstract ValidationResult validate(IResource var1, int var2, ValOperation var3, IProgressMonitor var4);

    public void validationStarting(IProject project, ValidationState state, IProgressMonitor monitor) {
    }

    public void validationFinishing(IProject project, ValidationState state, IProgressMonitor monitor) {
    }

    protected abstract boolean shouldValidate(IResource var1);

    protected abstract boolean shouldValidateProject(IProject var1);

    public abstract String getId();

    public abstract String getName();

    public abstract String getValidatorClassname();

    public boolean isManualValidation() {
        return this._manualValidation;
    }

    public void setManualValidation(boolean manualValidation) {
        this._manualValidation = manualValidation;
    }

    public boolean isBuildValidation() {
        return this._buildValidation;
    }

    public void setBuildValidation(boolean buildValidation) {
        this._buildValidation = buildValidation;
    }

    public String getDelegatingId() {
        return this._delegatingId;
    }

    public String getDependencyId() {
        return this.getId();
    }

    public void setDelegatingId(String delegating) {
        this._delegatingId = delegating;
    }

    public int getVersion() {
        return this._version;
    }

    public void setVersion(int version) {
        this._version = version;
    }

    public String toString() {
        return this.getName();
    }

    public static class V1
    extends Validator {
        private ValidatorMetaData _vmd;

        public V1(ValidatorMetaData vmd, ValidationConfiguration config) {
            this._vmd = vmd;
            if (config != null) {
                this.setBuildValidation(config.isBuildEnabled(vmd));
                this.setManualValidation(config.isManualEnabled(vmd));
            }
            this.setDelegatingId(ValidatorDelegatesRegistry.getInstance().getDefaultDelegate(this.getValidatorClassname()));
        }

        public V1 asV1Validator() {
            return this;
        }

        public Validator copy() {
            V1 v = new V1(this._vmd, null);
            v.copyLocal(this);
            return v;
        }

        public String getName() {
            return this._vmd.getValidatorDisplayName();
        }

        public ValidatorMetaData getVmd() {
            return this._vmd;
        }

        public String getValidatorClassname() {
            String name = "";
            try {
                name = this._vmd.getValidator().getClass().getName();
            }
            catch (Exception exception) {}
            return name;
        }

        public String getId() {
            return this._vmd.getValidatorUniqueName();
        }

        public void setBuildValidation(boolean buildValidation) {
            super.setBuildValidation(buildValidation);
            this._vmd.setBuildValidation(buildValidation);
        }

        public void setManualValidation(boolean manualValidation) {
            super.setManualValidation(manualValidation);
            this._vmd.setManualValidation(manualValidation);
        }

        protected boolean shouldValidate(IResource resource) {
            return this._vmd.isApplicableTo(resource);
        }

        protected boolean shouldValidateProject(IProject project) {
            return true;
        }

        public ValidationResult validate(IResource resource, int kind, ValOperation operation, IProgressMonitor monitor) {
            ValidationResult vr = new ValidationResult();
            IValidator v = null;
            try {
                v = this._vmd.getValidator();
            }
            catch (InstantiationException e) {
                ValidationPlugin.getPlugin().handleException(e);
                return null;
            }
            try {
                IProject project = resource.getProject();
                SummaryReporter reporter = new SummaryReporter(project, monitor);
                IWorkbenchContext helper = this._vmd.getHelper(project);
                if (helper instanceof WorkbenchContext) {
                    WorkbenchContext wc = (WorkbenchContext)helper;
                    LinkedList<String> files = new LinkedList<String>();
                    files.add(wc.getPortableName(resource));
                    wc.setValidationFileURIs(files);
                }
                ValidatorLauncher.getLauncher().start(helper, v, reporter);
                vr.incrementError(reporter.getSeverityHigh());
                vr.incrementWarning(reporter.getSeverityNormal());
                vr.incrementInfo(reporter.getSeverityLow());
            }
            catch (Exception e) {
                ValidationPlugin.getPlugin().handleException(e);
            }
            return vr;
        }
    }

    public static class V2
    extends Validator
    implements IAdaptable {
        private AbstractValidator _validator;
        private List<FilterGroup> _groups = new LinkedList<FilterGroup>();
        private FilterGroup[] _groupsArray;
        private String _id;
        private String _name;
        private AbstractValidator _delegated;

        public V2(AbstractValidator base) {
            this._validator = base;
            this.setDelegatingId(ValidatorDelegatesRegistry.getInstance().getDefaultDelegate(this.getValidatorClassname()));
        }

        public synchronized void add(FilterGroup fg) {
            this._groupsArray = null;
            this._groups.add(fg);
        }

        public V2 asV2Validator() {
            return this;
        }

        public void clean(IProject project, IProgressMonitor monitor) {
            this.getDelegatedValidator().clean(project, ValOperationManager.getDefault().getOperation().getState(), monitor);
        }

        public Validator copy() {
            V2 v = new V2(this._validator);
            v.copyLocal(this);
            FilterGroup[] groups = this.getGroups();
            v._groupsArray = new FilterGroup[groups.length];
            int i = 0;
            while (i < groups.length) {
                v._groupsArray[i] = groups[i].copy();
                v._groups.add(v._groupsArray[i]);
                ++i;
            }
            v._id = this._id;
            v._name = this._name;
            return v;
        }

        public String getDependencyId() {
            String id = this.getDelegatedValidator().getDependencyId();
            if (id != null) {
                return id;
            }
            return this.getId();
        }

        public AbstractValidator getDelegatedValidator() {
            AbstractValidator delegated = this._delegated;
            if (delegated != null) {
                return delegated;
            }
            if (this.getDelegatingId() == null) {
                return this._validator;
            }
            try {
                ValidatorDelegateDescriptor vdd = ValidatorDelegatesRegistry.getInstance().getDescriptor(this.getValidatorClassname(), this.getDelegatingId());
                if (vdd == null) {
                    return this._validator;
                }
                delegated = vdd.getValidator2();
            }
            catch (Exception e) {
                ValidationPlugin.getPlugin().handleException(e);
            }
            if (delegated == null) {
                return this._validator;
            }
            this._delegated = delegated;
            return delegated;
        }

        public String getId() {
            return this._id;
        }

        public synchronized FilterGroup[] getGroups() {
            FilterGroup[] groups = this._groupsArray;
            if (groups == null) {
                groups = new FilterGroup[this._groups.size()];
                this._groups.toArray(groups);
                this._groupsArray = groups;
            }
            return groups;
        }

        public String getName() {
            return this._name;
        }

        public AbstractValidator getValidator() {
            return this._validator;
        }

        public String getValidatorClassname() {
            return this.getValidator().getClass().getName();
        }

        protected boolean shouldValidate(IResource resource) {
            FilterGroup[] groups = this.getGroups();
            IProject project = resource.getProject();
            FilterGroup[] filterGroupArray = groups;
            int n = groups.length;
            int n2 = 0;
            while (n2 < n) {
                FilterGroup group = filterGroupArray[n2];
                if (!group.shouldValidate(project, resource)) {
                    return false;
                }
                ++n2;
            }
            return true;
        }

        public void setDelegatingId(String delegating) {
            super.setDelegatingId(delegating);
            this._delegated = null;
        }

        public synchronized void setGroups(FilterGroup[] groups) {
            this._groups.clear();
            this._groupsArray = null;
            FilterGroup[] filterGroupArray = groups;
            int n = groups.length;
            int n2 = 0;
            while (n2 < n) {
                FilterGroup group = filterGroupArray[n2];
                this._groups.add(group);
                ++n2;
            }
        }

        public void setId(String id) {
            this._id = id;
        }

        public void setName(String name) {
            this._name = name;
        }

        public ValidationResult validate(IResource resource, int kind, ValOperation operation, IProgressMonitor monitor) {
            ValidationResult vr = null;
            try {
                vr = this.getDelegatedValidator().validate(resource, kind, operation.getState(), monitor);
            }
            catch (Exception e) {
                ValidationPlugin.getPlugin().handleException(e);
            }
            if (vr != null) {
                IResource[] validated;
                if (vr.getDependsOn() != null) {
                    ValidationFramework.getDefault().getDependencyIndex().set(this.getDependencyId(), resource, vr.getDependsOn());
                }
                if ((validated = vr.getValidated()) != null) {
                    int i = 0;
                    while (i < validated.length) {
                        operation.addValidated(this.getId(), validated[i]);
                        ++i;
                    }
                }
                ValidatorMessage[] msgs = vr.getMessages();
                int i = 0;
                while (i < msgs.length) {
                    ValidatorMessage m = msgs[i];
                    try {
                        IMarker marker = m.getResource().createMarker(m.getType());
                        marker.setAttributes(m.getAttributes());
                    }
                    catch (CoreException e) {
                        ValidationPlugin.getPlugin().handleException((Exception)((Object)e));
                    }
                    ++i;
                }
            }
            return vr;
        }

        public void validationStarting(IProject project, ValidationState state, IProgressMonitor monitor) {
            this._validator.validationStarting(project, state, monitor);
        }

        public void validationFinishing(IProject project, ValidationState state, IProgressMonitor monitor) {
            this._validator.validationFinishing(project, state, monitor);
        }

        public Object getAdapter(Class adapter) {
            return Platform.getAdapterManager().getAdapter((Object)this, adapter);
        }

        public synchronized void remove(FilterGroup group) {
            this._groups.remove(group);
            this._groupsArray = null;
        }

        protected boolean shouldValidateProject(IProject project) {
            FilterGroup[] groups;
            FilterGroup[] filterGroupArray = groups = this.getGroups();
            int n = groups.length;
            int n2 = 0;
            while (n2 < n) {
                FilterGroup group = filterGroupArray[n2];
                if (!group.shouldValidate(project, null)) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
    }
}

