/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeSet;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.validation.ValidationFramework;
import org.eclipse.wst.validation.ValidationResult;
import org.eclipse.wst.validation.Validator;
import org.eclipse.wst.validation.internal.ConfigurationManager;
import org.eclipse.wst.validation.internal.Misc;
import org.eclipse.wst.validation.internal.ValMessages;
import org.eclipse.wst.validation.internal.ValOperation;
import org.eclipse.wst.validation.internal.ValPrefManagerGlobal;
import org.eclipse.wst.validation.internal.ValPrefManagerProject;
import org.eclipse.wst.validation.internal.ValidationConfiguration;
import org.eclipse.wst.validation.internal.ValidationRegistryReader;
import org.eclipse.wst.validation.internal.ValidatorExtensionReader;
import org.eclipse.wst.validation.internal.ValidatorMetaData;
import org.eclipse.wst.validation.internal.model.GlobalPreferences;
import org.eclipse.wst.validation.internal.model.IValidatorVisitor;
import org.eclipse.wst.validation.internal.model.ProjectPreferences;
import org.eclipse.wst.validation.internal.plugin.ValidationPlugin;
import org.osgi.service.prefs.BackingStoreException;

public class ValManager {
    private static ValManager _me;
    private Validator[] _validators;
    private Map<IProject, ProjectPreferences> _projectPreferences = Collections.synchronizedMap(new HashMap(50));
    private GlobalPreferences _globalPreferences;

    public static synchronized ValManager getDefault() {
        if (_me == null) {
            _me = new ValManager();
        }
        return _me;
    }

    private ValManager() {
    }

    public Validator[] getValidators() {
        return this.getValidators(false, null);
    }

    public Validator[] getValidators(IProject project) {
        if (project == null) {
            return this.getValidators();
        }
        if (!this.getGlobalPreferences().getOverride()) {
            return this.getValidators(false, project);
        }
        ProjectPreferences pp = this.getProjectPreferences(project);
        if (pp == null || !pp.getOverride()) {
            return this.getValidators(false, project);
        }
        return pp.getValidators();
    }

    public Validator getValidator(String id, IProject project) {
        Validator[] vals;
        Validator[] validatorArray = vals = this.getValidators(project);
        int n = vals.length;
        int n2 = 0;
        while (n2 < n) {
            Validator v = validatorArray[n2];
            if (v.getDependencyId().equals(id)) {
                return v;
            }
            ++n2;
        }
        return null;
    }

    public boolean hasValidators(IResource resource, boolean isManual, boolean isBuild) {
        if (resource instanceof IProject) {
            IProject project = (IProject)resource;
            return ValManager.getDefault().getValidators(project).length > 0;
        }
        if (resource instanceof IFolder) {
            IFolder folder = (IFolder)resource;
            HasValidatorVisitor v = new HasValidatorVisitor(isManual, isBuild);
            return v.hasValidator(folder);
        }
        Validator[] validatorArray = ValManager.getDefault().getValidators(resource.getProject());
        int n = validatorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Validator val = validatorArray[n2];
            if (val.shouldValidate(resource, isManual, isBuild)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    Validator[] getValidators(boolean forceDefaults, IProject project) {
        Validator[] validators = this._validators;
        if (!forceDefaults && project == null && validators != null) {
            return validators;
        }
        Validator[] val = this.loadExtensions(false);
        if (forceDefaults) {
            val = this.restoreDefaults2();
            this.saveStateTimestamp();
        } else {
            ValPrefManagerGlobal vpm = new ValPrefManagerGlobal();
            if (!vpm.loadPreferences(val)) {
                val = this.restoreDefaults2();
                this.saveStateTimestamp();
            } else if (this.getGlobalPreferences().getStateTimeStamp() != Platform.getStateStamp()) {
                val = this.migrateSettings(val);
            }
        }
        TreeSet<Validator> set = new TreeSet<Validator>();
        Validator[] validatorArray = val;
        int n = val.length;
        int n2 = 0;
        while (n2 < n) {
            Validator v = validatorArray[n2];
            set.add(v);
            ++n2;
        }
        LinkedList<Validator> list = new LinkedList<Validator>();
        ValidationConfiguration vc = null;
        try {
            if (project == null) {
                vc = ConfigurationManager.getManager().getGlobalConfiguration();
                for (ValidatorMetaData vmd : ValidationRegistryReader.getReader().getAllValidators()) {
                    list.add(Validator.create(vmd, vc));
                }
            } else {
                vc = ConfigurationManager.getManager().getProjectConfiguration(project);
                ValidatorMetaData[] validatorMetaDataArray = vc.getValidators();
                int n3 = validatorMetaDataArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    ValidatorMetaData vmd = validatorMetaDataArray[n4];
                    list.add(Validator.create(vmd, vc));
                    ++n4;
                }
            }
        }
        catch (InvocationTargetException e) {
            ValidationPlugin.getPlugin().handleException(e);
        }
        set.addAll(list);
        val = new Validator[set.size()];
        set.toArray(val);
        if (project == null) {
            this._validators = val;
        }
        return val;
    }

    private void saveStateTimestamp() {
        try {
            IEclipsePreferences prefs = ValidationFramework.getDefault().getPreferenceStore();
            long ts = Platform.getStateStamp();
            this.getGlobalPreferences().setStateTimeStamp(ts);
            prefs.putLong("stateTS", ts);
            prefs.flush();
        }
        catch (BackingStoreException e) {
            ValidationPlugin.getPlugin().handleException((Exception)((Object)e));
        }
    }

    private Validator[] migrateSettings(Validator[] validators) {
        Validator[] newVals = ValidatorExtensionReader.migrate(validators);
        ValPrefManagerGlobal vpm = new ValPrefManagerGlobal();
        if (newVals != null) {
            validators = newVals;
            vpm.saveAsPrefs(validators);
        }
        this.saveStateTimestamp();
        return validators;
    }

    public GlobalPreferences getGlobalPreferences() {
        GlobalPreferences gp = this._globalPreferences;
        if (gp == null) {
            ValPrefManagerGlobal vpm = new ValPrefManagerGlobal();
            this._globalPreferences = gp = vpm.loadGlobalPreferences();
        }
        return gp;
    }

    public ProjectPreferences getProjectPreferences(IProject project) {
        if (this._projectPreferences.containsKey(project)) {
            return this._projectPreferences.get(project);
        }
        ValPrefManagerProject vpm = new ValPrefManagerProject(project);
        ProjectPreferences pp = vpm.loadProjectPreferences();
        this._projectPreferences.put(project, pp);
        return pp;
    }

    public synchronized void restoreDefaults() {
        this.getGlobalPreferences().resetToDefault();
        this._validators = null;
        this.getValidators(true, null);
    }

    private synchronized Validator[] restoreDefaults2() {
        Validator[] val = ValidatorExtensionReader.process(true);
        ValPrefManagerGlobal vpm = new ValPrefManagerGlobal();
        vpm.saveAsPrefs(val);
        return val;
    }

    private Validator[] loadExtensions(boolean deep) {
        return ValidatorExtensionReader.process(deep);
    }

    public void validate(IProject project, final IResource resource, final int kind, boolean isManual, boolean isBuild, int buildKind, ValOperation operation, IProgressMonitor monitor) {
        this.deleteMarkers(resource);
        IValidatorVisitor visitor = new IValidatorVisitor(){

            public void visit(Validator validator, IProject project, boolean isManual, boolean isBuild, ValOperation operation, IProgressMonitor monitor) {
                IResource[] dependencies;
                Validator.V1 v1 = validator.asV1Validator();
                if (isBuild && v1 != null) {
                    return;
                }
                ValManager.this.validate(validator, operation, resource, kind, monitor);
                if ((kind & 0x104) != 0 && (dependencies = ValidationFramework.getDefault().getDependencyIndex().get(validator.getDependencyId(), resource)) != null) {
                    IResource[] iResourceArray = dependencies;
                    int n = dependencies.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IResource resource2 = iResourceArray[n2];
                        ValManager.this.validate(validator, operation, resource2, 0, monitor);
                        operation.addValidated(validator.getId(), resource2);
                        ++n2;
                    }
                }
            }
        };
        this.accept(visitor, project, resource, isManual, isBuild, operation, monitor);
    }

    public void validate(Validator validator, ValOperation operation, IResource resource, int kind, IProgressMonitor monitor) {
        if (operation.isValidated(validator.getId(), resource)) {
            return;
        }
        long time = 0L;
        String msg1 = NLS.bind((String)ValMessages.LogValStart, (Object)validator.getName(), (Object)resource.getName());
        monitor.subTask(msg1);
        if (ValidationPlugin.getPlugin().isDebugging()) {
            if (Misc.debugOptionAsBoolean("org.eclipse.wst.validation/timings")) {
                time = System.currentTimeMillis();
            }
            Misc.log(msg1);
        }
        ValidationResult vr = validator.validate(resource, kind, operation, monitor);
        if (ValidationPlugin.getPlugin().isDebugging()) {
            String msg = time != 0L ? NLS.bind((String)ValMessages.LogValEndTime, (Object[])new Object[]{validator.getName(), resource, String.valueOf(System.currentTimeMillis() - time)}) : NLS.bind((String)ValMessages.LogValEnd, (Object)validator.getName(), (Object)resource);
            Misc.log(msg);
        }
        operation.getResult().mergeResults(vr);
    }

    private void deleteMarkers(IResource resource) {
        try {
            resource.deleteMarkers("org.eclipse.wst.validation.problemmarker2", false, 0);
        }
        catch (CoreException e) {
            ValidationPlugin.getPlugin().handleException((Exception)((Object)e));
        }
    }

    public void accept(IValidatorVisitor visitor, IProject project, boolean isManual, boolean isBuild, ValOperation operation, IProgressMonitor monitor) {
        GlobalPreferences gp = this.getGlobalPreferences();
        if (gp.getDisableAllValidation()) {
            return;
        }
        Validator[] validatorArray = this.getValidators(project);
        int n = validatorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Validator val = validatorArray[n2];
            if (monitor.isCanceled()) {
                return;
            }
            if (val.shouldValidateProject(project, isManual, isBuild)) {
                try {
                    visitor.visit(val, project, isManual, isBuild, operation, monitor);
                }
                catch (Exception e) {
                    ValidationPlugin.getPlugin().handleException(e);
                }
            }
            ++n2;
        }
    }

    public void accept(IValidatorVisitor visitor, IProject project, IResource resource, boolean isManual, boolean isBuild, ValOperation operation, IProgressMonitor monitor) {
        GlobalPreferences gp = this.getGlobalPreferences();
        if (gp.getDisableAllValidation()) {
            return;
        }
        ProjectPreferences pp = null;
        if (gp.getOverride()) {
            pp = this.getProjectPreferences(project);
        }
        if (pp != null && pp.getSuspend()) {
            return;
        }
        Validator[] validatorArray = this.getValidators(project);
        int n = validatorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Validator val = validatorArray[n2];
            if (monitor.isCanceled()) {
                return;
            }
            if (val.shouldValidate(resource, isManual, isBuild)) {
                try {
                    visitor.visit(val, project, isManual, isBuild, operation, monitor);
                }
                catch (Exception e) {
                    ValidationPlugin.getPlugin().handleException(e);
                }
            }
            ++n2;
        }
    }

    void clean(IProject project, ValOperation operation, IProgressMonitor monitor) {
        IValidatorVisitor visitor = new IValidatorVisitor(){

            public void visit(Validator validator, IProject project, boolean isManual, boolean isBuild, ValOperation operation, IProgressMonitor monitor) {
                validator.clean(project, monitor);
            }
        };
        this.accept(visitor, project, false, false, operation, monitor);
    }

    public void clean(IProject project, IProgressMonitor monitor) {
        IValidatorVisitor visitor = new IValidatorVisitor(){

            public void visit(Validator validator, IProject project, boolean isManual, boolean isBuild, ValOperation operation, IProgressMonitor monitor) {
                validator.clean(project, monitor);
            }
        };
        ValidationFramework.getDefault().getDependencyIndex().clear(project);
        ValOperation operation = new ValOperation();
        this.accept(visitor, project, false, true, operation, monitor);
    }

    private class HasValidatorVisitor
    implements IResourceVisitor {
        private boolean _hasValidator;
        private boolean _isManual;
        private boolean _isBuild;

        public HasValidatorVisitor(boolean isManual, boolean isBuild) {
            this._isManual = isManual;
            this._isBuild = isBuild;
        }

        public boolean hasValidator(IFolder folder) {
            try {
                folder.accept((IResourceVisitor)this);
            }
            catch (CoreException e) {
                ValidationPlugin.getPlugin().handleException((Exception)((Object)e));
            }
            return this._hasValidator;
        }

        public boolean visit(IResource resource) throws CoreException {
            if (resource instanceof IFolder) {
                return true;
            }
            if (ValManager.this.hasValidators(resource, this._isManual, this._isBuild)) {
                this._hasValidator = true;
                return false;
            }
            return true;
        }
    }
}

