/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.internal;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.wst.validation.Validator;
import org.eclipse.wst.validation.internal.Misc;
import org.eclipse.wst.validation.internal.ValManager;
import org.eclipse.wst.validation.internal.ValOperation;
import org.eclipse.wst.validation.internal.model.IValidatorVisitor;

public class ValOperationManager
implements IResourceChangeListener {
    private static ValOperationManager _me;
    private ValOperation _operation;

    public static synchronized ValOperationManager getDefault() {
        if (_me == null) {
            _me = new ValOperationManager();
        }
        return _me;
    }

    private ValOperationManager() {
        this.init();
    }

    private void init() {
        this._operation = new ValOperation();
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IValidatorVisitor visitor;
        int type = event.getType();
        int kind = event.getBuildKind();
        IProject project = null;
        if (event.getSource() instanceof IProject) {
            project = (IProject)event.getSource();
        }
        if (kind == 15 && (type & 8) != 0) {
            this.processClean(event);
        }
        if (this.isBuildStarting(event)) {
            visitor = new IValidatorVisitor(){

                public void visit(Validator validator, IProject project, boolean isManual, boolean isBuild, ValOperation operation, IProgressMonitor monitor) {
                    validator.validationStarting(project, operation.getState(), monitor);
                }
            };
            ValManager.getDefault().accept(visitor, project, false, true, this._operation, (IProgressMonitor)new NullProgressMonitor());
        }
        if (this.isBuildFinished(event)) {
            visitor = new IValidatorVisitor(){

                public void visit(Validator validator, IProject project, boolean isManual, boolean isBuild, ValOperation operation, IProgressMonitor monitor) {
                    validator.validationFinishing(project, operation.getState(), monitor);
                }
            };
            ValManager.getDefault().accept(visitor, project, false, true, this._operation, (IProgressMonitor)new NullProgressMonitor());
            this.init();
        }
        if (Misc.isLogging()) {
            IResourceDelta rd;
            String kindName = null;
            kindName = kind == 9 ? "Auto" : (kind == 15 ? "Clean" : (kind == 6 ? "Full" : (kind == 10 ? "Incremental" : String.valueOf(kind))));
            StringBuffer b = new StringBuffer(100);
            String sourceName = "unknown";
            if (event.getSource() instanceof IResource) {
                IResource res = (IResource)event.getSource();
                sourceName = res.getName();
            } else if (event.getSource() instanceof IWorkspace) {
                sourceName = "Workspace";
            }
            b.append("Source=" + sourceName + ", kind=" + kindName + ", type=" + type);
            if ((type & 0x10) != 0) {
                b.append(", post build");
            }
            if ((type & 8) != 0) {
                b.append(", pre build");
            }
            if ((rd = event.getDelta()) == null) {
                b.append(", there was no resource delta");
            }
            Misc.log(b);
        }
    }

    private boolean isBuildStarting(IResourceChangeEvent event) {
        int type = event.getType();
        int kind = event.getBuildKind();
        if (ResourcesPlugin.getWorkspace().isAutoBuilding()) {
            if ((type & 8) != 0 && (kind == 9 || kind == 10 || kind == 6)) {
                return true;
            }
            return (type & 0x10) != 0 && kind == 15;
        }
        if (kind == 9) {
            return false;
        }
        return (type & 8) != 0 && (kind == 10 || kind == 6);
    }

    private boolean isBuildFinished(IResourceChangeEvent event) {
        int type = event.getType();
        int kind = event.getBuildKind();
        return ResourcesPlugin.getWorkspace().isAutoBuilding() ? (type & 0x10) != 0 && kind == 9 && event.getSource() instanceof IWorkspace : kind != 9 && (type & 0x10) != 0;
    }

    private void processClean(IResourceChangeEvent event) {
        NullProgressMonitor monitor = new NullProgressMonitor();
        Object source = event.getSource();
        if (source instanceof IWorkspace) {
            ValManager.getDefault().clean(null, this._operation, (IProgressMonitor)monitor);
        }
    }

    public ValOperation getOperation() {
        return this._operation;
    }
}

