/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.internal;

import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.validation.ValidationFramework;
import org.eclipse.wst.validation.Validator;
import org.eclipse.wst.validation.internal.ValMessages;
import org.eclipse.wst.validation.internal.model.FilterGroup;
import org.eclipse.wst.validation.internal.model.FilterRule;
import org.eclipse.wst.validation.internal.model.GlobalPreferences;
import org.eclipse.wst.validation.internal.plugin.ValidationPlugin;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class ValPrefManagerGlobal {
    public static final int frameworkVersion = 2;

    public boolean loadPreferences(Validator[] val) {
        IEclipsePreferences pref;
        block5: {
            pref = new InstanceScope().getNode("org.eclipse.wst.validation");
            if (pref.nodeExists("filters")) break block5;
            return false;
        }
        try {
            Preferences filters = pref.node("filters");
            Validator[] validatorArray = val;
            int n = val.length;
            int n2 = 0;
            while (n2 < n) {
                Validator v = validatorArray[n2];
                String id = v.getId();
                if (filters.nodeExists(id)) {
                    Preferences vp = filters.node(id);
                    ValPrefManagerGlobal.loadPreferences(v, vp);
                }
                ++n2;
            }
        }
        catch (Exception e) {
            ValidationPlugin.getPlugin().handleException(e);
            return false;
        }
        return true;
    }

    public GlobalPreferences loadGlobalPreferences() {
        IEclipsePreferences pref = ValidationFramework.getDefault().getPreferenceStore();
        GlobalPreferences gp = new GlobalPreferences();
        gp.setSaveAutomatically(pref.getBoolean("saveAuto", false));
        gp.setDisableAllValidation(pref.getBoolean("suspend", false));
        gp.setConfirmDialog(pref.getBoolean("confirmDialog", true));
        gp.setOverride(pref.getBoolean("override", false));
        gp.setStateTimeStamp(pref.getLong("stateTS", 0L));
        return gp;
    }

    static void loadPreferences(Validator v, Preferences p) throws BackingStoreException {
        v.setBuildValidation(p.getBoolean("build", true));
        v.setManualValidation(p.getBoolean("manual", true));
        v.setVersion(p.getInt("version", 1));
        v.setDelegatingId(p.get("delegate", null));
        Validator.V2 v2 = v.asV2Validator();
        if (v2 == null) {
            return;
        }
        if (!p.nodeExists("groups")) {
            return;
        }
        Preferences groupNode = p.node("groups");
        String[] stringArray = groupNode.childrenNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String groupName = stringArray[n2];
            Preferences group = groupNode.node(groupName);
            String type = group.get("type", null);
            if (type == null) {
                throw new IllegalStateException(ValMessages.ErrGroupNoType);
            }
            FilterGroup fg = FilterGroup.create(type);
            if (fg == null) {
                throw new IllegalStateException(NLS.bind((String)ValMessages.ErrGroupInvalidType, (Object)type));
            }
            v2.add(fg);
            if (group.nodeExists("rules")) {
                Preferences ruleNode = group.node("rules");
                String[] stringArray2 = ruleNode.childrenNames();
                int n3 = stringArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    String ruleName = stringArray2[n4];
                    Preferences rule = ruleNode.node(ruleName);
                    FilterRule fr = FilterRule.create(rule.get("type", null));
                    if (fr != null) {
                        fg.add(fr);
                        fr.setData(rule.get("pattern", null));
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }

    public synchronized void save(Validator v) {
        try {
            IEclipsePreferences prefs = ValidationFramework.getDefault().getPreferenceStore();
            Preferences filters = prefs.node("filters");
            Preferences vp = filters.node(v.getId());
            vp.removeNode();
            this.save(v, filters);
            prefs.flush();
        }
        catch (BackingStoreException e) {
            ValidationPlugin.getPlugin().handleException((Exception)((Object)e));
        }
    }

    private void save(Validator validator, Preferences filters) {
        Validator.V2 v2;
        Preferences vp = filters.node(validator.getId());
        vp.putBoolean("build", validator.isBuildValidation());
        vp.putBoolean("manual", validator.isManualValidation());
        vp.putInt("version", validator.getVersion());
        if (validator.getDelegatingId() != null) {
            vp.put("delegate", validator.getDelegatingId());
        }
        if ((v2 = validator.asV2Validator()) == null) {
            return;
        }
        FilterGroup[] groups = v2.getGroups();
        Preferences group = vp.node("groups");
        int i = 0;
        while (i < groups.length) {
            Preferences gid = group.node(String.valueOf(i));
            gid.put("type", groups[i].getType());
            FilterRule[] rules = groups[i].getRules();
            Preferences r = gid.node("rules");
            int j = 0;
            while (j < rules.length) {
                Preferences rid = r.node(String.valueOf(j));
                rid.put("type", rules[j].getType());
                rid.put("pattern", rules[j].getPattern());
                ++j;
            }
            ++i;
        }
    }

    public void saveAsPrefs(Validator[] val) {
        try {
            IEclipsePreferences pref = ValidationFramework.getDefault().getPreferenceStore();
            Preferences filters = pref.node("filters");
            filters.removeNode();
            filters = pref.node("filters");
            Validator[] validatorArray = val;
            int n = val.length;
            int n2 = 0;
            while (n2 < n) {
                Validator v = validatorArray[n2];
                this.save(v, filters);
                ++n2;
            }
            pref.flush();
        }
        catch (BackingStoreException e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized void saveShallowPreferences(GlobalPreferences gp, Validator[] validators) {
        try {
            IEclipsePreferences prefs = ValidationFramework.getDefault().getPreferenceStore();
            prefs.putBoolean("saveAuto", gp.getSaveAutomatically());
            prefs.putBoolean("suspend", gp.getDisableAllValidation());
            prefs.putLong("stateTS", gp.getStateTimeStamp());
            prefs.putBoolean("confirmDialog", gp.getConfirmDialog());
            prefs.putBoolean("override", gp.getOverride());
            Preferences filters = prefs.node("filters");
            Validator[] validatorArray = validators;
            int n = validators.length;
            int n2 = 0;
            while (n2 < n) {
                Validator v = validatorArray[n2];
                this.saveShallowPreference(v, filters);
                ++n2;
            }
            prefs.flush();
        }
        catch (BackingStoreException e) {
            ValidationPlugin.getPlugin().handleException((Exception)((Object)e));
        }
    }

    private void saveShallowPreference(Validator validator, Preferences prefs) {
        if (validator.asV2Validator() == null) {
            return;
        }
        Preferences val = prefs.node(validator.getId());
        val.putBoolean("build", validator.isBuildValidation());
        val.putBoolean("manual", validator.isManualValidation());
        val.putInt("version", validator.getVersion());
    }
}

