/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.internal;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.wst.validation.Validator;
import org.eclipse.wst.validation.internal.ConfigurationManager;
import org.eclipse.wst.validation.internal.ProjectConfiguration;
import org.eclipse.wst.validation.internal.ValManager;
import org.eclipse.wst.validation.internal.ValPrefManagerGlobal;
import org.eclipse.wst.validation.internal.ValidatorMetaData;
import org.eclipse.wst.validation.internal.model.FilterGroup;
import org.eclipse.wst.validation.internal.model.FilterRule;
import org.eclipse.wst.validation.internal.model.ProjectPreferences;
import org.eclipse.wst.validation.internal.plugin.ValidationPlugin;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValPrefManagerProject {
    private IProject _project;

    public ValPrefManagerProject(IProject project) {
        assert (project != null);
        this._project = project;
    }

    public boolean hasProjectSpecificSettings() {
        IEclipsePreferences pref = this.getPreferences();
        if (pref == null) {
            return false;
        }
        int version = pref.getInt("vf.version", 0);
        return version != 0;
    }

    public ProjectPreferences loadProjectPreferences() {
        IEclipsePreferences pref = this.getPreferences();
        if (pref == null) {
            return null;
        }
        int version = pref.getInt("vf.version", 0);
        if (version == 0) {
            return null;
        }
        ProjectPreferences pp = new ProjectPreferences(this._project);
        pp.setOverride(pref.getBoolean("override", false));
        pp.setSuspend(pref.getBoolean("suspend", false));
        Validator[] vals = ValManager.getDefault().getValidators(false, this._project);
        this.loadPreferences(vals, pref);
        pp.setValidators(vals);
        return pp;
    }

    private boolean loadPreferences(Validator[] val, IEclipsePreferences pref) {
        block5: {
            if (pref.nodeExists("filters")) break block5;
            return false;
        }
        try {
            Preferences filters = pref.node("filters");
            Validator[] validatorArray = val;
            int n = val.length;
            int n2 = 0;
            while (n2 < n) {
                Validator v = validatorArray[n2];
                String id = v.getId();
                if (filters.nodeExists(id)) {
                    Preferences vp = filters.node(id);
                    ValPrefManagerGlobal.loadPreferences(v, vp);
                }
                ++n2;
            }
        }
        catch (Exception e) {
            ValidationPlugin.getPlugin().handleException(e);
            return false;
        }
        return true;
    }

    private IEclipsePreferences getPreferences() {
        ProjectScope projectContext = new ProjectScope(this._project);
        IEclipsePreferences pref = projectContext.getNode("org.eclipse.wst.validation");
        return pref;
    }

    public void savePreferences(ProjectPreferences projectPreferences, Validator[] validators) {
        IEclipsePreferences pref = this.getPreferences();
        pref.putBoolean("suspend", projectPreferences.getSuspend());
        pref.putBoolean("override", projectPreferences.getOverride());
        pref.putInt("vf.version", 2);
        Preferences filters = pref.node("filters");
        try {
            filters.removeNode();
            filters = pref.node("filters");
        }
        catch (BackingStoreException e) {
            ValidationPlugin.getPlugin().handleException((Exception)((Object)e));
        }
        Validator[] validatorArray = validators;
        int n = validators.length;
        int n2 = 0;
        while (n2 < n) {
            Validator v = validatorArray[n2];
            this.savePreference(v, filters);
            ++n2;
        }
        try {
            pref.flush();
            ProjectConfiguration pc = ConfigurationManager.getManager().getProjectConfiguration(projectPreferences.getProject());
            pc.setEnabledBuildValidators(this.getEnabledBuildValidators(validators));
            pc.setEnabledManualValidators(this.getEnabledManualValidators(validators));
            pc.passivate();
            pc.store();
        }
        catch (Exception e) {
            ValidationPlugin.getPlugin().handleException(e);
        }
    }

    private Set<ValidatorMetaData> getEnabledBuildValidators(Validator[] validators) {
        HashSet<ValidatorMetaData> set = new HashSet<ValidatorMetaData>(50);
        Validator[] validatorArray = validators;
        int n = validators.length;
        int n2 = 0;
        while (n2 < n) {
            Validator.V1 v1;
            Validator v = validatorArray[n2];
            if (v.isBuildValidation() && (v1 = v.asV1Validator()) != null) {
                set.add(v1.getVmd());
            }
            ++n2;
        }
        return set;
    }

    private Set<ValidatorMetaData> getEnabledManualValidators(Validator[] validators) {
        HashSet<ValidatorMetaData> set = new HashSet<ValidatorMetaData>(50);
        Validator[] validatorArray = validators;
        int n = validators.length;
        int n2 = 0;
        while (n2 < n) {
            Validator.V1 v1;
            Validator v = validatorArray[n2];
            if (v.isManualValidation() && (v1 = v.asV1Validator()) != null) {
                set.add(v1.getVmd());
            }
            ++n2;
        }
        return set;
    }

    private void savePreference(Validator validator, Preferences prefs) {
        Validator.V2 v2;
        if (validator.asV2Validator() == null) {
            return;
        }
        Preferences val = prefs.node(validator.getId());
        val.putBoolean("build", validator.isBuildValidation());
        val.putBoolean("manual", validator.isManualValidation());
        val.putInt("version", validator.getVersion());
        if (validator.getDelegatingId() != null) {
            val.put("delegate", validator.getDelegatingId());
        }
        if ((v2 = validator.asV2Validator()) == null) {
            return;
        }
        FilterGroup[] groups = v2.getGroups();
        Preferences group = val.node("groups");
        int i = 0;
        while (i < groups.length) {
            Preferences gid = group.node(String.valueOf(i));
            gid.put("type", groups[i].getType());
            FilterRule[] rules = groups[i].getRules();
            Preferences r = gid.node("rules");
            int j = 0;
            while (j < rules.length) {
                Preferences rid = r.node(String.valueOf(j));
                rid.put("type", rules[j].getType());
                rid.put("pattern", rules[j].getPattern());
                ++j;
            }
            ++i;
        }
    }
}

