/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.internal;

import java.util.HashMap;
import java.util.LinkedList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.validation.AbstractValidator;
import org.eclipse.wst.validation.Validator;
import org.eclipse.wst.validation.internal.ValMessages;
import org.eclipse.wst.validation.internal.model.FilterGroup;
import org.eclipse.wst.validation.internal.model.FilterRule;
import org.eclipse.wst.validation.internal.plugin.ValidationPlugin;

public class ValidatorExtensionReader {
    public static Validator[] process(boolean deep) {
        ValidatorExtensionReader ver = new ValidatorExtensionReader();
        return ver.readRegistry(deep);
    }

    public static Validator[] migrate(Validator[] validators) {
        ValidatorExtensionReader ver = new ValidatorExtensionReader();
        return ver.migrate2(validators);
    }

    private ValidatorExtensionReader() {
    }

    private Validator[] readRegistry(boolean deep) {
        LinkedList<Validator> list = new LinkedList<Validator>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint("org.eclipse.wst.validation", "validatorV2");
        if (extensionPoint == null) {
            return new Validator[0];
        }
        IExtension[] iExtensionArray = extensionPoint.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension ext = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = ext.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement validator = iConfigurationElementArray[n4];
                Validator v = this.processValidator(validator, ext.getUniqueIdentifier(), ext.getLabel(), deep);
                if (v != null) {
                    list.add(v);
                }
                ++n4;
            }
            ++n2;
        }
        Validator[] val = new Validator[list.size()];
        list.toArray(val);
        return val;
    }

    private Validator processValidator(IConfigurationElement validator, String id, String label, boolean deep) {
        Validator.V2 v = null;
        try {
            AbstractValidator vb = (AbstractValidator)validator.createExecutableExtension("class");
            v = Validator.create(vb).asV2Validator();
            v.setId(id);
            v.setName(label);
            v.setBuildValidation(this.getAttribute(validator, "build", true));
            v.setManualValidation(this.getAttribute(validator, "manual", true));
            v.setVersion(this.getAttribute(validator, "version", 1));
            if (deep) {
                IConfigurationElement[] children = validator.getChildren();
                int i = 0;
                while (i < children.length) {
                    this.processValidatorChildren(v, children[i]);
                    ++i;
                }
            }
        }
        catch (Exception e) {
            ValidationPlugin.getPlugin().handleException(e);
            IContributor contrib = validator.getContributor();
            String message = NLS.bind((String)ValMessages.ErrConfig, (Object)contrib.getName());
            ValidationPlugin.getPlugin().logMessage(4, message);
        }
        return v;
    }

    private void processValidatorChildren(Validator.V2 v, IConfigurationElement group) {
        FilterGroup fg = FilterGroup.create(group.getName());
        if (fg == null) {
            throw new IllegalStateException(ValMessages.ErrGroupName);
        }
        IConfigurationElement[] rules = group.getChildren("rules");
        int i = 0;
        while (i < rules.length) {
            IConfigurationElement[] r = rules[i].getChildren();
            int j = 0;
            while (j < r.length) {
                this.processRule(fg, r[j]);
                ++j;
            }
            ++i;
        }
        v.add(fg);
    }

    private void processRule(FilterGroup fg, IConfigurationElement rule) {
        FilterRule fr = FilterRule.create(rule.getName());
        if (fr == null) {
            throw new IllegalStateException(ValMessages.ErrFilterRule);
        }
        fr.setData(rule);
        fg.add(fr);
    }

    private Validator[] migrate2(Validator[] validators) {
        int count = 0;
        HashMap<String, Validator> map = new HashMap<String, Validator>(validators.length);
        Validator[] validatorArray = validators;
        int n = validators.length;
        int n2 = 0;
        while (n2 < n) {
            Validator v = validatorArray[n2];
            map.put(v.getId(), v);
            ++n2;
        }
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint("org.eclipse.wst.validation", "validatorV2");
        if (extensionPoint == null) {
            return null;
        }
        IExtension[] iExtensionArray = extensionPoint.getExtensions();
        int n3 = iExtensionArray.length;
        int n4 = 0;
        while (n4 < n3) {
            IExtension ext = iExtensionArray[n4];
            IConfigurationElement[] iConfigurationElementArray = ext.getConfigurationElements();
            int n5 = iConfigurationElementArray.length;
            int n6 = 0;
            while (n6 < n5) {
                Validator old;
                IConfigurationElement validator = iConfigurationElementArray[n6];
                Validator v = this.processValidator(validator, ext.getUniqueIdentifier(), ext.getLabel(), true);
                if (v != null && ((old = (Validator)map.get(v.getId())) == null || old.getVersion() < v.getVersion())) {
                    map.put(v.getId(), v);
                    ++count;
                }
                ++n6;
            }
            ++n4;
        }
        if (count > 0) {
            Validator[] vals = new Validator[map.size()];
            map.values().toArray(vals);
            return vals;
        }
        return null;
    }

    private boolean getAttribute(IConfigurationElement element, String name, boolean dft) {
        String v = element.getAttribute(name);
        if (v == null) {
            return dft;
        }
        if ("true".equalsIgnoreCase(v)) {
            return true;
        }
        if ("false".equalsIgnoreCase(v)) {
            return false;
        }
        return dft;
    }

    private int getAttribute(IConfigurationElement element, String name, int dft) {
        String v = element.getAttribute(name);
        if (v == null) {
            return dft;
        }
        try {
            return Integer.parseInt(v);
        }
        catch (Exception exception) {
            return dft;
        }
    }
}

