/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.internal.delegates;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.wst.validation.AbstractValidator;
import org.eclipse.wst.validation.internal.ResourceHandler;
import org.eclipse.wst.validation.internal.ValidationRegistryReader;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.operations.LocalizedMessage;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;

public class ValidatorDelegateDescriptor {
    private IConfigurationElement delegateConfiguration;
    private String delegatingValidatorID;
    private String id;
    private String name;

    public ValidatorDelegateDescriptor(String id, IConfigurationElement delegateConfiguration, String delegateName, String targetValidatorID) {
        this.id = id;
        this.delegateConfiguration = delegateConfiguration;
        this.name = delegateName;
        this.delegatingValidatorID = targetValidatorID;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getTargetID() {
        return this.delegatingValidatorID;
    }

    public IValidator getValidator() throws ValidationException {
        try {
            IValidator delegate = (IValidator)this.delegateConfiguration.createExecutableExtension("class");
            return delegate;
        }
        catch (CoreException coreException) {
            String delegatingValidatorName = ValidationRegistryReader.getReader().getValidatorMetaData(this.getTargetID()).getValidatorDisplayName();
            throw new ValidationException(new LocalizedMessage(1, ResourceHandler.getExternalizedMessage("VBF_CANNOT_INSTANTIATE_DELEGATE", new String[]{this.getName(), delegatingValidatorName})));
        }
    }

    public AbstractValidator getValidator2() throws ValidationException {
        try {
            Object object = this.delegateConfiguration.createExecutableExtension("class");
            if (object instanceof AbstractValidator) {
                return (AbstractValidator)object;
            }
        }
        catch (CoreException coreException) {
            String delegatingValidatorName = ValidationRegistryReader.getReader().getValidatorMetaData(this.getTargetID()).getValidatorDisplayName();
            throw new ValidationException(new LocalizedMessage(1, ResourceHandler.getExternalizedMessage("VBF_CANNOT_INSTANTIATE_DELEGATE", new String[]{this.getName(), delegatingValidatorName})));
        }
        return null;
    }
}

