/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.internal.model;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.validation.internal.ValMessages;
import org.eclipse.wst.validation.internal.model.FilterRule;

public abstract class FilterGroup
implements IAdaptable {
    List<FilterRule> _rules = new LinkedList<FilterRule>();
    FilterRule[] _rulesArray;

    public static FilterGroup create(String name) {
        if ("include".equals(name)) {
            return new FilterIncludeGroup();
        }
        if ("exclude".equals(name)) {
            return new FilterExcludeGroup();
        }
        return null;
    }

    public static FilterGroup create(boolean exclude) {
        if (exclude) {
            return new FilterExcludeGroup();
        }
        return new FilterIncludeGroup();
    }

    public void add(FilterRule fr) {
        this._rulesArray = null;
        this._rules.add(fr);
    }

    public synchronized boolean remove(FilterRule fr) {
        if (this._rules.remove(fr)) {
            this._rulesArray = null;
            return true;
        }
        return false;
    }

    public FilterRule[] getRules() {
        FilterRule[] rules = this._rulesArray;
        if (rules == null) {
            rules = new FilterRule[this._rules.size()];
            this._rules.toArray(rules);
            this._rulesArray = rules;
        }
        return rules;
    }

    public abstract String getType();

    public abstract String getDisplayableType();

    public Object getAdapter(Class adapter) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public boolean shouldValidate(IProject project, IResource resource) {
        FilterRule[] rules = this.getRules();
        boolean exclude = this.isExclude();
        boolean include = this.isInclude();
        FilterRule[] filterRuleArray = rules;
        int n = rules.length;
        int n2 = 0;
        while (n2 < n) {
            Boolean match;
            FilterRule rule = filterRuleArray[n2];
            if (resource != null) {
                match = rule.matchesResource(resource);
                if (exclude && match != null && match.booleanValue()) {
                    return false;
                }
                if (include && match != null && match.booleanValue()) {
                    return true;
                }
            }
            match = rule.matchesProject(project);
            if (exclude && match != null && match.booleanValue()) {
                return false;
            }
            if (include && match != null && match.booleanValue()) {
                return true;
            }
            ++n2;
        }
        return exclude;
    }

    protected boolean isInclude() {
        return false;
    }

    protected boolean isExclude() {
        return false;
    }

    protected abstract FilterGroup create();

    public FilterGroup copy() {
        FilterGroup fg = this.create();
        FilterRule[] rules = this.getRules();
        fg._rulesArray = new FilterRule[rules.length];
        int i = 0;
        while (i < rules.length) {
            fg._rulesArray[i] = rules[i].copy();
            fg._rules.add(fg._rulesArray[i]);
            ++i;
        }
        return fg;
    }

    public static class FilterExcludeGroup
    extends FilterGroup {
        public String getType() {
            return ValMessages.TypeExclude;
        }

        protected FilterGroup create() {
            return new FilterExcludeGroup();
        }

        public String getDisplayableType() {
            return ValMessages.GroupExclude;
        }

        protected boolean isExclude() {
            return true;
        }
    }

    public static class FilterIncludeGroup
    extends FilterGroup {
        public String getType() {
            return ValMessages.TypeInclude;
        }

        public String getDisplayableType() {
            return ValMessages.GroupInclude;
        }

        protected boolean isInclude() {
            return true;
        }

        protected FilterGroup create() {
            return new FilterIncludeGroup();
        }
    }
}

