/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.internal.model;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.project.facet.core.FacetedProjectFramework;
import org.eclipse.wst.validation.internal.ValMessages;
import org.eclipse.wst.validation.internal.plugin.ValidationPlugin;

public abstract class FilterRule
implements IAdaptable {
    protected String _pattern;

    public static FilterRule create(String name) {
        if ("fileext".equals(name)) {
            return new FileExt();
        }
        if ("projectNature".equals(name)) {
            return new ProjectNature();
        }
        if ("file".equals(name)) {
            return new File();
        }
        if ("contentType".equals(name)) {
            return new ContentType();
        }
        if ("facet".equals(name)) {
            return new Facet();
        }
        return null;
    }

    public static FilterRule createFile(String pattern, boolean caseSensitive, int type) {
        File ext = new File();
        ext.setData(pattern);
        ext.setCaseSensitive(caseSensitive);
        ext.setType(type);
        return ext;
    }

    public static FilterRule createFileExt(String pattern, boolean caseSensitive) {
        FileExt ext = new FileExt();
        ext.setData(pattern);
        ext.setCaseSensitive(caseSensitive);
        return ext;
    }

    public static FilterRule createFacet(String facetId) {
        Facet facet = new Facet();
        facet.setData(facetId);
        return facet;
    }

    public static FilterRule createProject(String projectNature) {
        ProjectNature pn = new ProjectNature();
        pn.setData(projectNature);
        return pn;
    }

    public static FilterRule createContentType(String contentType) {
        ContentType ct = new ContentType();
        ct.setData(contentType);
        return ct;
    }

    public abstract void setData(IConfigurationElement var1);

    public Boolean matchesResource(IResource resource) {
        return null;
    }

    public Boolean matchesProject(IProject project) {
        return null;
    }

    public void setData(String data) {
        this._pattern = data;
    }

    public String toString() {
        return String.valueOf(this.getDisplayableType()) + ": " + this._pattern;
    }

    public String getName() {
        return this.toString();
    }

    public String getPattern() {
        return this._pattern;
    }

    public abstract String getType();

    public abstract String getDisplayableType();

    public boolean asBoolean(String value, boolean aDefault) {
        if (value == null) {
            return aDefault;
        }
        if (value.equals("true")) {
            return true;
        }
        if (value.equals("false")) {
            return false;
        }
        return aDefault;
    }

    public Object getAdapter(Class adapter) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public abstract FilterRule copy();

    public static class ContentType
    extends FilterRule {
        public FilterRule copy() {
            ContentType rule = new ContentType();
            rule._pattern = this._pattern;
            return rule;
        }

        public String getType() {
            return "contentType";
        }

        public String getDisplayableType() {
            return ValMessages.RuleContentType;
        }

        public void setData(IConfigurationElement rule) {
            this._pattern = rule.getAttribute("id");
        }

        public Boolean matchesResource(IResource resource) {
            try {
                if (resource instanceof IFile) {
                    IFile file = (IFile)resource;
                    IContentDescription cd = file.getContentDescription();
                    if (cd == null) {
                        return Boolean.FALSE;
                    }
                    IContentType ct = cd.getContentType();
                    if (ct == null) {
                        return Boolean.FALSE;
                    }
                    return this._pattern.equals(ct.getId());
                }
            }
            catch (CoreException e) {
                ValidationPlugin.getPlugin().handleException((Exception)((Object)e));
            }
            return Boolean.FALSE;
        }
    }

    public static class Facet
    extends FilterRule {
        public FilterRule copy() {
            Facet rule = new Facet();
            rule._pattern = this._pattern;
            return rule;
        }

        public String getType() {
            return "facet";
        }

        public String getDisplayableType() {
            return ValMessages.RuleFacet;
        }

        public void setData(IConfigurationElement rule) {
            this._pattern = rule.getAttribute("id");
        }

        public Boolean matchesProject(IProject project) {
            try {
                return FacetedProjectFramework.hasProjectFacet((IProject)project, (String)this._pattern);
            }
            catch (CoreException e) {
                ValidationPlugin.getPlugin().handleException((Exception)((Object)e));
                return Boolean.FALSE;
            }
        }
    }

    public static class File
    extends FilterRule {
        private boolean _caseSensitive;
        private int _type;
        public static final int FileTypeFile = 1;
        public static final int FileTypeFolder = 2;
        public static final int FileTypeFull = 3;

        public FilterRule copy() {
            File rule = new File();
            rule._pattern = this._pattern;
            rule._caseSensitive = this._caseSensitive;
            rule._type = this._type;
            return rule;
        }

        public String getType() {
            return "file";
        }

        public String getDisplayableType() {
            return ValMessages.RuleFile;
        }

        public void setData(IConfigurationElement rule) {
            this._pattern = rule.getAttribute("name");
            if (this._pattern == null) {
                throw new IllegalStateException(ValMessages.ErrPatternAttrib);
            }
            this._caseSensitive = this.asBoolean(rule.getAttribute("caseSensitive"), false);
            String type = rule.getAttribute("type");
            if (type == null) {
                throw new IllegalStateException(ValMessages.ErrTypeReq);
            }
            if ("file".equals(type)) {
                this._type = 1;
            } else if ("folder".equals(type)) {
                this._type = 2;
            } else if ("full".equals(type)) {
                this._type = 3;
            } else {
                Object[] parms = new Object[]{type, "file", "folder", "full"};
                throw new IllegalStateException(NLS.bind((String)ValMessages.ErrType, (Object[])parms));
            }
        }

        public String toString() {
            if (this._caseSensitive) {
                return NLS.bind((String)ValMessages.FileExtWithCase, (Object)this.getDisplayableType(), (Object)this._pattern);
            }
            return NLS.bind((String)ValMessages.FileExtWithoutCase, (Object)this.getDisplayableType(), (Object)this._pattern);
        }

        public Boolean matchesResource(IResource resource) {
            String name = null;
            switch (this._type) {
                case 1: {
                    name = resource.getName();
                    break;
                }
                case 2: {
                    name = resource.getProjectRelativePath().removeLastSegments(1).toString();
                    break;
                }
                case 3: {
                    name = resource.getProjectRelativePath().toString();
                }
            }
            if (this._caseSensitive) {
                return this._pattern.equals(name);
            }
            return this._pattern.equalsIgnoreCase(name);
        }

        public void setCaseSensitive(boolean caseSensitive) {
            this._caseSensitive = caseSensitive;
        }

        public void setType(int type) {
            this._type = type;
        }
    }

    public static class FileExt
    extends FilterRule {
        private boolean _caseSensitive;

        public FilterRule copy() {
            FileExt rule = new FileExt();
            rule._pattern = this._pattern;
            rule._caseSensitive = this._caseSensitive;
            return rule;
        }

        public String getType() {
            return "fileext";
        }

        public String getDisplayableType() {
            return ValMessages.RuleFileExt;
        }

        public String getName() {
            return this.toString();
        }

        public void setData(IConfigurationElement rule) {
            this._pattern = rule.getAttribute("ext");
            this._caseSensitive = this.asBoolean(rule.getAttribute("caseSensitive"), false);
        }

        public String toString() {
            if (this._caseSensitive) {
                return NLS.bind((String)ValMessages.FileExtWithCase, (Object)this.getDisplayableType(), (Object)this._pattern);
            }
            return NLS.bind((String)ValMessages.FileExtWithoutCase, (Object)this.getDisplayableType(), (Object)this._pattern);
        }

        public Boolean matchesResource(IResource resource) {
            String ext = resource.getFileExtension();
            if (this._caseSensitive) {
                return this._pattern.equals(ext);
            }
            return this._pattern.equalsIgnoreCase(ext);
        }

        public boolean isCaseSensitive() {
            return this._caseSensitive;
        }

        public void setCaseSensitive(boolean caseSensitive) {
            this._caseSensitive = caseSensitive;
        }
    }

    public static class ProjectNature
    extends FilterRule {
        public FilterRule copy() {
            ProjectNature rule = new ProjectNature();
            rule._pattern = this._pattern;
            return rule;
        }

        public void setData(IConfigurationElement rule) {
            this._pattern = rule.getAttribute("id");
        }

        public String getDisplayableType() {
            return ValMessages.RuleProjectNature;
        }

        public String getType() {
            return "projectNature";
        }

        public Boolean matchesProject(IProject project) {
            try {
                return project.hasNature(this._pattern);
            }
            catch (CoreException coreException) {
                return Boolean.FALSE;
            }
        }
    }
}

