/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.internal.operations;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jem.util.logger.LogEntry;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.wst.validation.internal.ConfigurationManager;
import org.eclipse.wst.validation.internal.InternalValidatorManager;
import org.eclipse.wst.validation.internal.ProjectConfiguration;
import org.eclipse.wst.validation.internal.ResourceHandler;
import org.eclipse.wst.validation.internal.TimeEntry;
import org.eclipse.wst.validation.internal.ValBuilderJob;
import org.eclipse.wst.validation.internal.ValManager;
import org.eclipse.wst.validation.internal.ValOperationManager;
import org.eclipse.wst.validation.internal.ValidatorMetaData;
import org.eclipse.wst.validation.internal.operations.EnabledIncrementalValidatorsOperation;
import org.eclipse.wst.validation.internal.operations.EnabledValidatorsOperation;
import org.eclipse.wst.validation.internal.operations.IWorkbenchContext;
import org.eclipse.wst.validation.internal.operations.ValidatorManager;
import org.eclipse.wst.validation.internal.operations.WorkbenchContext;
import org.eclipse.wst.validation.internal.operations.WorkbenchReporter;
import org.eclipse.wst.validation.internal.plugin.ValidationPlugin;

public class ValidationBuilder
extends IncrementalProjectBuilder {
    public static final int NO_DELTA_CHANGE = -1;
    protected List referencedProjects;
    protected IWorkbenchContext workbenchContext = null;

    private IProject[] getAllReferencedProjects(IProject project, Set visitedProjects) {
        if (visitedProjects == null) {
            visitedProjects = new HashSet<IProject>();
        } else {
            if (visitedProjects.contains(project)) {
                return this.getReferencedProjects();
            }
            visitedProjects.add(project);
        }
        if (this.referencedProjects == null) {
            this.referencedProjects = new ArrayList();
        }
        try {
            if (project.isAccessible()) {
                IProject[] refProjArray = project.getReferencedProjects();
                this.collectReferecedProject(refProjArray);
                int i = 0;
                while (i < refProjArray.length) {
                    IProject refProject = refProjArray[i];
                    this.getAllReferencedProjects(refProject, visitedProjects);
                    ++i;
                }
            }
            return this.getReferencedProjects();
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    public IWorkbenchContext getWorkbenchContext() {
        if (this.workbenchContext == null) {
            this.workbenchContext = new WorkbenchContext();
            this.workbenchContext.setProject(this.getProject());
        }
        return this.workbenchContext;
    }

    private void collectReferecedProject(IProject[] refProjArray) {
        int i = 0;
        while (i < refProjArray.length) {
            IProject project = refProjArray[i];
            if (!this.referencedProjects.contains(project)) {
                this.referencedProjects.add(project);
            }
            ++i;
        }
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        block4: {
            this.newClean(monitor);
            IProject currentProject = this.getProject();
            if (currentProject == null || !currentProject.isAccessible()) {
                return;
            }
            try {
                ProjectConfiguration prjp = ConfigurationManager.getManager().getProjectConfiguration(currentProject);
                ValidatorMetaData[] vmds = prjp.getValidators();
                int i = 0;
                while (i < vmds.length) {
                    ValidatorMetaData vmd = vmds[i];
                    WorkbenchReporter.removeAllMessages((IResource)currentProject, vmd.getValidatorNames(), null);
                    ++i;
                }
            }
            catch (InvocationTargetException exc) {
                Logger logger = ValidationPlugin.getPlugin().getMsgLogger();
                if (!logger.isLoggingLevel(Level.SEVERE)) break block4;
                LogEntry entry = ValidationPlugin.getLogEntry();
                entry.setSourceIdentifier("ValidatorManager.updateTaskList(" + currentProject.getName() + ")");
                entry.setTargetException((Throwable)exc);
                logger.write(Level.SEVERE, (Object)entry);
                if (exc.getTargetException() == null) break block4;
                entry.setTargetException((Throwable)exc);
                logger.write(Level.SEVERE, (Object)entry);
            }
        }
    }

    private IProject[] getReferencedProjects() {
        IProject[] refProjArray = new IProject[this.referencedProjects.size()];
        int i = 0;
        while (i < this.referencedProjects.size()) {
            refProjArray[i] = (IProject)this.referencedProjects.get(i);
            ++i;
        }
        return refProjArray;
    }

    /*
     * Unable to fully structure code
     */
    public IProject[] build(int kind, Map parameters, IProgressMonitor monitor) {
        block22: {
            block23: {
                block21: {
                    block20: {
                        start = System.currentTimeMillis();
                        executionMap = 0;
                        logger = ValidationPlugin.getPlugin().getMsgLogger();
                        delta = null;
                        project = this.getProject();
                        referenced = this.getAllReferencedProjects(project, null);
                        this.newBuild(kind, parameters, monitor);
                        if (!ValidatorManager.getManager().isSuspended(project)) break block20;
                        executionMap |= 1;
                        var15_10 = referenced;
                        this.referencedProjects = null;
                        if (logger.isLoggingLevel(Level.FINE)) {
                            this.logBuilderTimeEntry(start, executionMap, logger, delta);
                        }
                        return var15_10;
                    }
                    prjp = ConfigurationManager.getManager().getProjectConfiguration(project);
                    delta = this.getDelta(project);
                    v0 = doFullBuild = kind == 6;
                    if (doFullBuild || delta != null) break block21;
                    if (this.isReferencedProjectInDelta(referenced)) {
                        this.performFullBuildForReferencedProjectChanged(monitor, prjp);
                    } else {
                        msgParms = new String[]{project.getName()};
                        monitor.subTask(ResourceHandler.getExternalizedMessage("VBF_STATUS_NULL_DELTA", msgParms));
                        executionMap |= 4;
                    }
                    var15_11 = referenced;
                    this.referencedProjects = null;
                    if (logger.isLoggingLevel(Level.FINE)) {
                        this.logBuilderTimeEntry(start, executionMap, logger, delta);
                    }
                    return var15_11;
                }
                if (!doFullBuild) break block23;
                this.performFullBuild(monitor, prjp);
                ** GOTO lbl54
            }
            if (delta.getAffectedChildren().length != 0) break block22;
            if (this.isReferencedProjectInDelta(referenced)) {
                this.performFullBuildForReferencedProjectChanged(monitor, prjp);
            } else {
                executionMap |= 16;
            }
            var15_12 = referenced;
            this.referencedProjects = null;
            if (logger.isLoggingLevel(Level.FINE)) {
                this.logBuilderTimeEntry(start, executionMap, logger, delta);
            }
            return var15_12;
        }
        try {
            operation = new EnabledIncrementalValidatorsOperation(project, delta, true);
            operation.run(monitor);
lbl54:
            // 2 sources

            var15_13 = referenced;
            this.referencedProjects = null;
        }
        catch (InvocationTargetException exc) {
            this.logInvocationTargetException(logger, exc);
            executionMap |= 32;
            var15_14 = referenced;
            this.referencedProjects = null;
            if (logger.isLoggingLevel(Level.FINE)) {
                this.logBuilderTimeEntry(start, executionMap, logger, delta);
            }
            return var15_14;
        }
        catch (Exception exc) {
            this.logBuildError(logger, exc);
            executionMap |= 64;
            var15_15 = referenced;
            this.referencedProjects = null;
            {
                catch (Throwable var14_22) {
                    this.referencedProjects = null;
                    if (logger.isLoggingLevel(Level.FINE)) {
                        this.logBuilderTimeEntry(start, executionMap, logger, delta);
                    }
                    throw var14_22;
                }
            }
            if (logger.isLoggingLevel(Level.FINE)) {
                this.logBuilderTimeEntry(start, executionMap, logger, delta);
            }
            return var15_15;
        }
        if (logger.isLoggingLevel(Level.FINE)) {
            this.logBuilderTimeEntry(start, executionMap, logger, delta);
        }
        return var15_13;
    }

    private boolean isReferencedProjectInDelta(IProject[] referenced) {
        IProject p = null;
        int i = 0;
        while (i < referenced.length) {
            p = referenced[i];
            IResourceDelta delta = this.getDelta(p);
            if (delta != null && delta.getAffectedChildren().length > 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void performFullBuildForReferencedProjectChanged(IProgressMonitor monitor, ProjectConfiguration prjp) throws InvocationTargetException {
        this.performFullBuild(monitor, prjp, true);
    }

    private void performFullBuild(IProgressMonitor monitor, ProjectConfiguration prjp) throws InvocationTargetException {
        this.performFullBuild(monitor, prjp, false);
    }

    private void performFullBuild(IProgressMonitor monitor, ProjectConfiguration prjp, boolean onlyDependentValidators) throws InvocationTargetException {
        Object[] enabledValidators = prjp.getEnabledFullBuildValidators(true, onlyDependentValidators);
        if (enabledValidators != null && enabledValidators.length > 0) {
            Set enabledValidatorsSet = InternalValidatorManager.wrapInSet(enabledValidators);
            EnabledValidatorsOperation op = new EnabledValidatorsOperation(this.getProject(), enabledValidatorsSet, true);
            op.run(monitor);
        }
    }

    private void logInvocationTargetException(Logger logger, InvocationTargetException exc) {
        if (logger.isLoggingLevel(Level.SEVERE)) {
            LogEntry entry = ValidationPlugin.getLogEntry();
            entry.setSourceID("ValidationBuilder::build");
            entry.setTargetException((Throwable)exc);
            logger.write(Level.SEVERE, (Object)entry);
            if (exc.getTargetException() != null) {
                entry.setTargetException((Throwable)exc);
                logger.write(Level.SEVERE, (Object)entry);
            }
        }
    }

    private void logBuildError(Logger logger, Throwable exc) {
        if (logger.isLoggingLevel(Level.SEVERE) && !(exc instanceof OperationCanceledException)) {
            LogEntry entry = ValidationPlugin.getLogEntry();
            entry.setSourceID("ValidationBuilder.build(int, Map, IProgressMonitor)");
            entry.setTargetException(exc);
            logger.write(Level.SEVERE, (Object)entry);
        }
    }

    private void logBuilderTimeEntry(long start, int executionMap, Logger logger, IResourceDelta delta) {
        TimeEntry entry = ValidationPlugin.getTimeEntry();
        entry.setSourceID("ValidationBuilder.build(int, Map, IProgressMonitor)");
        entry.setProjectName(this.getProject().getName());
        entry.setExecutionMap(executionMap);
        entry.setElapsedTime(System.currentTimeMillis() - start);
        if (delta == null) {
            entry.setDetails("delta == null");
        }
        entry.setToolName("ValidationBuilder");
        logger.write(Level.FINE, (Object)entry);
    }

    protected IProject[] newBuild(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        if (args == null) {
            // empty if block
        }
        IResourceDelta delta = null;
        IProject project = this.getProject();
        switch (kind) {
            case 9: 
            case 10: {
                delta = this.getDelta(project);
            }
        }
        ValBuilderJob job = new ValBuilderJob(project, delta, kind, ValOperationManager.getDefault().getOperation());
        job.schedule();
        return null;
    }

    protected void newClean(IProgressMonitor monitor) throws CoreException {
        ValManager.getDefault().clean(this.getProject(), monitor);
    }
}

