/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.internal.operations;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jem.util.logger.LogEntry;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.wst.common.frameworks.internal.operations.IHeadlessRunnableWithProgress;
import org.eclipse.wst.validation.internal.FilterUtil;
import org.eclipse.wst.validation.internal.IProjectValidationHelper;
import org.eclipse.wst.validation.internal.InternalValidatorManager;
import org.eclipse.wst.validation.internal.ReferencialFileValidatorRegistryReader;
import org.eclipse.wst.validation.internal.ResourceHandler;
import org.eclipse.wst.validation.internal.TaskListUtility;
import org.eclipse.wst.validation.internal.TimeEntry;
import org.eclipse.wst.validation.internal.ValidationRegistryReader;
import org.eclipse.wst.validation.internal.ValidatorMetaData;
import org.eclipse.wst.validation.internal.core.IFileDelta;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.core.ValidatorLauncher;
import org.eclipse.wst.validation.internal.operations.IWorkbenchContext;
import org.eclipse.wst.validation.internal.operations.MessageInfo;
import org.eclipse.wst.validation.internal.operations.ReferencialFileValidator;
import org.eclipse.wst.validation.internal.operations.ReferencialFileValidatorHelper;
import org.eclipse.wst.validation.internal.operations.ValidatorJob;
import org.eclipse.wst.validation.internal.operations.ValidatorManager;
import org.eclipse.wst.validation.internal.operations.WorkbenchContext;
import org.eclipse.wst.validation.internal.operations.WorkbenchFileDelta;
import org.eclipse.wst.validation.internal.operations.WorkbenchReporter;
import org.eclipse.wst.validation.internal.plugin.ValidationHelperRegistryReader;
import org.eclipse.wst.validation.internal.plugin.ValidationPlugin;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;
import org.eclipse.wst.validation.internal.provisional.core.IValidatorJob;
import org.eclipse.wst.validation.internal.provisional.core.MessageLimitException;

public abstract class ValidationOperation
implements IWorkspaceRunnable,
IHeadlessRunnableWithProgress {
    public static final int NO_DELTA_CHANGE = -1;
    private static final String DELTA_AS_STRING = "IFileDelta[{0}] '{'{1}'}'";
    private static final String COMMA = ", ";
    protected static final boolean DEFAULT_ASYNC = true;
    protected static final boolean DEFAULT_FORCE = true;
    protected static final boolean DEFAULT_FORK = false;
    private IProject _project = null;
    private int _ruleGroup = 1;
    private boolean _fork = true;
    private Map _fileDeltas = null;
    private IResourceDelta _delta = null;
    private Set _enabledValidators = null;
    private boolean _force = true;
    private boolean _isFullValidate = false;
    private Boolean _isAutoBuild = null;
    private Set _launchedValidators = null;
    protected IWorkbenchContext context;

    private static final String getDeltaAsString(IFileDelta[] delta) {
        String args = "";
        int numArgs = 0;
        if (delta != null) {
            numArgs = delta.length;
            StringBuffer buffer = new StringBuffer();
            int i = 0;
            while (i < delta.length) {
                buffer.append(COMMA);
                buffer.append(delta[i].toString());
                ++i;
            }
            buffer.replace(0, 1, "");
            args = buffer.toString();
        }
        return MessageFormat.format(DELTA_AS_STRING, String.valueOf(numArgs), args);
    }

    protected static void checkCanceled(WorkbenchReporter reporter) throws OperationCanceledException {
        if (reporter == null) {
            return;
        }
        if (reporter.getProgressMonitor().isCanceled()) {
            throw new OperationCanceledException("");
        }
    }

    protected static boolean shouldForce(IResourceDelta delta) {
        return delta == null;
    }

    protected static boolean shouldForce(Object[] changedResources) {
        return changedResources == null || changedResources.length == 0;
    }

    public ValidationOperation(IProject project) {
        this(project, true, true);
    }

    public ValidationOperation(IProject project, boolean force, boolean async) {
        this(project, null, null, 1, force, async);
    }

    public ValidationOperation(IProject project, int ruleGroup) {
        this(project, null, null, ruleGroup, true, true);
    }

    public ValidationOperation(IProject project, IResourceDelta delta, boolean isAutoBuild, int ruleGroup, boolean force, boolean fork) {
        this(project, delta, isAutoBuild ? Boolean.TRUE : Boolean.FALSE, ruleGroup, fork, force);
    }

    protected ValidationOperation(IProject project, IResourceDelta delta, Boolean isAutoBuild, int ruleGroup, boolean force, boolean fork) {
        this._project = project;
        this._delta = delta;
        this._isAutoBuild = isAutoBuild;
        this._ruleGroup = ruleGroup;
        this._fork = fork;
        this._force = force;
        this._enabledValidators = new HashSet();
    }

    protected ValidationOperation(IProject project, IWorkbenchContext aContext, IResourceDelta delta, Boolean isAutoBuild, int ruleGroup, boolean force, boolean fork) {
        this._project = project;
        this._delta = delta;
        this._isAutoBuild = isAutoBuild;
        this._ruleGroup = ruleGroup;
        this._fork = fork;
        this._force = force;
        this._enabledValidators = new HashSet();
        this.context = aContext;
    }

    protected void terminateCleanup(WorkbenchReporter reporter) {
        Set enabledValidators = this.getEnabledValidators();
        Iterator iterator = enabledValidators.iterator();
        ValidatorMetaData vmd = null;
        while (iterator.hasNext()) {
            vmd = (ValidatorMetaData)iterator.next();
            reporter.displaySubtask(ResourceHandler.getExternalizedMessage("VBF_STATUS_VALIDATOR_CLEANUP", new String[]{vmd.getValidatorDisplayName()}));
            try {
                reporter.removeAllMessages(vmd.getValidator());
            }
            catch (InstantiationException exc) {
                ValidationRegistryReader.getReader().disableValidator(vmd);
                Logger logger = ValidationPlugin.getPlugin().getMsgLogger();
                if (!logger.isLoggingLevel(Level.SEVERE)) continue;
                LogEntry entry = ValidationPlugin.getLogEntry();
                entry.setSourceID("ValidationOperation::terminateCleanup");
                entry.setTargetException((Throwable)exc);
                logger.write(Level.SEVERE, (Object)entry);
                continue;
            }
            this.addCancelTask(vmd);
            reporter.displaySubtask(ResourceHandler.getExternalizedMessage("VBF_STATUS_VALIDATOR_TERMINATED", new String[]{this.getProject().getName(), vmd.getValidatorDisplayName()}));
        }
    }

    public boolean isFork() {
        return this._fork;
    }

    public boolean isForce() {
        return this._force;
    }

    public void setForce(boolean force) {
        this._force = force;
    }

    public boolean isAutoBuild() {
        if (this._isAutoBuild == null) {
            return ValidatorManager.getManager().isGlobalAutoBuildEnabled();
        }
        return this._isAutoBuild;
    }

    protected void setAutoBuild(boolean autoOn) {
        this._isAutoBuild = autoOn ? Boolean.TRUE : Boolean.FALSE;
    }

    protected boolean isFullValidate() {
        return this._isFullValidate;
    }

    private void setFullValidate(boolean b) {
        this._isFullValidate = b;
    }

    protected int getRuleGroup() {
        return this._ruleGroup;
    }

    private boolean isValidationNecessary(ValidatorMetaData vmd, IFileDelta[] delta) {
        boolean hasFiles;
        boolean autoValidateRan = false;
        if (this._isAutoBuild != null) {
            autoValidateRan = ValidatorManager.getManager().isAutoValidate(this.getProject(), this._isAutoBuild) && vmd.isIncremental();
        }
        boolean bl = hasFiles = this.isFullValidate() || delta.length > 0;
        return !autoValidateRan && hasFiles;
    }

    public boolean isNecessary(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        Set enabledValidators = this.getEnabledValidators();
        if (enabledValidators == null || enabledValidators.size() == 0) {
            return false;
        }
        if (this.isFullValidate()) {
            return true;
        }
        for (ValidatorMetaData vmd : enabledValidators) {
            if (!this.isValidationNecessary(vmd, this.getFileDeltas(monitor, vmd))) continue;
            return true;
        }
        return false;
    }

    private Map getFileDeltas(IProgressMonitor monitor) throws CoreException {
        if (this._fileDeltas == null) {
            this.loadFileDeltas(monitor);
        }
        return this._fileDeltas;
    }

    private IFileDelta[] getFileDeltas(IProgressMonitor monitor, ValidatorMetaData vmd) throws CoreException {
        Set result = (Set)this.getFileDeltas(monitor).get(vmd);
        if (result == null) {
            return new IFileDelta[0];
        }
        IFileDelta[] temp = new IFileDelta[result.size()];
        result.toArray(temp);
        return temp;
    }

    private void loadFileDeltas(IProgressMonitor monitor) throws CoreException {
        this.setFullValidate(this.getDelta() == null && this._fileDeltas == null);
        this._fileDeltas = this.isFullValidate() ? FilterUtil.loadDeltas(monitor, this.getEnabledValidators(), this.getProject()) : FilterUtil.loadDeltas(monitor, this.getEnabledValidators(), this.getDelta());
    }

    protected void setFileDeltas(Map deltas) {
        this._fileDeltas = deltas;
    }

    protected IResourceDelta getDelta() {
        return this._delta;
    }

    protected void setDelta(IResourceDelta delta) {
        this._delta = delta;
    }

    protected boolean areValidatorsEnabled() {
        return this.getEnabledValidators().size() != 0;
    }

    public Set getEnabledValidators() {
        return this._enabledValidators;
    }

    public Set getLaunchedValidators() {
        if (this._launchedValidators == null) {
            this._launchedValidators = new HashSet();
        }
        return this._launchedValidators;
    }

    protected void setEnabledValidators(Set evmds) {
        this._enabledValidators.clear();
        for (ValidatorMetaData vmd : evmds) {
            if (!ValidationRegistryReader.getReader().isConfiguredOnProject(vmd, this.getProject())) continue;
            this._enabledValidators.add(vmd);
        }
    }

    public IProject getProject() {
        return this._project;
    }

    protected int getUnitsOfWork() {
        return -1;
    }

    protected void addCancelTask(ValidatorMetaData vmd) {
        InternalValidatorManager.getManager().addOperationTask(this.getProject(), vmd, "VBF_STATUS_VALIDATOR_TERMINATED", new String[]{this.getProject().getName(), vmd.getValidatorDisplayName()});
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(IProgressMonitor progressMonitor) throws OperationCanceledException {
        long start = System.currentTimeMillis();
        Logger logger = ValidationPlugin.getPlugin().getMsgLogger();
        try {
            if (progressMonitor == null) {
                return;
            }
            if (ValidatorManager.getManager().isSuspended(this.getProject())) {
                return;
            }
            if (!this.areValidatorsEnabled()) {
                return;
            }
            WorkbenchReporter reporter = new WorkbenchReporter(this.getProject(), progressMonitor);
            try {
                ValidationOperation.checkCanceled(reporter);
                this.preValidate(reporter);
                this.validate(reporter);
                this.validateReferencialFiles(reporter);
                return;
            }
            catch (CoreException exc) {
                if (!logger.isLoggingLevel(Level.SEVERE)) return;
                LogEntry entry = ValidationPlugin.getLogEntry();
                entry.setSourceID("ValidationOperation.run");
                entry.setTargetException((Throwable)exc);
                logger.write(Level.SEVERE, (Object)entry);
                return;
            }
        }
        finally {
            if (logger.isLoggingLevel(Level.FINE)) {
                long finish = System.currentTimeMillis();
                TimeEntry entry = ValidationPlugin.getTimeEntry();
                entry.setSourceID("ValidationOperation.run(WorkbenchMonitor)");
                entry.setProjectName(this.getProject().getName());
                entry.setToolName("ValidationOperation");
                entry.setElapsedTime(finish - start);
                logger.write(Level.FINE, (Object)entry);
            }
        }
    }

    private void validateReferencialFiles(WorkbenchReporter reporter) {
        ReferencialFileValidatorRegistryReader reader = ReferencialFileValidatorRegistryReader.getInstance();
        if (reader != null) {
            reader.readRegistry();
            ReferencialFileValidator refFileValidator = reader.getReferencialFileValidator();
            if (refFileValidator != null) {
                if (this._delta != null) {
                    this.refFileValidateFileDelta(reporter, refFileValidator);
                } else if (this._project != null) {
                    this.postValidateProject(reporter, refFileValidator);
                }
            }
        }
    }

    private void refFileValidateFileDelta(WorkbenchReporter reporter, ReferencialFileValidator refFileValidator) {
        IResourceDelta[] resourceDelta = this._delta.getAffectedChildren(7);
        ArrayList<IResource> inputFiles = new ArrayList<IResource>();
        ArrayList referencingFiles = new ArrayList();
        if (resourceDelta != null && resourceDelta.length > 0) {
            int i = 0;
            while (i < resourceDelta.length) {
                IResource resource = resourceDelta[i].getResource();
                if (resource instanceof IFolder) {
                    this.getFileResourceDeltaInFolder(resourceDelta[i], inputFiles);
                } else if (resource instanceof IFile) {
                    inputFiles.add(resource);
                }
                ++i;
            }
            List rFilesToValidate = refFileValidator.getReferencedFile(inputFiles);
            if (rFilesToValidate != null && !rFilesToValidate.isEmpty()) {
                referencingFiles.addAll(rFilesToValidate);
            }
            try {
                if (!referencingFiles.isEmpty()) {
                    this.validateReferencingFiles(reporter, referencingFiles);
                }
            }
            catch (Exception e) {
                Logger.getLogger().log((Throwable)e);
            }
        }
    }

    private void getFileResourceDeltaInFolder(IResourceDelta delta, List inputFiles) {
        IResourceDelta[] resourceDelta = delta.getAffectedChildren();
        int i = 0;
        while (i < resourceDelta.length) {
            IResource resource = resourceDelta[i].getResource();
            if (resource instanceof IFile) {
                inputFiles.add(resource);
            } else if (resource instanceof IFolder) {
                this.getFileResourceDeltaInFolder(resourceDelta[i], inputFiles);
            }
            ++i;
        }
    }

    private void postValidateProject(WorkbenchReporter reporter, ReferencialFileValidator refFileValidator) {
        Set set = ValidationRegistryReader.getReader().getValidatorMetaData(this._project);
        for (ValidatorMetaData data : set) {
            List filters = data.getNameFilters();
            List files = this.getAllFilesForFilter(filters);
            if (files.isEmpty()) continue;
            List fileForValidation = refFileValidator.getReferencedFile(files);
            try {
                this.validateReferencingFiles(reporter, fileForValidation);
            }
            catch (Exception e) {
                Logger.getLogger().log((Throwable)e);
            }
        }
    }

    private List getAllFilesForFilter(List filters) {
        if (!filters.isEmpty()) {
            List allProjectFiles = ReferencialFileValidatorHelper.getAllProjectFiles(this._project);
            ArrayList<IFile> filterFiles = new ArrayList<IFile>();
            int i = 0;
            while (i < filters.size()) {
                String fileName = (String)filters.get(i);
                if (fileName != null) {
                    int j = 0;
                    while (j < allProjectFiles.size()) {
                        IFile projectFile = (IFile)allProjectFiles.get(j);
                        if (fileName.charAt(0) == '*') {
                            String extName = fileName.substring(2, fileName.length());
                            String ext = projectFile.getFileExtension();
                            if (ext != null && ext.equals(extName)) {
                                filterFiles.add(projectFile);
                            }
                        } else if (fileName.equals(projectFile.getName())) {
                            filterFiles.add(projectFile);
                        }
                        ++j;
                    }
                }
                ++i;
            }
            return filterFiles;
        }
        return Collections.EMPTY_LIST;
    }

    private void validateReferencingFiles(IReporter reporter, List referencingFiles) throws Exception {
        HashSet<IFile> validatedFiles = new HashSet<IFile>();
        int i = 0;
        while (i < referencingFiles.size()) {
            IFile refFile = (IFile)referencingFiles.get(i);
            if (!validatedFiles.contains(refFile)) {
                IContainer resource = refFile.getParent();
                IProject project = null;
                project = resource != null && !(resource instanceof IProject) ? this.getProjectContainer((IResource)resource) : (IProject)resource;
                if (project != null) {
                    Set set = ValidationRegistryReader.getReader().getValidatorMetaData(project);
                    for (ValidatorMetaData data : set) {
                        if (!data.isApplicableTo((IResource)refFile)) continue;
                        IValidator validator = data.getValidator();
                        validator.validate(data.getHelper(project), reporter);
                        validatedFiles.add(refFile);
                    }
                }
            }
            ++i;
        }
    }

    private IProject getProjectContainer(IResource resource) {
        IContainer pResource = resource.getParent();
        if (!(pResource instanceof IProject)) {
            return this.getProjectContainer((IResource)pResource);
        }
        return (IProject)pResource;
    }

    protected void preValidate(WorkbenchReporter reporter) throws CoreException, OperationCanceledException {
        this.getFileDeltas(reporter.getProgressMonitor());
    }

    protected void validate(WorkbenchReporter reporter) throws OperationCanceledException {
        if (reporter == null) {
            return;
        }
        ValidationOperation.checkCanceled(reporter);
        reporter.getProgressMonitor().beginTask(ResourceHandler.getExternalizedMessage("VBF_STATUS_PROGRESSMONITOR_TITLE"), this.getUnitsOfWork());
        IValidator validator = null;
        ValidatorMetaData vmd2 = null;
        Iterator iterator = null;
        Logger logger = ValidationPlugin.getPlugin().getMsgLogger();
        IFileDelta[] delta = null;
        HashSet<ValidatorMetaData> jobValidators = new HashSet<ValidatorMetaData>();
        HashSet<ValidatorMetaData> validators = new HashSet<ValidatorMetaData>();
        iterator = this.getEnabledValidators().iterator();
        while (iterator.hasNext()) {
            IValidator valInstance;
            block25: {
                vmd2 = (ValidatorMetaData)iterator.next();
                valInstance = null;
                try {
                    valInstance = vmd2.getValidator();
                }
                catch (InstantiationException e1) {
                    if (ValidatorManager.getManager().getProblemValidators().contains(vmd2)) break block25;
                    ValidatorManager.getManager().getProblemValidators().add(vmd2);
                    System.out.println(e1.getMessage());
                }
            }
            if (this.isFork() && valInstance != null && valInstance instanceof IValidatorJob) {
                boolean willRun;
                try {
                    delta = this.getFileDeltas(reporter.getProgressMonitor(), vmd2);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                boolean bl = willRun = this.isForce() || this.isValidationNecessary(vmd2, delta);
                if (!willRun) continue;
                jobValidators.add(vmd2);
                continue;
            }
            if (valInstance == null) continue;
            validators.add(vmd2);
        }
        if (jobValidators.size() > 0) {
            this.launchJobs(jobValidators, reporter);
        }
        try {
            try {
                for (ValidatorMetaData vmd2 : validators) {
                    LogEntry entry;
                    block26: {
                        try {
                            boolean willRun;
                            delta = this.getFileDeltas(reporter.getProgressMonitor(), vmd2);
                            boolean bl = willRun = this.isForce() || this.isValidationNecessary(vmd2, delta);
                            if (logger.isLoggingLevel(Level.FINEST)) {
                                entry = ValidationPlugin.getTimeEntry();
                                entry.setSourceID("ValidationOperation.validate(WorkbenchReporter)");
                                entry.setProjectName(this.getProject().getName());
                                entry.setToolName(vmd2.getValidatorUniqueName());
                                entry.setElapsedTime(0L);
                                StringBuffer buffer = new StringBuffer();
                                buffer.append("will run? ");
                                buffer.append(willRun);
                                buffer.append("  ");
                                buffer.append("is force? ");
                                buffer.append(this.isForce());
                                buffer.append("  ");
                                buffer.append("isAutoBuild? ");
                                buffer.append(this._isAutoBuild);
                                buffer.append("  ");
                                buffer.append("isAutoValidate? ");
                                boolean autoBuild = this._isAutoBuild == null ? ValidatorManager.getManager().isGlobalAutoBuildEnabled() : this._isAutoBuild.booleanValue();
                                buffer.append(ValidatorManager.getManager().isAutoValidate(this.getProject(), autoBuild));
                                buffer.append("  ");
                                buffer.append("isIncremental? ");
                                buffer.append(vmd2.isIncremental());
                                buffer.append("  ");
                                if (this.isFullValidate()) {
                                    buffer.append("EVERYTHING");
                                } else if (delta.length == 0) {
                                    buffer.append("NOTHING");
                                } else {
                                    buffer.append(ValidationOperation.getDeltaAsString(delta));
                                }
                                entry.setDetails(buffer.toString());
                                logger.write(Level.FINEST, (Object)entry);
                            }
                            if (!willRun) {
                            }
                            break block26;
                        }
                        catch (CoreException exc) {
                            if (logger.isLoggingLevel(Level.SEVERE)) {
                                entry = ValidationPlugin.getLogEntry();
                                entry.setSourceID("ValidationOperation.validate(WorkbenchReporter)");
                                entry.setTargetException((Throwable)exc);
                                logger.write(Level.SEVERE, (Object)entry);
                            }
                            String mssg = ResourceHandler.getExternalizedMessage("VBF_STATUS_ENDING_VALIDATION_ABNORMALLY", new String[]{this.getProject().getName(), vmd2.getValidatorDisplayName()});
                            reporter.displaySubtask(mssg);
                        }
                        continue;
                    }
                    try {
                        this.context = vmd2.getHelper(this.getProject());
                        this.initValidateContext(delta);
                        validator = vmd2.getValidator();
                        ValidationOperation.checkCanceled(reporter);
                    }
                    catch (InstantiationException exc) {
                        ValidationRegistryReader.getReader().disableValidator(vmd2);
                        if (!logger.isLoggingLevel(Level.SEVERE)) continue;
                        entry = ValidationPlugin.getLogEntry();
                        entry.setSourceID("ValidationOperation::validate(WorkbenchReporter)");
                        entry.setTargetException((Throwable)exc);
                        logger.write(Level.SEVERE, (Object)entry);
                        continue;
                    }
                    this.internalValidate(reporter, validator, vmd2, this.context, delta);
                }
            }
            catch (OperationCanceledException exc) {
                this.handleOperationCancelledValidateException(reporter, validator, vmd2, iterator, logger, exc);
                this.releaseCachedMaps();
            }
        }
        finally {
            this.releaseCachedMaps();
        }
    }

    private void releaseCachedMaps() {
        IProjectValidationHelper helper;
        if (ValidationRegistryReader.getReader().projectValidationMetaData != null) {
            ValidationRegistryReader.getReader().projectValidationMetaData.clear();
            ValidationRegistryReader.getReader().projectValidationMetaData = null;
        }
        if ((helper = ValidationHelperRegistryReader.getInstance().getValidationHelper()) != null) {
            helper.disposeInstance();
        }
    }

    private void initValidateContext(IFileDelta[] delta) {
        if (this.context instanceof WorkbenchContext) {
            ((WorkbenchContext)this.context).setValidationFileURIs(new ArrayList());
            int i = 0;
            while (i < delta.length) {
                IFileDelta file = delta[i];
                if (file.getDeltaType() != 3) {
                    ((WorkbenchContext)this.context).getValidationFileURIs().add(file.getFileName());
                }
                ++i;
            }
        }
    }

    private void handleOperationCancelledValidateException(WorkbenchReporter reporter, IValidator validator, ValidatorMetaData vmd, Iterator iterator, Logger logger, OperationCanceledException exc) {
        reporter.displaySubtask(ResourceHandler.getExternalizedMessage("VBF_STATUS_VALIDATOR_CLEANUP", new String[]{vmd.getValidatorDisplayName()}));
        reporter.removeAllMessages(validator);
        this.addCancelTask(vmd);
        reporter.displaySubtask(ResourceHandler.getExternalizedMessage("VBF_STATUS_VALIDATOR_TERMINATED", new String[]{this.getProject().getName(), vmd.getValidatorDisplayName()}));
        while (iterator.hasNext()) {
            vmd = (ValidatorMetaData)iterator.next();
            try {
                validator = vmd.getValidator();
            }
            catch (InstantiationException exc2) {
                ValidationRegistryReader.getReader().disableValidator(vmd);
                if (!logger.isLoggingLevel(Level.SEVERE)) continue;
                LogEntry entry = ValidationPlugin.getLogEntry();
                entry.setSourceID("ValidationOperation::validate(WorkbenchReporter)");
                entry.setTargetException((Throwable)exc2);
                logger.write(Level.SEVERE, (Object)entry);
                continue;
            }
            reporter.displaySubtask(ResourceHandler.getExternalizedMessage("VBF_STATUS_VALIDATOR_CLEANUP", new String[]{vmd.getValidatorDisplayName()}));
            reporter.removeAllMessages(validator);
            this.addCancelTask(vmd);
            reporter.displaySubtask(ResourceHandler.getExternalizedMessage("VBF_STATUS_VALIDATOR_TERMINATED", new String[]{this.getProject().getName(), vmd.getValidatorDisplayName()}));
        }
        throw exc;
    }

    void internalValidate(WorkbenchReporter reporter, IValidator validator, ValidatorMetaData vmd, IWorkbenchContext aContext, IFileDelta[] delta) throws OperationCanceledException {
        Logger logger = ValidationPlugin.getPlugin().getMsgLogger();
        try {
            try {
                ValidationOperation.checkCanceled(reporter);
                this.removeOldMessages(reporter, validator, vmd, delta);
                this.launchValidator(reporter, validator, vmd, aContext, delta);
            }
            catch (OperationCanceledException exc) {
                throw exc;
            }
            catch (Exception exc) {
                if (logger.isLoggingLevel(Level.SEVERE)) {
                    LogEntry entry = ValidationPlugin.getLogEntry();
                    entry.setSourceID("ValidationOperation.internalValidate");
                    entry.setTargetException((Throwable)exc);
                    logger.write(Level.SEVERE, (Object)entry);
                }
                String mssg = ResourceHandler.getExternalizedMessage("VBF_STATUS_ENDING_VALIDATION_ABNORMALLY", new String[]{this.getProject().getName(), vmd.getValidatorDisplayName()});
                reporter.displaySubtask(mssg);
                reporter.getProgressMonitor().done();
            }
        }
        finally {
            reporter.getProgressMonitor().done();
        }
    }

    private final void removeOldMessages(WorkbenchReporter reporter, IValidator validator, ValidatorMetaData vmd, IFileDelta[] delta) {
        if (reporter == null) {
            return;
        }
        InternalValidatorManager.getManager().removeOperationTasks(this.getProject(), vmd);
        ValidationOperation.checkCanceled(reporter);
        Logger logger = ValidationPlugin.getPlugin().getMsgLogger();
        try {
            if (this.isFullValidate()) {
                String message = ResourceHandler.getExternalizedMessage("VBF_STATUS_START_REMOVING_OLD_MESSAGES", new String[]{vmd.getValidatorDisplayName(), this.getProject().getName()});
                reporter.displaySubtask(message);
                reporter.removeAllMessages(validator);
                message = ResourceHandler.getExternalizedMessage("VBF_STATUS_FINISH_REMOVING_OLD_MESSAGES", new String[]{this.getProject().getName(), vmd.getValidatorDisplayName()});
                reporter.displaySubtask(message);
            } else {
                String message = ResourceHandler.getExternalizedMessage("VBF_STATUS_START_REMOVING_OLD_MESSAGES", new String[]{vmd.getValidatorDisplayName(), this.getProject().getName()});
                reporter.displaySubtask(message);
                int i = 0;
                while (i < delta.length) {
                    WorkbenchFileDelta fd = (WorkbenchFileDelta)delta[i];
                    if (fd.getDeltaType() != 3) {
                        IResource resource = reporter.getMessageResource(validator, fd);
                        if (fd.getObject().equals(fd.getResource())) {
                            WorkbenchReporter.removeAllMessages(resource, validator);
                        } else {
                            reporter.removeAllMessages(validator, fd.getObject());
                        }
                    }
                    ++i;
                }
                message = ResourceHandler.getExternalizedMessage("VBF_STATUS_FINISH_REMOVING_OLD_MESSAGES", new String[]{this.getProject().getName(), vmd.getValidatorDisplayName()});
                reporter.displaySubtask(message);
            }
        }
        catch (OperationCanceledException exc) {
            throw exc;
        }
        catch (Exception exc) {
            if (logger.isLoggingLevel(Level.SEVERE)) {
                LogEntry entry = ValidationPlugin.getLogEntry();
                entry.setSourceID("ValidationOperation.validate(WorkbenchMonitor)");
                entry.setTargetException((Throwable)exc);
                logger.write(Level.SEVERE, (Object)entry);
            }
            String mssg = ResourceHandler.getExternalizedMessage("VBF_STATUS_ENDING_VALIDATION_ABNORMALLY", new String[]{this.getProject().getName(), vmd.getValidatorDisplayName()});
            reporter.displaySubtask(mssg);
            return;
        }
    }

    private final void launchValidator(WorkbenchReporter reporter, IValidator validator, ValidatorMetaData vmd, IWorkbenchContext helper, IFileDelta[] delta) {
        block77: {
            if (reporter == null) {
                return;
            }
            ValidationOperation.checkCanceled(reporter);
            Logger logger = ValidationPlugin.getPlugin().getMsgLogger();
            try {
                if (helper instanceof WorkbenchContext) {
                    ((WorkbenchContext)helper).setRuleGroup(this.getRuleGroup());
                }
                long start = System.currentTimeMillis();
                String message = ResourceHandler.getExternalizedMessage("VBF_STATUS_STARTING_VALIDATION", new String[]{this.getProject().getName(), vmd.getValidatorDisplayName()});
                reporter.displaySubtask(message);
                if (logger.isLoggingLevel(Level.FINEST)) {
                    this.getLaunchedValidators().add(vmd);
                }
                ValidatorLauncher.getLauncher().start(helper, validator, reporter);
                long finish = System.currentTimeMillis();
                if (logger.isLoggingLevel(Level.INFO)) {
                    TimeEntry entry = ValidationPlugin.getTimeEntry();
                    entry.setSourceID("ValidationOperation.launchValidator");
                    entry.setProjectName(this.getProject().getName());
                    entry.setToolName(vmd.getValidatorUniqueName());
                    entry.setElapsedTime(finish - start);
                    if (logger.isLoggingLevel(Level.FINE)) {
                        StringBuffer buffer = new StringBuffer();
                        if (this.isFullValidate()) {
                            buffer.append("EVERYTHING");
                        } else if (delta.length == 0) {
                            buffer.append("NOTHING");
                        } else {
                            buffer.append(ValidationOperation.getDeltaAsString(delta));
                        }
                        entry.setDetails(buffer.toString());
                    }
                    logger.write(Level.INFO, (Object)entry);
                }
                message = ResourceHandler.getExternalizedMessage("VBF_STATUS_ENDING_VALIDATION", new String[]{this.getProject().getName(), vmd.getValidatorDisplayName()});
                reporter.displaySubtask(message);
            }
            catch (MessageLimitException exc) {
                throw exc;
            }
            catch (OperationCanceledException exc) {
                throw exc;
            }
            catch (ValidationException exc) {
                if (exc.getAssociatedException() != null) {
                    if (exc.getAssociatedException() instanceof MessageLimitException) {
                        MessageLimitException mssgExc = (MessageLimitException)exc.getAssociatedException();
                        throw mssgExc;
                    }
                    if (exc.getAssociatedException() instanceof ValidationException) {
                        ValidationException vexc = (ValidationException)exc.getAssociatedException();
                        vexc.setClassLoader(validator.getClass().getClassLoader());
                    }
                }
                exc.setClassLoader(validator.getClass().getClassLoader());
                if (logger.isLoggingLevel(Level.SEVERE)) {
                    LogEntry entry = ValidationPlugin.getLogEntry();
                    entry.setSourceID("ValidationOperation.validate(WorkbenchMonitor)");
                    entry.setTargetException((Throwable)exc);
                    logger.write(Level.SEVERE, (Object)entry);
                    if (exc.getAssociatedException() != null) {
                        entry.setTargetException(exc.getAssociatedException());
                        logger.write(Level.SEVERE, (Object)entry);
                    }
                }
                String message = ResourceHandler.getExternalizedMessage("VBF_STATUS_ENDING_VALIDATION_ABNORMALLY", new String[]{this.getProject().getName(), vmd.getValidatorDisplayName()});
                reporter.displaySubtask(message);
                if (exc.getAssociatedMessage() != null) {
                    reporter.addMessage(validator, exc.getAssociatedMessage());
                }
                try {
                    validator.cleanup(reporter);
                }
                catch (MessageLimitException e) {
                    throw e;
                }
                catch (OperationCanceledException e) {
                    throw e;
                }
                catch (Exception exc2) {
                    if (logger.isLoggingLevel(Level.SEVERE)) {
                        LogEntry entry = ValidationPlugin.getLogEntry();
                        entry.setSourceID("ValidationOperation::launchValidator");
                        entry.setTargetException((Throwable)exc2);
                        logger.write(Level.SEVERE, (Object)entry);
                    }
                    return;
                }
                try {
                    try {
                        helper.cleanup(reporter);
                    }
                    catch (MessageLimitException e) {
                        throw e;
                    }
                    catch (OperationCanceledException e) {
                        throw e;
                    }
                    catch (Exception exc3) {
                        if (logger.isLoggingLevel(Level.SEVERE)) {
                            LogEntry entry = ValidationPlugin.getLogEntry();
                            entry.setSourceID("ValidationOperation::launchValidator");
                            entry.setTargetException((Throwable)exc3);
                            logger.write(Level.SEVERE, (Object)entry);
                        }
                        helper.setProject(null);
                        return;
                    }
                }
                finally {
                    helper.setProject(null);
                }
                reporter.getProgressMonitor().worked(delta == null ? 1 : delta.length);
                break block77;
            }
            catch (Exception exc) {
                try {
                    if (logger.isLoggingLevel(Level.SEVERE)) {
                        LogEntry entry = ValidationPlugin.getLogEntry();
                        entry.setSourceID("ValidationOperation.validate(WorkbenchMonitor)");
                        entry.setTargetException((Throwable)exc);
                        logger.write(Level.SEVERE, (Object)entry);
                    }
                    String mssg = ResourceHandler.getExternalizedMessage("VBF_STATUS_ENDING_VALIDATION_ABNORMALLY", new String[]{this.getProject().getName(), vmd.getValidatorDisplayName()});
                    reporter.displaySubtask(mssg);
                }
                catch (Throwable throwable) {
                    try {
                        validator.cleanup(reporter);
                    }
                    catch (MessageLimitException e) {
                        throw e;
                    }
                    catch (OperationCanceledException e) {
                        throw e;
                    }
                    catch (Exception exc4) {
                        if (logger.isLoggingLevel(Level.SEVERE)) {
                            LogEntry entry = ValidationPlugin.getLogEntry();
                            entry.setSourceID("ValidationOperation::launchValidator");
                            entry.setTargetException((Throwable)exc4);
                            logger.write(Level.SEVERE, (Object)entry);
                        }
                        return;
                    }
                    try {
                        try {
                            helper.cleanup(reporter);
                        }
                        catch (MessageLimitException e) {
                            throw e;
                        }
                        catch (OperationCanceledException e) {
                            throw e;
                        }
                        catch (Exception exc5) {
                            if (logger.isLoggingLevel(Level.SEVERE)) {
                                LogEntry entry = ValidationPlugin.getLogEntry();
                                entry.setSourceID("ValidationOperation::launchValidator");
                                entry.setTargetException((Throwable)exc5);
                                logger.write(Level.SEVERE, (Object)entry);
                            }
                            helper.setProject(null);
                            return;
                        }
                    }
                    finally {
                        helper.setProject(null);
                    }
                    reporter.getProgressMonitor().worked(delta == null ? 1 : delta.length);
                    throw throwable;
                }
                try {
                    validator.cleanup(reporter);
                }
                catch (MessageLimitException e) {
                    throw e;
                }
                catch (OperationCanceledException e) {
                    throw e;
                }
                catch (Exception exc6) {
                    if (logger.isLoggingLevel(Level.SEVERE)) {
                        LogEntry entry = ValidationPlugin.getLogEntry();
                        entry.setSourceID("ValidationOperation::launchValidator");
                        entry.setTargetException((Throwable)exc6);
                        logger.write(Level.SEVERE, (Object)entry);
                    }
                    return;
                }
                try {
                    try {
                        helper.cleanup(reporter);
                    }
                    catch (MessageLimitException e) {
                        throw e;
                    }
                    catch (OperationCanceledException e) {
                        throw e;
                    }
                    catch (Exception exc7) {
                        if (logger.isLoggingLevel(Level.SEVERE)) {
                            LogEntry entry = ValidationPlugin.getLogEntry();
                            entry.setSourceID("ValidationOperation::launchValidator");
                            entry.setTargetException((Throwable)exc7);
                            logger.write(Level.SEVERE, (Object)entry);
                        }
                        helper.setProject(null);
                        return;
                    }
                }
                finally {
                    helper.setProject(null);
                }
                reporter.getProgressMonitor().worked(delta == null ? 1 : delta.length);
                break block77;
            }
            try {
                validator.cleanup(reporter);
            }
            catch (MessageLimitException e) {
                throw e;
            }
            catch (OperationCanceledException e) {
                throw e;
            }
            catch (Exception exc) {
                if (logger.isLoggingLevel(Level.SEVERE)) {
                    LogEntry entry = ValidationPlugin.getLogEntry();
                    entry.setSourceID("ValidationOperation::launchValidator");
                    entry.setTargetException((Throwable)exc);
                    logger.write(Level.SEVERE, (Object)entry);
                }
                return;
            }
            try {
                try {
                    helper.cleanup(reporter);
                }
                catch (MessageLimitException e) {
                    throw e;
                }
                catch (OperationCanceledException e) {
                    throw e;
                }
                catch (Exception exc) {
                    if (logger.isLoggingLevel(Level.SEVERE)) {
                        LogEntry entry = ValidationPlugin.getLogEntry();
                        entry.setSourceID("ValidationOperation::launchValidator");
                        entry.setTargetException((Throwable)exc);
                        logger.write(Level.SEVERE, (Object)entry);
                    }
                    helper.setProject(null);
                    return;
                }
            }
            finally {
                helper.setProject(null);
            }
            reporter.getProgressMonitor().worked(delta == null ? 1 : delta.length);
        }
    }

    public IValidationContext getContext() {
        return this.context;
    }

    public void setContext(IWorkbenchContext context) {
        this.context = context;
    }

    void launchJobs(HashSet validators, WorkbenchReporter reporter) throws OperationCanceledException {
        Logger logger = ValidationPlugin.getPlugin().getMsgLogger();
        Iterator iterator = validators.iterator();
        ValidatorMetaData vmd = null;
        IValidator validator = null;
        IFileDelta[] delta = null;
        IWorkbenchContext workbenchcontext = null;
        while (iterator.hasNext()) {
            String mssg;
            LogEntry entry;
            block14: {
                ValidationOperation.checkCanceled(reporter);
                vmd = (ValidatorMetaData)iterator.next();
                try {
                    boolean willRun;
                    delta = this.getFileDeltas(reporter.getProgressMonitor(), vmd);
                    boolean bl = willRun = this.isForce() || this.isValidationNecessary(vmd, delta);
                    if (!willRun) {
                    }
                    break block14;
                }
                catch (CoreException exc) {
                    if (logger.isLoggingLevel(Level.SEVERE)) {
                        entry = ValidationPlugin.getLogEntry();
                        entry.setSourceID("ValidationOperation.launchJobs()");
                        entry.setTargetException((Throwable)exc);
                        logger.write(Level.SEVERE, (Object)entry);
                    }
                    mssg = ResourceHandler.getExternalizedMessage("VBF_STATUS_ENDING_VALIDATION_ABNORMALLY", new String[]{this.getProject().getName(), vmd.getValidatorDisplayName()});
                    reporter.displaySubtask(mssg);
                }
                continue;
            }
            try {
                validator = vmd.createValidator();
                workbenchcontext = vmd.createHelper(this.getProject());
                this.initValidateContext(delta, workbenchcontext);
                vmd.addHelper((IValidatorJob)validator, workbenchcontext);
                ValidationOperation.checkCanceled(reporter);
            }
            catch (InstantiationException exc) {
                ValidationRegistryReader.getReader().disableValidator(vmd);
                if (!logger.isLoggingLevel(Level.SEVERE)) continue;
                entry = ValidationPlugin.getLogEntry();
                entry.setSourceID("ValidationOperation.launchJobs()");
                entry.setTargetException((Throwable)exc);
                logger.write(Level.SEVERE, (Object)entry);
                continue;
            }
            try {
                try {
                    ValidationOperation.checkCanceled(reporter);
                    this.removeOldMessages(reporter, validator, vmd, delta);
                    if (validator instanceof IValidatorJob) {
                        this.launchValidatorJob(reporter, (IValidatorJob)validator, vmd, workbenchcontext, delta);
                    }
                }
                catch (OperationCanceledException exc) {
                    throw exc;
                }
                catch (Throwable exc) {
                    if (logger.isLoggingLevel(Level.SEVERE)) {
                        entry = ValidationPlugin.getLogEntry();
                        entry.setSourceID("ValidationOperation.launchJobs()");
                        entry.setTargetException(exc);
                        logger.write(Level.SEVERE, (Object)entry);
                    }
                    mssg = ResourceHandler.getExternalizedMessage("VBF_STATUS_ENDING_VALIDATION_ABNORMALLY", new String[]{this.getProject().getName(), vmd.getValidatorDisplayName()});
                    reporter.displaySubtask(mssg);
                    reporter.getProgressMonitor().done();
                    continue;
                }
            }
            catch (Throwable throwable) {
                reporter.getProgressMonitor().done();
                throw throwable;
            }
            reporter.getProgressMonitor().done();
        }
    }

    private void initValidateContext(IFileDelta[] delta, IWorkbenchContext context) {
        if (context instanceof WorkbenchContext) {
            ((WorkbenchContext)context).setValidationFileURIs(new ArrayList());
            int i = 0;
            while (i < delta.length) {
                IFileDelta file = delta[i];
                if (file.getDeltaType() != 3) {
                    ((WorkbenchContext)context).getValidationFileURIs().add(file.getFileName());
                }
                ++i;
            }
        }
    }

    private final void launchValidatorJob(WorkbenchReporter reporter, IValidatorJob validator, ValidatorMetaData vmd, IWorkbenchContext helper, IFileDelta[] delta) {
        if (reporter == null) {
            return;
        }
        ValidationOperation.checkCanceled(reporter);
        Logger logger = ValidationPlugin.getPlugin().getMsgLogger();
        if (helper instanceof WorkbenchContext) {
            ((WorkbenchContext)helper).setRuleGroup(this.getRuleGroup());
        }
        if (logger.isLoggingLevel(Level.FINEST)) {
            this.getLaunchedValidators().add(vmd);
        }
        ValidatorJob validatorjob = new ValidatorJob(validator, vmd.getValidatorDisplayName(), vmd.getValidatorUniqueName(), helper.getProject(), helper);
        ISchedulingRule schedulingRule = validator.getSchedulingRule(helper);
        validatorjob.setRule(schedulingRule);
        QualifiedName validatorKey = new QualifiedName(null, "Validator");
        validatorjob.setProperty(validatorKey, validator);
        validatorjob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                Job job = event.getJob();
                QualifiedName validatorKey = new QualifiedName(null, "Validator");
                IValidatorJob validator = (IValidatorJob)job.getProperty(validatorKey);
                ValidatorManager mgr = ValidatorManager.getManager();
                final ArrayList list = mgr.getMessages(validator);
                IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

                    public void run(IProgressMonitor monitor) throws CoreException {
                        for (MessageInfo info : list) {
                            try {
                                TaskListUtility.addTask(info.getMessageOwnerId(), info.getResource(), info.getLocation(), info.getMsg().getId(), info.getText(), info.getMsg().getSeverity(), info.getMarkerId(), info.getTargetObjectName(), info.getMsg().getGroupName(), info.getMsg().getOffset(), info.getMsg().getLength());
                            }
                            catch (CoreException exc) {
                                Logger logger = ValidationPlugin.getPlugin().getMsgLogger();
                                if (!logger.isLoggingLevel(Level.SEVERE)) continue;
                                LogEntry entry = ValidationPlugin.getLogEntry();
                                entry.setTargetException((Throwable)exc);
                                logger.write(Level.SEVERE, (Object)entry);
                            }
                        }
                    }
                };
                try {
                    ResourcesPlugin.getWorkspace().run(runnable, null, 1, null);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                mgr.clearMessages(validator);
                validator = null;
            }
        });
        validatorjob.setPriority(50);
        ValidationLauncherJob validationLauncherJob = new ValidationLauncherJob(validatorjob);
        validationLauncherJob.schedule();
    }

    public class ProjectRunnable
    implements Runnable {
        private WorkbenchReporter _reporter = null;
        private IValidator _validator = null;
        private ValidatorMetaData _vmd = null;
        private IFileDelta[] __delta = null;

        public ProjectRunnable(WorkbenchReporter reporter, IValidator validator, ValidatorMetaData vmd, IWorkbenchContext helper, IFileDelta[] delta, Iterator iterator) {
            this._reporter = reporter;
            this._validator = validator;
            this._vmd = vmd;
            this.__delta = delta;
        }

        public void run() {
            try {
                ValidationOperation.this.internalValidate(this._reporter, this._validator, this._vmd, ValidationOperation.this.context, this.__delta);
            }
            catch (OperationCanceledException operationCanceledException) {}
        }

        public IProject getProject() {
            return this._reporter.getProject();
        }
    }

    class ValidationLauncherJob
    extends Job {
        private Job validationJob;

        public ValidationLauncherJob(Job validationJob) {
            super(ResourceHandler.getExternalizedMessage("VBF_VALIDATION_JOB_MSG"));
            this.setSystem(true);
            this.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
            this.validationJob = validationJob;
        }

        protected IStatus run(IProgressMonitor monitor) {
            this.validationJob.schedule();
            return Status.OK_STATUS;
        }
    }
}

