/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.internal.operations;

import java.util.logging.Level;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jem.util.logger.LogEntry;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.wst.common.frameworks.internal.plugin.WTPCommonPlugin;
import org.eclipse.wst.validation.internal.ResourceHandler;
import org.eclipse.wst.validation.internal.ValidationRegistryReader;
import org.eclipse.wst.validation.internal.ValidatorMetaData;
import org.eclipse.wst.validation.internal.core.Message;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.operations.IWorkbenchContext;
import org.eclipse.wst.validation.internal.operations.WorkbenchReporter;
import org.eclipse.wst.validation.internal.plugin.ValidationPlugin;
import org.eclipse.wst.validation.internal.provisional.core.IValidatorJob;

public class ValidatorJob
extends Job {
    private IProject project;
    private IWorkbenchContext helper;
    private IValidatorJob validator;

    public ValidatorJob(String name) {
        super(name);
    }

    public ValidatorJob(IValidatorJob validator, String displayName, String name, IProject project, IWorkbenchContext aHelper) {
        super(displayName);
        this.project = project;
        this.helper = aHelper;
        this.validator = validator;
    }

    protected IStatus run(IProgressMonitor monitor) {
        IStatus status;
        block124: {
            monitor.beginTask("Validating", -1);
            status = IValidatorJob.OK_STATUS;
            WorkbenchReporter reporter = new WorkbenchReporter(this.project, monitor);
            ValidatorMetaData vmd = ValidationRegistryReader.getReader().getValidatorMetaData(this.validator);
            Logger logger = ValidationPlugin.getPlugin().getMsgLogger();
            try {
                String message = ResourceHandler.getExternalizedMessage("VBF_STATUS_STARTING_VALIDATION", new String[]{this.helper.getProject().getName(), vmd.getValidatorDisplayName()});
                monitor.subTask(message);
                status = this.validator.validateInJob(this.helper, reporter);
                message = ResourceHandler.getExternalizedMessage("VBF_STATUS_ENDING_VALIDATION", new String[]{this.helper.getProject().getName(), vmd.getValidatorDisplayName()});
                monitor.subTask(message);
            }
            catch (OperationCanceledException exc) {
                throw exc;
            }
            catch (ValidationException exc) {
                if (exc.getAssociatedException() != null && exc.getAssociatedException() instanceof ValidationException) {
                    ValidationException vexc = (ValidationException)exc.getAssociatedException();
                    vexc.setClassLoader(this.validator.getClass().getClassLoader());
                }
                exc.setClassLoader(this.validator.getClass().getClassLoader());
                if (logger.isLoggingLevel(Level.SEVERE)) {
                    LogEntry entry = ValidationPlugin.getLogEntry();
                    entry.setSourceID("ValidatorJob.run()");
                    entry.setTargetException((Throwable)exc);
                    logger.write(Level.SEVERE, (Object)entry);
                    if (exc.getAssociatedException() != null) {
                        entry.setTargetException(exc.getAssociatedException());
                        logger.write(Level.SEVERE, (Object)entry);
                    }
                }
                String message = ResourceHandler.getExternalizedMessage("VBF_STATUS_ENDING_VALIDATION_ABNORMALLY", new String[]{this.helper.getProject().getName(), vmd.getValidatorDisplayName()});
                monitor.subTask(message);
                if (exc.getAssociatedMessage() != null) {
                    reporter.addMessage(this.validator, exc.getAssociatedMessage());
                }
                try {
                    try {
                        this.validator.cleanup(reporter);
                    }
                    catch (OperationCanceledException e) {
                        throw e;
                    }
                    catch (Exception exc2) {
                        if (logger.isLoggingLevel(Level.SEVERE)) {
                            LogEntry entry = ValidationPlugin.getLogEntry();
                            entry.setSourceID("ValidatorJob.run()");
                            entry.setTargetException((Throwable)exc2);
                            logger.write(Level.SEVERE, (Object)entry);
                        }
                        String[] msgParm = new String[]{exc2.getClass().getName(), vmd.getValidatorDisplayName(), exc2.getMessage() == null ? "" : exc2.getMessage()};
                        Message message2 = ValidationPlugin.getMessage();
                        message2.setSeverity(2);
                        message2.setId("VBF_EXC_RUNTIME");
                        message2.setParams(msgParm);
                        IStatus iStatus = status = WTPCommonPlugin.createErrorStatus((String)message2.getText());
                        try {
                            try {
                                this.helper.cleanup(reporter);
                                vmd.removeHelper(this.validator);
                            }
                            catch (OperationCanceledException e) {
                                throw e;
                            }
                            catch (Exception exc3) {
                                if (logger.isLoggingLevel(Level.SEVERE)) {
                                    LogEntry entry = ValidationPlugin.getLogEntry();
                                    entry.setSourceID("ValidatorJob.run()");
                                    entry.setTargetException((Throwable)exc3);
                                    logger.write(Level.SEVERE, (Object)entry);
                                }
                                String[] msgParm2 = new String[]{exc3.getClass().getName(), vmd.getValidatorDisplayName(), exc3.getMessage() == null ? "" : exc3.getMessage()};
                                Message message3 = ValidationPlugin.getMessage();
                                message3.setSeverity(2);
                                message3.setId("VBF_EXC_RUNTIME");
                                message3.setParams(msgParm2);
                                reporter.addMessage(this.validator, message3);
                                IStatus iStatus2 = status = WTPCommonPlugin.createErrorStatus((String)message3.getText());
                                this.helper.setProject(null);
                                vmd.removeHelper(this.validator);
                                this.helper = null;
                                reporter = null;
                                return iStatus2;
                            }
                        }
                        finally {
                            this.helper.setProject(null);
                            vmd.removeHelper(this.validator);
                            this.helper = null;
                            reporter = null;
                        }
                        return iStatus;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            this.helper.cleanup(reporter);
                            vmd.removeHelper(this.validator);
                        }
                        catch (OperationCanceledException e) {
                            throw e;
                        }
                        catch (Exception exc4) {
                            if (logger.isLoggingLevel(Level.SEVERE)) {
                                LogEntry entry = ValidationPlugin.getLogEntry();
                                entry.setSourceID("ValidatorJob.run()");
                                entry.setTargetException((Throwable)exc4);
                                logger.write(Level.SEVERE, (Object)entry);
                            }
                            String[] msgParm = new String[]{exc4.getClass().getName(), vmd.getValidatorDisplayName(), exc4.getMessage() == null ? "" : exc4.getMessage()};
                            Message message4 = ValidationPlugin.getMessage();
                            message4.setSeverity(2);
                            message4.setId("VBF_EXC_RUNTIME");
                            message4.setParams(msgParm);
                            reporter.addMessage(this.validator, message4);
                            IStatus iStatus = status = WTPCommonPlugin.createErrorStatus((String)message4.getText());
                            this.helper.setProject(null);
                            vmd.removeHelper(this.validator);
                            this.helper = null;
                            reporter = null;
                            return iStatus;
                        }
                    }
                    finally {
                        this.helper.setProject(null);
                        vmd.removeHelper(this.validator);
                        this.helper = null;
                        reporter = null;
                    }
                    throw throwable;
                }
                try {
                    try {
                        this.helper.cleanup(reporter);
                        vmd.removeHelper(this.validator);
                    }
                    catch (OperationCanceledException e) {
                        throw e;
                    }
                    catch (Exception exc5) {
                        if (logger.isLoggingLevel(Level.SEVERE)) {
                            LogEntry entry = ValidationPlugin.getLogEntry();
                            entry.setSourceID("ValidatorJob.run()");
                            entry.setTargetException((Throwable)exc5);
                            logger.write(Level.SEVERE, (Object)entry);
                        }
                        String[] msgParm = new String[]{exc5.getClass().getName(), vmd.getValidatorDisplayName(), exc5.getMessage() == null ? "" : exc5.getMessage()};
                        Message message5 = ValidationPlugin.getMessage();
                        message5.setSeverity(2);
                        message5.setId("VBF_EXC_RUNTIME");
                        message5.setParams(msgParm);
                        reporter.addMessage(this.validator, message5);
                        IStatus iStatus = status = WTPCommonPlugin.createErrorStatus((String)message5.getText());
                        this.helper.setProject(null);
                        vmd.removeHelper(this.validator);
                        this.helper = null;
                        reporter = null;
                        return iStatus;
                    }
                }
                finally {
                    this.helper.setProject(null);
                    vmd.removeHelper(this.validator);
                    this.helper = null;
                    reporter = null;
                }
                monitor.done();
                break block124;
            }
            catch (Exception exc) {
                try {
                    if (logger.isLoggingLevel(Level.SEVERE)) {
                        LogEntry entry = ValidationPlugin.getLogEntry();
                        entry.setSourceID("ValidatorJob.run()");
                        entry.setTargetException((Throwable)exc);
                        logger.write(Level.SEVERE, (Object)entry);
                        Status stat = new Status(4, "org.eclipse.wst.validation", 0, "", (Throwable)exc);
                        logger.write(Level.SEVERE, (Object)stat);
                    }
                    String mssg = ResourceHandler.getExternalizedMessage("VBF_STATUS_ENDING_VALIDATION_ABNORMALLY", new String[]{this.helper.getProject().getName(), vmd.getValidatorDisplayName()});
                    monitor.subTask(mssg);
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            this.validator.cleanup(reporter);
                        }
                        catch (OperationCanceledException e) {
                            throw e;
                        }
                        catch (Exception exc6) {
                            if (logger.isLoggingLevel(Level.SEVERE)) {
                                LogEntry entry = ValidationPlugin.getLogEntry();
                                entry.setSourceID("ValidatorJob.run()");
                                entry.setTargetException((Throwable)exc6);
                                logger.write(Level.SEVERE, (Object)entry);
                            }
                            String[] msgParm = new String[]{exc6.getClass().getName(), vmd.getValidatorDisplayName(), exc6.getMessage() == null ? "" : exc6.getMessage()};
                            Message message = ValidationPlugin.getMessage();
                            message.setSeverity(2);
                            message.setId("VBF_EXC_RUNTIME");
                            message.setParams(msgParm);
                            IStatus iStatus = status = WTPCommonPlugin.createErrorStatus((String)message.getText());
                            try {
                                try {
                                    this.helper.cleanup(reporter);
                                    vmd.removeHelper(this.validator);
                                }
                                catch (OperationCanceledException e) {
                                    throw e;
                                }
                                catch (Exception exc7) {
                                    if (logger.isLoggingLevel(Level.SEVERE)) {
                                        LogEntry entry = ValidationPlugin.getLogEntry();
                                        entry.setSourceID("ValidatorJob.run()");
                                        entry.setTargetException((Throwable)exc7);
                                        logger.write(Level.SEVERE, (Object)entry);
                                    }
                                    String[] msgParm3 = new String[]{exc7.getClass().getName(), vmd.getValidatorDisplayName(), exc7.getMessage() == null ? "" : exc7.getMessage()};
                                    Message message6 = ValidationPlugin.getMessage();
                                    message6.setSeverity(2);
                                    message6.setId("VBF_EXC_RUNTIME");
                                    message6.setParams(msgParm3);
                                    reporter.addMessage(this.validator, message6);
                                    IStatus iStatus3 = status = WTPCommonPlugin.createErrorStatus((String)message6.getText());
                                    this.helper.setProject(null);
                                    vmd.removeHelper(this.validator);
                                    this.helper = null;
                                    reporter = null;
                                    return iStatus3;
                                }
                            }
                            finally {
                                this.helper.setProject(null);
                                vmd.removeHelper(this.validator);
                                this.helper = null;
                                reporter = null;
                            }
                            return iStatus;
                        }
                    }
                    catch (Throwable throwable2) {
                        try {
                            try {
                                this.helper.cleanup(reporter);
                                vmd.removeHelper(this.validator);
                            }
                            catch (OperationCanceledException e) {
                                throw e;
                            }
                            catch (Exception exc8) {
                                if (logger.isLoggingLevel(Level.SEVERE)) {
                                    LogEntry entry = ValidationPlugin.getLogEntry();
                                    entry.setSourceID("ValidatorJob.run()");
                                    entry.setTargetException((Throwable)exc8);
                                    logger.write(Level.SEVERE, (Object)entry);
                                }
                                String[] msgParm = new String[]{exc8.getClass().getName(), vmd.getValidatorDisplayName(), exc8.getMessage() == null ? "" : exc8.getMessage()};
                                Message message = ValidationPlugin.getMessage();
                                message.setSeverity(2);
                                message.setId("VBF_EXC_RUNTIME");
                                message.setParams(msgParm);
                                reporter.addMessage(this.validator, message);
                                IStatus iStatus = status = WTPCommonPlugin.createErrorStatus((String)message.getText());
                                this.helper.setProject(null);
                                vmd.removeHelper(this.validator);
                                this.helper = null;
                                reporter = null;
                                return iStatus;
                            }
                        }
                        finally {
                            this.helper.setProject(null);
                            vmd.removeHelper(this.validator);
                            this.helper = null;
                            reporter = null;
                        }
                        throw throwable2;
                    }
                    try {
                        try {
                            this.helper.cleanup(reporter);
                            vmd.removeHelper(this.validator);
                        }
                        catch (OperationCanceledException e) {
                            throw e;
                        }
                        catch (Exception exc9) {
                            if (logger.isLoggingLevel(Level.SEVERE)) {
                                LogEntry entry = ValidationPlugin.getLogEntry();
                                entry.setSourceID("ValidatorJob.run()");
                                entry.setTargetException((Throwable)exc9);
                                logger.write(Level.SEVERE, (Object)entry);
                            }
                            String[] msgParm = new String[]{exc9.getClass().getName(), vmd.getValidatorDisplayName(), exc9.getMessage() == null ? "" : exc9.getMessage()};
                            Message message = ValidationPlugin.getMessage();
                            message.setSeverity(2);
                            message.setId("VBF_EXC_RUNTIME");
                            message.setParams(msgParm);
                            reporter.addMessage(this.validator, message);
                            IStatus iStatus = status = WTPCommonPlugin.createErrorStatus((String)message.getText());
                            this.helper.setProject(null);
                            vmd.removeHelper(this.validator);
                            this.helper = null;
                            reporter = null;
                            return iStatus;
                        }
                    }
                    finally {
                        this.helper.setProject(null);
                        vmd.removeHelper(this.validator);
                        this.helper = null;
                        reporter = null;
                    }
                    monitor.done();
                    throw throwable;
                }
                try {
                    try {
                        this.validator.cleanup(reporter);
                    }
                    catch (OperationCanceledException e) {
                        throw e;
                    }
                    catch (Exception exc10) {
                        if (logger.isLoggingLevel(Level.SEVERE)) {
                            LogEntry entry = ValidationPlugin.getLogEntry();
                            entry.setSourceID("ValidatorJob.run()");
                            entry.setTargetException((Throwable)exc10);
                            logger.write(Level.SEVERE, (Object)entry);
                        }
                        String[] msgParm = new String[]{exc10.getClass().getName(), vmd.getValidatorDisplayName(), exc10.getMessage() == null ? "" : exc10.getMessage()};
                        Message message = ValidationPlugin.getMessage();
                        message.setSeverity(2);
                        message.setId("VBF_EXC_RUNTIME");
                        message.setParams(msgParm);
                        IStatus iStatus = status = WTPCommonPlugin.createErrorStatus((String)message.getText());
                        try {
                            try {
                                this.helper.cleanup(reporter);
                                vmd.removeHelper(this.validator);
                            }
                            catch (OperationCanceledException e) {
                                throw e;
                            }
                            catch (Exception exc11) {
                                if (logger.isLoggingLevel(Level.SEVERE)) {
                                    LogEntry entry = ValidationPlugin.getLogEntry();
                                    entry.setSourceID("ValidatorJob.run()");
                                    entry.setTargetException((Throwable)exc11);
                                    logger.write(Level.SEVERE, (Object)entry);
                                }
                                String[] msgParm4 = new String[]{exc11.getClass().getName(), vmd.getValidatorDisplayName(), exc11.getMessage() == null ? "" : exc11.getMessage()};
                                Message message7 = ValidationPlugin.getMessage();
                                message7.setSeverity(2);
                                message7.setId("VBF_EXC_RUNTIME");
                                message7.setParams(msgParm4);
                                reporter.addMessage(this.validator, message7);
                                IStatus iStatus4 = status = WTPCommonPlugin.createErrorStatus((String)message7.getText());
                                this.helper.setProject(null);
                                vmd.removeHelper(this.validator);
                                this.helper = null;
                                reporter = null;
                                return iStatus4;
                            }
                        }
                        finally {
                            this.helper.setProject(null);
                            vmd.removeHelper(this.validator);
                            this.helper = null;
                            reporter = null;
                        }
                        return iStatus;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            this.helper.cleanup(reporter);
                            vmd.removeHelper(this.validator);
                        }
                        catch (OperationCanceledException e) {
                            throw e;
                        }
                        catch (Exception exc12) {
                            if (logger.isLoggingLevel(Level.SEVERE)) {
                                LogEntry entry = ValidationPlugin.getLogEntry();
                                entry.setSourceID("ValidatorJob.run()");
                                entry.setTargetException((Throwable)exc12);
                                logger.write(Level.SEVERE, (Object)entry);
                            }
                            String[] msgParm = new String[]{exc12.getClass().getName(), vmd.getValidatorDisplayName(), exc12.getMessage() == null ? "" : exc12.getMessage()};
                            Message message = ValidationPlugin.getMessage();
                            message.setSeverity(2);
                            message.setId("VBF_EXC_RUNTIME");
                            message.setParams(msgParm);
                            reporter.addMessage(this.validator, message);
                            IStatus iStatus = status = WTPCommonPlugin.createErrorStatus((String)message.getText());
                            this.helper.setProject(null);
                            vmd.removeHelper(this.validator);
                            this.helper = null;
                            reporter = null;
                            return iStatus;
                        }
                    }
                    finally {
                        this.helper.setProject(null);
                        vmd.removeHelper(this.validator);
                        this.helper = null;
                        reporter = null;
                    }
                    throw throwable;
                }
                try {
                    try {
                        this.helper.cleanup(reporter);
                        vmd.removeHelper(this.validator);
                    }
                    catch (OperationCanceledException e) {
                        throw e;
                    }
                    catch (Exception exc13) {
                        if (logger.isLoggingLevel(Level.SEVERE)) {
                            LogEntry entry = ValidationPlugin.getLogEntry();
                            entry.setSourceID("ValidatorJob.run()");
                            entry.setTargetException((Throwable)exc13);
                            logger.write(Level.SEVERE, (Object)entry);
                        }
                        String[] msgParm = new String[]{exc13.getClass().getName(), vmd.getValidatorDisplayName(), exc13.getMessage() == null ? "" : exc13.getMessage()};
                        Message message = ValidationPlugin.getMessage();
                        message.setSeverity(2);
                        message.setId("VBF_EXC_RUNTIME");
                        message.setParams(msgParm);
                        reporter.addMessage(this.validator, message);
                        IStatus iStatus = status = WTPCommonPlugin.createErrorStatus((String)message.getText());
                        this.helper.setProject(null);
                        vmd.removeHelper(this.validator);
                        this.helper = null;
                        reporter = null;
                        return iStatus;
                    }
                }
                finally {
                    this.helper.setProject(null);
                    vmd.removeHelper(this.validator);
                    this.helper = null;
                    reporter = null;
                }
                monitor.done();
                break block124;
            }
            try {
                try {
                    this.validator.cleanup(reporter);
                }
                catch (OperationCanceledException e) {
                    throw e;
                }
                catch (Exception exc) {
                    if (logger.isLoggingLevel(Level.SEVERE)) {
                        LogEntry entry = ValidationPlugin.getLogEntry();
                        entry.setSourceID("ValidatorJob.run()");
                        entry.setTargetException((Throwable)exc);
                        logger.write(Level.SEVERE, (Object)entry);
                    }
                    String[] msgParm = new String[]{exc.getClass().getName(), vmd.getValidatorDisplayName(), exc.getMessage() == null ? "" : exc.getMessage()};
                    Message message = ValidationPlugin.getMessage();
                    message.setSeverity(2);
                    message.setId("VBF_EXC_RUNTIME");
                    message.setParams(msgParm);
                    IStatus iStatus = status = WTPCommonPlugin.createErrorStatus((String)message.getText());
                    try {
                        try {
                            this.helper.cleanup(reporter);
                            vmd.removeHelper(this.validator);
                        }
                        catch (OperationCanceledException e) {
                            throw e;
                        }
                        catch (Exception exc14) {
                            if (logger.isLoggingLevel(Level.SEVERE)) {
                                LogEntry entry = ValidationPlugin.getLogEntry();
                                entry.setSourceID("ValidatorJob.run()");
                                entry.setTargetException((Throwable)exc14);
                                logger.write(Level.SEVERE, (Object)entry);
                            }
                            String[] msgParm5 = new String[]{exc14.getClass().getName(), vmd.getValidatorDisplayName(), exc14.getMessage() == null ? "" : exc14.getMessage()};
                            Message message8 = ValidationPlugin.getMessage();
                            message8.setSeverity(2);
                            message8.setId("VBF_EXC_RUNTIME");
                            message8.setParams(msgParm5);
                            reporter.addMessage(this.validator, message8);
                            IStatus iStatus5 = status = WTPCommonPlugin.createErrorStatus((String)message8.getText());
                            this.helper.setProject(null);
                            vmd.removeHelper(this.validator);
                            this.helper = null;
                            reporter = null;
                            return iStatus5;
                        }
                    }
                    finally {
                        this.helper.setProject(null);
                        vmd.removeHelper(this.validator);
                        this.helper = null;
                        reporter = null;
                    }
                    return iStatus;
                }
            }
            catch (Throwable throwable) {
                try {
                    try {
                        this.helper.cleanup(reporter);
                        vmd.removeHelper(this.validator);
                    }
                    catch (OperationCanceledException e) {
                        throw e;
                    }
                    catch (Exception exc) {
                        if (logger.isLoggingLevel(Level.SEVERE)) {
                            LogEntry entry = ValidationPlugin.getLogEntry();
                            entry.setSourceID("ValidatorJob.run()");
                            entry.setTargetException((Throwable)exc);
                            logger.write(Level.SEVERE, (Object)entry);
                        }
                        String[] msgParm = new String[]{exc.getClass().getName(), vmd.getValidatorDisplayName(), exc.getMessage() == null ? "" : exc.getMessage()};
                        Message message = ValidationPlugin.getMessage();
                        message.setSeverity(2);
                        message.setId("VBF_EXC_RUNTIME");
                        message.setParams(msgParm);
                        reporter.addMessage(this.validator, message);
                        IStatus iStatus = status = WTPCommonPlugin.createErrorStatus((String)message.getText());
                        this.helper.setProject(null);
                        vmd.removeHelper(this.validator);
                        this.helper = null;
                        reporter = null;
                        return iStatus;
                    }
                }
                finally {
                    this.helper.setProject(null);
                    vmd.removeHelper(this.validator);
                    this.helper = null;
                    reporter = null;
                }
                throw throwable;
            }
            try {
                try {
                    this.helper.cleanup(reporter);
                    vmd.removeHelper(this.validator);
                }
                catch (OperationCanceledException e) {
                    throw e;
                }
                catch (Exception exc) {
                    if (logger.isLoggingLevel(Level.SEVERE)) {
                        LogEntry entry = ValidationPlugin.getLogEntry();
                        entry.setSourceID("ValidatorJob.run()");
                        entry.setTargetException((Throwable)exc);
                        logger.write(Level.SEVERE, (Object)entry);
                    }
                    String[] msgParm = new String[]{exc.getClass().getName(), vmd.getValidatorDisplayName(), exc.getMessage() == null ? "" : exc.getMessage()};
                    Message message = ValidationPlugin.getMessage();
                    message.setSeverity(2);
                    message.setId("VBF_EXC_RUNTIME");
                    message.setParams(msgParm);
                    reporter.addMessage(this.validator, message);
                    IStatus iStatus = status = WTPCommonPlugin.createErrorStatus((String)message.getText());
                    this.helper.setProject(null);
                    vmd.removeHelper(this.validator);
                    this.helper = null;
                    reporter = null;
                    return iStatus;
                }
            }
            finally {
                this.helper.setProject(null);
                vmd.removeHelper(this.validator);
                this.helper = null;
                reporter = null;
            }
            monitor.done();
        }
        return status;
    }

    public boolean belongsTo(Object family) {
        return (String.valueOf(this.project.getName()) + "validators").equals(family);
    }
}

